/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import java.io.File;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyEvent;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.FileBrowserWidget;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ExportConnectionsWizardPage
extends WizardPage {
    private FileBrowserWidget fileBrowserWidget;
    private Button overwriteFileButton;

    protected ExportConnectionsWizardPage() {
        super(ExportConnectionsWizardPage.class.getName());
        this.setTitle(Messages.getString("ExportConnectionsWizardPage.ExportConnections"));
        this.setDescription(Messages.getString("ExportConnectionsWizardPage.DefineConnectionsExport"));
        this.setImageDescriptor(BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/export_connections_wizard.gif"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("ExportConnectionsWizardPage.ToFile"), (int)1);
        this.fileBrowserWidget = new FileBrowserWidget(Messages.getString("ExportConnectionsWizardPage.ChooseFile"), new String[]{"*.lbc", "*"}, 8192);
        this.fileBrowserWidget.createWidget(composite);
        this.fileBrowserWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                ExportConnectionsWizardPage.this.validate();
            }
        });
        BaseWidgetUtils.createRadioIndent((Composite)composite, (int)1);
        this.overwriteFileButton = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("ExportConnectionsWizardPage.OverwriteExistingFile"), (int)2);
        this.overwriteFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportConnectionsWizardPage.this.validate();
            }
        });
        this.setControl((Control)composite);
    }

    private void validate() {
        boolean ok = true;
        File file = new File(this.fileBrowserWidget.getFilename());
        if ("".equals(this.fileBrowserWidget.getFilename())) {
            this.setErrorMessage(null);
            ok = false;
        } else if (file.isDirectory()) {
            this.setErrorMessage(Messages.getString("ExportConnectionsWizardPage.ErrorFileNotAFile"));
            ok = false;
        } else if (file.exists() && !this.overwriteFileButton.getSelection()) {
            this.setErrorMessage(Messages.getString("ExportConnectionsWizardPage.ErrorFileAlreadyExists"));
            ok = false;
        } else if (file.exists() && !file.canWrite()) {
            this.setErrorMessage(Messages.getString("ExportConnectionsWizardPage.ErrorFileNotWritable"));
            ok = false;
        } else if (file.getParentFile() == null) {
            this.setErrorMessage(Messages.getString("ExportConnectionsWizardPage.ErrorFileDirectoryNotWritable"));
            ok = false;
        }
        if (ok) {
            this.setErrorMessage(null);
        }
        this.setPageComplete(ok);
    }

    public String getExportFileName() {
        return this.fileBrowserWidget.getFilename();
    }

    public void saveDialogSettings() {
        this.fileBrowserWidget.saveDialogSettings();
    }
}

