/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.StringUtil;
import com.google.common.truth.TestVerb;
import org.junit.internal.AssumptionViolatedException;

@GwtIncompatible(value="JUnit4")
public class TruthJUnit {
    @GwtIncompatible(value="JUnit4")
    public static final FailureStrategy THROW_ASSUMPTION_ERROR = new FailureStrategy(){

        @Override
        public void fail(String message) {
            throw new AssumptionViolatedException(message);
        }

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual) {
            throw new AssumptionViolatedException(StringUtil.messageFor(message, expected, actual));
        }

        @Override
        public void fail(String message, Throwable cause) {
            throw new ThrowableAssumptionViolatedException(message, cause);
        }
    };
    @GwtIncompatible(value="JUnit4")
    public static final TestVerb ASSUME = new TestVerb(THROW_ASSUMPTION_ERROR);

    @GwtIncompatible(value="JUnit4")
    public static final TestVerb assume() {
        return ASSUME;
    }

    private TruthJUnit() {
    }

    @GwtIncompatible(value="JUnit4")
    private static class ThrowableAssumptionViolatedException
    extends AssumptionViolatedException {
        public ThrowableAssumptionViolatedException(String message, Throwable throwable) {
            super(message);
            if (throwable != null) {
                this.initCause(throwable);
            }
        }
    }
}

