/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen;

import java.io.FilterWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flex.compiler.codegen.IEmitter;
import org.apache.flex.compiler.codegen.IEmitterTokens;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.visitor.as.IASBlockWalker;

public class Emitter
implements IEmitter {
    private final FilterWriter out;
    private boolean bufferWrite;
    private StringBuilder builder;
    protected List<ICompilerProblem> problems;
    private int currentIndent = 0;
    private IASBlockWalker walker;
    private int currentLine = 0;
    private int currentColumn = 0;

    protected boolean isBufferWrite() {
        return this.bufferWrite;
    }

    protected void setBufferWrite(boolean value) {
        this.bufferWrite = value;
    }

    protected StringBuilder getBuilder() {
        return this.builder;
    }

    protected void flushBuilder() {
        this.setBufferWrite(false);
        this.write(this.builder.toString());
        this.builder.setLength(0);
    }

    public List<ICompilerProblem> getProblems() {
        return this.problems;
    }

    protected int getCurrentIndent() {
        return this.currentIndent;
    }

    public IASBlockWalker getWalker() {
        return this.walker;
    }

    public void setWalker(IASBlockWalker value) {
        this.walker = value;
    }

    protected int getCurrentLine() {
        return this.currentLine;
    }

    protected int getCurrentColumn() {
        return this.currentColumn;
    }

    public Emitter(FilterWriter out) {
        this.out = out;
        this.builder = new StringBuilder();
        this.problems = new ArrayList<ICompilerProblem>();
    }

    @Override
    public void write(IEmitterTokens value) {
        this.write(value.getToken());
    }

    @Override
    public void write(String value) {
        try {
            if (!this.bufferWrite) {
                int newLineCount = value.length() - value.replace("\n", "").length();
                this.currentLine += newLineCount;
                this.currentColumn = newLineCount > 0 ? value.length() - value.lastIndexOf("\n") - 1 : (this.currentColumn += value.length());
                this.out.write(value);
            } else {
                this.builder.append(value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getIndent(int numIndent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numIndent; ++i) {
            sb.append(ASEmitterTokens.INDENT.getToken());
        }
        return sb.toString();
    }

    @Override
    public void indentPush() {
        ++this.currentIndent;
    }

    @Override
    public void indentPop() {
        if (this.currentIndent > 0) {
            --this.currentIndent;
        }
    }

    @Override
    public void writeNewline() {
        this.write(ASEmitterTokens.NEW_LINE);
        this.write(this.getIndent(this.currentIndent));
    }

    @Override
    public void writeNewline(IEmitterTokens value) {
        this.writeNewline(value.getToken());
    }

    @Override
    public void writeNewline(String value) {
        this.write(value);
        this.writeNewline();
    }

    @Override
    public void writeNewline(IEmitterTokens value, boolean pushIndent) {
        this.writeNewline(value.getToken(), pushIndent);
    }

    @Override
    public void writeNewline(String value, boolean pushIndent) {
        if (pushIndent) {
            this.indentPush();
        } else {
            this.indentPop();
        }
        this.write(value);
        this.writeNewline();
    }

    public void writeSymbol(String value) {
        this.write(value);
    }

    @Override
    public void writeToken(IEmitterTokens value) {
        this.writeToken(value.getToken());
    }

    @Override
    public void writeToken(String value) {
        this.write(value);
        this.write(ASEmitterTokens.SPACE);
    }

    @Override
    public String stringifyNode(IASNode node) {
        this.setBufferWrite(true);
        this.getWalker().walk(node);
        String result = this.getBuilder().toString();
        this.getBuilder().setLength(0);
        this.setBufferWrite(false);
        return result;
    }
}

