/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.mxml;

import org.apache.flex.compiler.internal.scopes.MXMLFileScope;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLDefinitionNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.flex.compiler.mxml.IMXMLTagData;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.mxml.IMXMLDefinitionNode;
import org.apache.flex.compiler.tree.mxml.IMXMLLibraryNode;

class MXMLLibraryNode
extends MXMLNodeBase
implements IMXMLLibraryNode {
    private static final IMXMLDefinitionNode[] NO_DEFINITION_NODES = new IMXMLDefinitionNode[0];
    private IMXMLDefinitionNode[] definitionNodes = NO_DEFINITION_NODES;

    MXMLLibraryNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public String getName() {
        return "Library";
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLLibraryID;
    }

    @Override
    public int getChildCount() {
        return this.definitionNodes.length;
    }

    @Override
    public IASNode getChild(int i) {
        return this.definitionNodes[i];
    }

    @Override
    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLFileScope fileScope = builder.getFileScope();
        MXMLDefinitionNode childNode = null;
        if (fileScope.isDefinitionTag(childTag)) {
            childNode = new MXMLDefinitionNode(this);
        } else {
            super.processChildTag(builder, tag, childTag, info);
        }
        if (childNode != null) {
            childNode.initializeFromTag(builder, childTag);
            info.addChildNode(childNode);
        }
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        this.definitionNodes = info.getChildNodeList().toArray(new IMXMLDefinitionNode[0]);
    }

    @Override
    public IMXMLDefinitionNode[] getDefinitionNodes() {
        return this.definitionNodes;
    }
}

