// $ANTLR 3.5.2 /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g 2017-06-20 10:23:09

/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.apache.flex.compiler.internal.css;

import java.util.Map;
import java.util.HashMap;
import org.apache.flex.compiler.problems.CSSParserProblem;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


/**
 * This is a grammar for advanced CSS in Flex. It parses the CSS document and
 * generate DOM objects.
 */
@SuppressWarnings("all")
public class CSSParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ALPHA_VALUE", "ARGUMENTS", "AT_FONT_FACE", 
		"AT_KEYFRAMES", "AT_MEDIA", "AT_NAMESPACE", "AT_WEBKIT_KEYFRAMES", "BEGINS_WITH", 
		"BLOCK_END", "BLOCK_OPEN", "CALC", "CHILD", "CLASS_REFERENCE", "COLON", 
		"COMMA", "COMMENT", "CONTAINS", "DIGIT", "DOT", "DOUBLE_COLON", "EMBED", 
		"ENDS_WITH", "EQUALS", "ESCAPED_HEX", "FORMAT", "HASH_WORD", "HEX_DIGIT", 
		"HREFLANG_MATCH", "ID", "IMPORTANT", "I_ARRAY", "I_CHILD_SELECTOR", "I_DECL", 
		"I_MEDIUM_CONDITIONS", "I_PRECEDED_SELECTOR", "I_RULE", "I_RULES", "I_SELECTOR", 
		"I_SELECTOR_GROUP", "I_SIBLING_SELECTOR", "I_SIMPLE_SELECTOR", "LETTER", 
		"LIST_MATCH", "LOCAL", "NOT", "NULL", "NUMBER", "NUMBER_WITH_PERCENT", 
		"NUMBER_WITH_UNIT", "ONLY", "OPERATOR", "PERCENT", "PIPE", "PRECEDED", 
		"PROPERTY_REFERENCE", "RECT_VALUE", "RGB", "RGBA", "ROTATE_VALUE", "SCALE", 
		"SCALE_VALUE", "SEMI_COLONS", "SQUARE_END", "SQUARE_OPEN", "STAR", "STRING", 
		"STRING_QUOTE", "TILDE", "TRANSLATE3D_VALUE", "URL", "WS", "'and'"
	};
	public static final int EOF=-1;
	public static final int T__75=75;
	public static final int ALPHA_VALUE=4;
	public static final int ARGUMENTS=5;
	public static final int AT_FONT_FACE=6;
	public static final int AT_KEYFRAMES=7;
	public static final int AT_MEDIA=8;
	public static final int AT_NAMESPACE=9;
	public static final int AT_WEBKIT_KEYFRAMES=10;
	public static final int BEGINS_WITH=11;
	public static final int BLOCK_END=12;
	public static final int BLOCK_OPEN=13;
	public static final int CALC=14;
	public static final int CHILD=15;
	public static final int CLASS_REFERENCE=16;
	public static final int COLON=17;
	public static final int COMMA=18;
	public static final int COMMENT=19;
	public static final int CONTAINS=20;
	public static final int DIGIT=21;
	public static final int DOT=22;
	public static final int DOUBLE_COLON=23;
	public static final int EMBED=24;
	public static final int ENDS_WITH=25;
	public static final int EQUALS=26;
	public static final int ESCAPED_HEX=27;
	public static final int FORMAT=28;
	public static final int HASH_WORD=29;
	public static final int HEX_DIGIT=30;
	public static final int HREFLANG_MATCH=31;
	public static final int ID=32;
	public static final int IMPORTANT=33;
	public static final int I_ARRAY=34;
	public static final int I_CHILD_SELECTOR=35;
	public static final int I_DECL=36;
	public static final int I_MEDIUM_CONDITIONS=37;
	public static final int I_PRECEDED_SELECTOR=38;
	public static final int I_RULE=39;
	public static final int I_RULES=40;
	public static final int I_SELECTOR=41;
	public static final int I_SELECTOR_GROUP=42;
	public static final int I_SIBLING_SELECTOR=43;
	public static final int I_SIMPLE_SELECTOR=44;
	public static final int LETTER=45;
	public static final int LIST_MATCH=46;
	public static final int LOCAL=47;
	public static final int NOT=48;
	public static final int NULL=49;
	public static final int NUMBER=50;
	public static final int NUMBER_WITH_PERCENT=51;
	public static final int NUMBER_WITH_UNIT=52;
	public static final int ONLY=53;
	public static final int OPERATOR=54;
	public static final int PERCENT=55;
	public static final int PIPE=56;
	public static final int PRECEDED=57;
	public static final int PROPERTY_REFERENCE=58;
	public static final int RECT_VALUE=59;
	public static final int RGB=60;
	public static final int RGBA=61;
	public static final int ROTATE_VALUE=62;
	public static final int SCALE=63;
	public static final int SCALE_VALUE=64;
	public static final int SEMI_COLONS=65;
	public static final int SQUARE_END=66;
	public static final int SQUARE_OPEN=67;
	public static final int STAR=68;
	public static final int STRING=69;
	public static final int STRING_QUOTE=70;
	public static final int TILDE=71;
	public static final int TRANSLATE3D_VALUE=72;
	public static final int URL=73;
	public static final int WS=74;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public CSSParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public CSSParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	protected TreeAdaptor adaptor = new CommonTreeAdaptor();

	public void setTreeAdaptor(TreeAdaptor adaptor) {
		this.adaptor = adaptor;
	}
	public TreeAdaptor getTreeAdaptor() {
		return adaptor;
	}
	@Override public String[] getTokenNames() { return CSSParser.tokenNames; }
	@Override public String getGrammarFileName() { return "/Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g"; }



	/**
	 * Parser problems.
	 */
	protected List<CSSParserProblem> problems = new ArrayList<CSSParserProblem>();

	/**
	 * Collect parser problems.
	 */
	@Override
	public void displayRecognitionError(String[] tokenNames, RecognitionException e)
	{
	    problems.add(CSSParserProblem.create(this, tokenNames, e));
	}

	/**
	 * Check if the cursor is at the end of a simple selector.
	 * @return -1 if not end
	 * @return 0 if end
	 * @return 1 if ended by Child combinator
	 * @return 2 if ended by Preceded combinator
	 * @return 3 if ended by Sibling combinator
	 */
	private final int endOfSimpleSelector()
	{
	    final CommonToken nextToken = (CommonToken) getTokenStream().LT(1);
	    if (nextToken == null)
	        return 0;
	    
	    final int nextType = nextToken.getType();

	    if (nextType == CHILD) 
	    { 
	        getTokenStream().consume();
	        return 1;
	    }
	    if (nextType == PRECEDED)
	    {
	        getTokenStream().consume();
	        return 2;
	    }
	    if (nextType == TILDE)
	    {
	        getTokenStream().consume();
	        return 3;
	    }

	    // Check if there's white space between the previous token and the next token.
	    final CommonToken lastToken = (CommonToken) getTokenStream().LT(-1);
	    if (lastToken != null && nextToken != null)
	    {
	        final int lastStop = lastToken.getStopIndex();
	        final int nextStart = nextToken.getStartIndex();
	        if (lastStop + 1 < nextStart)
	        {
	            return 0;
	        }
	    }
	    
	    // If the next token is "{" or ",", it's also end of a selector.
	    if (nextType == BLOCK_OPEN || nextType == COMMA)
	    {
	        return 0;
	    }
	    
	    return -1;
	}



	public static class stylesheet_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "stylesheet"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:167:1: stylesheet : ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )* ;
	public final CSSParser.stylesheet_return stylesheet() throws RecognitionException {
		CSSParser.stylesheet_return retval = new CSSParser.stylesheet_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope namespaceStatement1 =null;
		ParserRuleReturnScope fontFace2 =null;
		ParserRuleReturnScope keyframes3 =null;
		ParserRuleReturnScope mediaQuery4 =null;
		ParserRuleReturnScope ruleset5 =null;


		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:168:5: ( ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )* )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:168:9: ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )*
			{
			root_0 = (Object)adaptor.nil();


			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:168:9: ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )*
			loop1:
			while (true) {
				int alt1=6;
				switch ( input.LA(1) ) {
				case AT_NAMESPACE:
					{
					alt1=1;
					}
					break;
				case AT_FONT_FACE:
					{
					alt1=2;
					}
					break;
				case AT_KEYFRAMES:
				case AT_WEBKIT_KEYFRAMES:
					{
					alt1=3;
					}
					break;
				case AT_MEDIA:
					{
					alt1=4;
					}
					break;
				case COLON:
				case DOT:
				case DOUBLE_COLON:
				case HASH_WORD:
				case ID:
				case NUMBER_WITH_PERCENT:
				case SQUARE_OPEN:
				case STAR:
					{
					alt1=5;
					}
					break;
				}
				switch (alt1) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:168:11: namespaceStatement
					{
					pushFollow(FOLLOW_namespaceStatement_in_stylesheet146);
					namespaceStatement1=namespaceStatement();
					state._fsp--;

					adaptor.addChild(root_0, namespaceStatement1.getTree());

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:168:32: fontFace
					{
					pushFollow(FOLLOW_fontFace_in_stylesheet150);
					fontFace2=fontFace();
					state._fsp--;

					adaptor.addChild(root_0, fontFace2.getTree());

					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:168:43: keyframes
					{
					pushFollow(FOLLOW_keyframes_in_stylesheet154);
					keyframes3=keyframes();
					state._fsp--;

					adaptor.addChild(root_0, keyframes3.getTree());

					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:168:55: mediaQuery
					{
					pushFollow(FOLLOW_mediaQuery_in_stylesheet158);
					mediaQuery4=mediaQuery();
					state._fsp--;

					adaptor.addChild(root_0, mediaQuery4.getTree());

					}
					break;
				case 5 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:168:68: ruleset
					{
					pushFollow(FOLLOW_ruleset_in_stylesheet162);
					ruleset5=ruleset();
					state._fsp--;

					adaptor.addChild(root_0, ruleset5.getTree());

					}
					break;

				default :
					break loop1;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "stylesheet"


	public static class namespaceStatement_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "namespaceStatement"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:180:1: namespaceStatement : AT_NAMESPACE ( ID )? STRING SEMI_COLONS -> ^( AT_NAMESPACE ( ID )? STRING ) ;
	public final CSSParser.namespaceStatement_return namespaceStatement() throws RecognitionException {
		CSSParser.namespaceStatement_return retval = new CSSParser.namespaceStatement_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token AT_NAMESPACE6=null;
		Token ID7=null;
		Token STRING8=null;
		Token SEMI_COLONS9=null;

		Object AT_NAMESPACE6_tree=null;
		Object ID7_tree=null;
		Object STRING8_tree=null;
		Object SEMI_COLONS9_tree=null;
		RewriteRuleTokenStream stream_STRING=new RewriteRuleTokenStream(adaptor,"token STRING");
		RewriteRuleTokenStream stream_ID=new RewriteRuleTokenStream(adaptor,"token ID");
		RewriteRuleTokenStream stream_SEMI_COLONS=new RewriteRuleTokenStream(adaptor,"token SEMI_COLONS");
		RewriteRuleTokenStream stream_AT_NAMESPACE=new RewriteRuleTokenStream(adaptor,"token AT_NAMESPACE");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:181:5: ( AT_NAMESPACE ( ID )? STRING SEMI_COLONS -> ^( AT_NAMESPACE ( ID )? STRING ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:181:9: AT_NAMESPACE ( ID )? STRING SEMI_COLONS
			{
			AT_NAMESPACE6=(Token)match(input,AT_NAMESPACE,FOLLOW_AT_NAMESPACE_in_namespaceStatement186);  
			stream_AT_NAMESPACE.add(AT_NAMESPACE6);

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:181:22: ( ID )?
			int alt2=2;
			int LA2_0 = input.LA(1);
			if ( (LA2_0==ID) ) {
				alt2=1;
			}
			switch (alt2) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:181:22: ID
					{
					ID7=(Token)match(input,ID,FOLLOW_ID_in_namespaceStatement188);  
					stream_ID.add(ID7);

					}
					break;

			}

			STRING8=(Token)match(input,STRING,FOLLOW_STRING_in_namespaceStatement191);  
			stream_STRING.add(STRING8);

			SEMI_COLONS9=(Token)match(input,SEMI_COLONS,FOLLOW_SEMI_COLONS_in_namespaceStatement193);  
			stream_SEMI_COLONS.add(SEMI_COLONS9);

			// AST REWRITE
			// elements: STRING, ID, AT_NAMESPACE
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 182:6: -> ^( AT_NAMESPACE ( ID )? STRING )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:182:9: ^( AT_NAMESPACE ( ID )? STRING )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot(stream_AT_NAMESPACE.nextNode(), root_1);
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:182:24: ( ID )?
				if ( stream_ID.hasNext() ) {
					adaptor.addChild(root_1, stream_ID.nextNode());
				}
				stream_ID.reset();

				adaptor.addChild(root_1, stream_STRING.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "namespaceStatement"


	public static class keyframes_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "keyframes"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:193:1: keyframes : ( AT_KEYFRAMES ID BLOCK_OPEN ( ruleset )* BLOCK_END -> ^( AT_KEYFRAMES ID ( ruleset )* ) | AT_WEBKIT_KEYFRAMES ID BLOCK_OPEN ( ruleset )* BLOCK_END -> ^( AT_WEBKIT_KEYFRAMES ID ( ruleset )* ) );
	public final CSSParser.keyframes_return keyframes() throws RecognitionException {
		CSSParser.keyframes_return retval = new CSSParser.keyframes_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token AT_KEYFRAMES10=null;
		Token ID11=null;
		Token BLOCK_OPEN12=null;
		Token BLOCK_END14=null;
		Token AT_WEBKIT_KEYFRAMES15=null;
		Token ID16=null;
		Token BLOCK_OPEN17=null;
		Token BLOCK_END19=null;
		ParserRuleReturnScope ruleset13 =null;
		ParserRuleReturnScope ruleset18 =null;

		Object AT_KEYFRAMES10_tree=null;
		Object ID11_tree=null;
		Object BLOCK_OPEN12_tree=null;
		Object BLOCK_END14_tree=null;
		Object AT_WEBKIT_KEYFRAMES15_tree=null;
		Object ID16_tree=null;
		Object BLOCK_OPEN17_tree=null;
		Object BLOCK_END19_tree=null;
		RewriteRuleTokenStream stream_BLOCK_OPEN=new RewriteRuleTokenStream(adaptor,"token BLOCK_OPEN");
		RewriteRuleTokenStream stream_BLOCK_END=new RewriteRuleTokenStream(adaptor,"token BLOCK_END");
		RewriteRuleTokenStream stream_AT_WEBKIT_KEYFRAMES=new RewriteRuleTokenStream(adaptor,"token AT_WEBKIT_KEYFRAMES");
		RewriteRuleTokenStream stream_ID=new RewriteRuleTokenStream(adaptor,"token ID");
		RewriteRuleTokenStream stream_AT_KEYFRAMES=new RewriteRuleTokenStream(adaptor,"token AT_KEYFRAMES");
		RewriteRuleSubtreeStream stream_ruleset=new RewriteRuleSubtreeStream(adaptor,"rule ruleset");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:194:5: ( AT_KEYFRAMES ID BLOCK_OPEN ( ruleset )* BLOCK_END -> ^( AT_KEYFRAMES ID ( ruleset )* ) | AT_WEBKIT_KEYFRAMES ID BLOCK_OPEN ( ruleset )* BLOCK_END -> ^( AT_WEBKIT_KEYFRAMES ID ( ruleset )* ) )
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==AT_KEYFRAMES) ) {
				alt5=1;
			}
			else if ( (LA5_0==AT_WEBKIT_KEYFRAMES) ) {
				alt5=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 5, 0, input);
				throw nvae;
			}

			switch (alt5) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:194:9: AT_KEYFRAMES ID BLOCK_OPEN ( ruleset )* BLOCK_END
					{
					AT_KEYFRAMES10=(Token)match(input,AT_KEYFRAMES,FOLLOW_AT_KEYFRAMES_in_keyframes236);  
					stream_AT_KEYFRAMES.add(AT_KEYFRAMES10);

					ID11=(Token)match(input,ID,FOLLOW_ID_in_keyframes238);  
					stream_ID.add(ID11);

					BLOCK_OPEN12=(Token)match(input,BLOCK_OPEN,FOLLOW_BLOCK_OPEN_in_keyframes240);  
					stream_BLOCK_OPEN.add(BLOCK_OPEN12);

					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:194:36: ( ruleset )*
					loop3:
					while (true) {
						int alt3=2;
						int LA3_0 = input.LA(1);
						if ( (LA3_0==COLON||(LA3_0 >= DOT && LA3_0 <= DOUBLE_COLON)||LA3_0==HASH_WORD||LA3_0==ID||LA3_0==NUMBER_WITH_PERCENT||(LA3_0 >= SQUARE_OPEN && LA3_0 <= STAR)) ) {
							alt3=1;
						}

						switch (alt3) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:194:36: ruleset
							{
							pushFollow(FOLLOW_ruleset_in_keyframes242);
							ruleset13=ruleset();
							state._fsp--;

							stream_ruleset.add(ruleset13.getTree());
							}
							break;

						default :
							break loop3;
						}
					}

					BLOCK_END14=(Token)match(input,BLOCK_END,FOLLOW_BLOCK_END_in_keyframes245);  
					stream_BLOCK_END.add(BLOCK_END14);

					// AST REWRITE
					// elements: AT_KEYFRAMES, ID, ruleset
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 195:6: -> ^( AT_KEYFRAMES ID ( ruleset )* )
					{
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:195:9: ^( AT_KEYFRAMES ID ( ruleset )* )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_AT_KEYFRAMES.nextNode(), root_1);
						adaptor.addChild(root_1, stream_ID.nextNode());
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:195:27: ( ruleset )*
						while ( stream_ruleset.hasNext() ) {
							adaptor.addChild(root_1, stream_ruleset.nextTree());
						}
						stream_ruleset.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:196:9: AT_WEBKIT_KEYFRAMES ID BLOCK_OPEN ( ruleset )* BLOCK_END
					{
					AT_WEBKIT_KEYFRAMES15=(Token)match(input,AT_WEBKIT_KEYFRAMES,FOLLOW_AT_WEBKIT_KEYFRAMES_in_keyframes271);  
					stream_AT_WEBKIT_KEYFRAMES.add(AT_WEBKIT_KEYFRAMES15);

					ID16=(Token)match(input,ID,FOLLOW_ID_in_keyframes273);  
					stream_ID.add(ID16);

					BLOCK_OPEN17=(Token)match(input,BLOCK_OPEN,FOLLOW_BLOCK_OPEN_in_keyframes275);  
					stream_BLOCK_OPEN.add(BLOCK_OPEN17);

					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:196:43: ( ruleset )*
					loop4:
					while (true) {
						int alt4=2;
						int LA4_0 = input.LA(1);
						if ( (LA4_0==COLON||(LA4_0 >= DOT && LA4_0 <= DOUBLE_COLON)||LA4_0==HASH_WORD||LA4_0==ID||LA4_0==NUMBER_WITH_PERCENT||(LA4_0 >= SQUARE_OPEN && LA4_0 <= STAR)) ) {
							alt4=1;
						}

						switch (alt4) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:196:43: ruleset
							{
							pushFollow(FOLLOW_ruleset_in_keyframes277);
							ruleset18=ruleset();
							state._fsp--;

							stream_ruleset.add(ruleset18.getTree());
							}
							break;

						default :
							break loop4;
						}
					}

					BLOCK_END19=(Token)match(input,BLOCK_END,FOLLOW_BLOCK_END_in_keyframes280);  
					stream_BLOCK_END.add(BLOCK_END19);

					// AST REWRITE
					// elements: AT_WEBKIT_KEYFRAMES, ID, ruleset
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 197:6: -> ^( AT_WEBKIT_KEYFRAMES ID ( ruleset )* )
					{
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:197:9: ^( AT_WEBKIT_KEYFRAMES ID ( ruleset )* )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_AT_WEBKIT_KEYFRAMES.nextNode(), root_1);
						adaptor.addChild(root_1, stream_ID.nextNode());
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:197:34: ( ruleset )*
						while ( stream_ruleset.hasNext() ) {
							adaptor.addChild(root_1, stream_ruleset.nextTree());
						}
						stream_ruleset.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "keyframes"


	public static class mediaQuery_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "mediaQuery"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:208:1: mediaQuery : AT_MEDIA medium BLOCK_OPEN ( ruleset )* BLOCK_END -> ^( AT_MEDIA medium ( ruleset )* ) ;
	public final CSSParser.mediaQuery_return mediaQuery() throws RecognitionException {
		CSSParser.mediaQuery_return retval = new CSSParser.mediaQuery_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token AT_MEDIA20=null;
		Token BLOCK_OPEN22=null;
		Token BLOCK_END24=null;
		ParserRuleReturnScope medium21 =null;
		ParserRuleReturnScope ruleset23 =null;

		Object AT_MEDIA20_tree=null;
		Object BLOCK_OPEN22_tree=null;
		Object BLOCK_END24_tree=null;
		RewriteRuleTokenStream stream_BLOCK_OPEN=new RewriteRuleTokenStream(adaptor,"token BLOCK_OPEN");
		RewriteRuleTokenStream stream_BLOCK_END=new RewriteRuleTokenStream(adaptor,"token BLOCK_END");
		RewriteRuleTokenStream stream_AT_MEDIA=new RewriteRuleTokenStream(adaptor,"token AT_MEDIA");
		RewriteRuleSubtreeStream stream_ruleset=new RewriteRuleSubtreeStream(adaptor,"rule ruleset");
		RewriteRuleSubtreeStream stream_medium=new RewriteRuleSubtreeStream(adaptor,"rule medium");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:209:5: ( AT_MEDIA medium BLOCK_OPEN ( ruleset )* BLOCK_END -> ^( AT_MEDIA medium ( ruleset )* ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:209:9: AT_MEDIA medium BLOCK_OPEN ( ruleset )* BLOCK_END
			{
			AT_MEDIA20=(Token)match(input,AT_MEDIA,FOLLOW_AT_MEDIA_in_mediaQuery319);  
			stream_AT_MEDIA.add(AT_MEDIA20);

			pushFollow(FOLLOW_medium_in_mediaQuery321);
			medium21=medium();
			state._fsp--;

			stream_medium.add(medium21.getTree());
			BLOCK_OPEN22=(Token)match(input,BLOCK_OPEN,FOLLOW_BLOCK_OPEN_in_mediaQuery323);  
			stream_BLOCK_OPEN.add(BLOCK_OPEN22);

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:209:36: ( ruleset )*
			loop6:
			while (true) {
				int alt6=2;
				int LA6_0 = input.LA(1);
				if ( (LA6_0==COLON||(LA6_0 >= DOT && LA6_0 <= DOUBLE_COLON)||LA6_0==HASH_WORD||LA6_0==ID||LA6_0==NUMBER_WITH_PERCENT||(LA6_0 >= SQUARE_OPEN && LA6_0 <= STAR)) ) {
					alt6=1;
				}

				switch (alt6) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:209:36: ruleset
					{
					pushFollow(FOLLOW_ruleset_in_mediaQuery325);
					ruleset23=ruleset();
					state._fsp--;

					stream_ruleset.add(ruleset23.getTree());
					}
					break;

				default :
					break loop6;
				}
			}

			BLOCK_END24=(Token)match(input,BLOCK_END,FOLLOW_BLOCK_END_in_mediaQuery328);  
			stream_BLOCK_END.add(BLOCK_END24);

			// AST REWRITE
			// elements: medium, ruleset, AT_MEDIA
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 210:6: -> ^( AT_MEDIA medium ( ruleset )* )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:210:9: ^( AT_MEDIA medium ( ruleset )* )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot(stream_AT_MEDIA.nextNode(), root_1);
				adaptor.addChild(root_1, stream_medium.nextTree());
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:210:27: ( ruleset )*
				while ( stream_ruleset.hasNext() ) {
					adaptor.addChild(root_1, stream_ruleset.nextTree());
				}
				stream_ruleset.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "mediaQuery"


	public static class medium_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "medium"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:217:1: medium : mediumCondition ( 'and' mediumCondition | mediumCondition )* -> ^( I_MEDIUM_CONDITIONS ( mediumCondition )* ) ;
	public final CSSParser.medium_return medium() throws RecognitionException {
		CSSParser.medium_return retval = new CSSParser.medium_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token string_literal26=null;
		ParserRuleReturnScope mediumCondition25 =null;
		ParserRuleReturnScope mediumCondition27 =null;
		ParserRuleReturnScope mediumCondition28 =null;

		Object string_literal26_tree=null;
		RewriteRuleTokenStream stream_75=new RewriteRuleTokenStream(adaptor,"token 75");
		RewriteRuleSubtreeStream stream_mediumCondition=new RewriteRuleSubtreeStream(adaptor,"rule mediumCondition");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:218:5: ( mediumCondition ( 'and' mediumCondition | mediumCondition )* -> ^( I_MEDIUM_CONDITIONS ( mediumCondition )* ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:218:9: mediumCondition ( 'and' mediumCondition | mediumCondition )*
			{
			pushFollow(FOLLOW_mediumCondition_in_medium368);
			mediumCondition25=mediumCondition();
			state._fsp--;

			stream_mediumCondition.add(mediumCondition25.getTree());
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:219:9: ( 'and' mediumCondition | mediumCondition )*
			loop7:
			while (true) {
				int alt7=3;
				int LA7_0 = input.LA(1);
				if ( (LA7_0==75) ) {
					alt7=1;
				}
				else if ( (LA7_0==ARGUMENTS||LA7_0==COMMA||LA7_0==ID||LA7_0==ONLY) ) {
					alt7=2;
				}

				switch (alt7) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:221:13: 'and' mediumCondition
					{
					string_literal26=(Token)match(input,75,FOLLOW_75_in_medium411);  
					stream_75.add(string_literal26);

					pushFollow(FOLLOW_mediumCondition_in_medium426);
					mediumCondition27=mediumCondition();
					state._fsp--;

					stream_mediumCondition.add(mediumCondition27.getTree());
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:223:15: mediumCondition
					{
					pushFollow(FOLLOW_mediumCondition_in_medium442);
					mediumCondition28=mediumCondition();
					state._fsp--;

					stream_mediumCondition.add(mediumCondition28.getTree());
					}
					break;

				default :
					break loop7;
				}
			}

			// AST REWRITE
			// elements: mediumCondition
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 225:9: -> ^( I_MEDIUM_CONDITIONS ( mediumCondition )* )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:225:12: ^( I_MEDIUM_CONDITIONS ( mediumCondition )* )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(I_MEDIUM_CONDITIONS, "I_MEDIUM_CONDITIONS"), root_1);
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:225:34: ( mediumCondition )*
				while ( stream_mediumCondition.hasNext() ) {
					adaptor.addChild(root_1, stream_mediumCondition.nextTree());
				}
				stream_mediumCondition.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "medium"


	public static class mediumCondition_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "mediumCondition"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:232:1: mediumCondition : ( ID | ONLY ID | ARGUMENTS | COMMA );
	public final CSSParser.mediumCondition_return mediumCondition() throws RecognitionException {
		CSSParser.mediumCondition_return retval = new CSSParser.mediumCondition_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token ID29=null;
		Token ONLY30=null;
		Token ID31=null;
		Token ARGUMENTS32=null;
		Token COMMA33=null;

		Object ID29_tree=null;
		Object ONLY30_tree=null;
		Object ID31_tree=null;
		Object ARGUMENTS32_tree=null;
		Object COMMA33_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:233:5: ( ID | ONLY ID | ARGUMENTS | COMMA )
			int alt8=4;
			switch ( input.LA(1) ) {
			case ID:
				{
				alt8=1;
				}
				break;
			case ONLY:
				{
				alt8=2;
				}
				break;
			case ARGUMENTS:
				{
				alt8=3;
				}
				break;
			case COMMA:
				{
				alt8=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 8, 0, input);
				throw nvae;
			}
			switch (alt8) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:233:9: ID
					{
					root_0 = (Object)adaptor.nil();


					ID29=(Token)match(input,ID,FOLLOW_ID_in_mediumCondition493); 
					ID29_tree = (Object)adaptor.create(ID29);
					adaptor.addChild(root_0, ID29_tree);

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:234:9: ONLY ID
					{
					root_0 = (Object)adaptor.nil();


					ONLY30=(Token)match(input,ONLY,FOLLOW_ONLY_in_mediumCondition503); 
					ONLY30_tree = (Object)adaptor.create(ONLY30);
					adaptor.addChild(root_0, ONLY30_tree);

					ID31=(Token)match(input,ID,FOLLOW_ID_in_mediumCondition505); 
					ID31_tree = (Object)adaptor.create(ID31);
					adaptor.addChild(root_0, ID31_tree);

					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:235:9: ARGUMENTS
					{
					root_0 = (Object)adaptor.nil();


					ARGUMENTS32=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_mediumCondition519); 
					ARGUMENTS32_tree = (Object)adaptor.create(ARGUMENTS32);
					adaptor.addChild(root_0, ARGUMENTS32_tree);

					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:236:9: COMMA
					{
					root_0 = (Object)adaptor.nil();


					COMMA33=(Token)match(input,COMMA,FOLLOW_COMMA_in_mediumCondition529); 
					COMMA33_tree = (Object)adaptor.create(COMMA33);
					adaptor.addChild(root_0, COMMA33_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "mediumCondition"


	public static class fontFace_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "fontFace"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:250:1: fontFace : AT_FONT_FACE declarationsBlock -> ^( AT_FONT_FACE declarationsBlock ) ;
	public final CSSParser.fontFace_return fontFace() throws RecognitionException {
		CSSParser.fontFace_return retval = new CSSParser.fontFace_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token AT_FONT_FACE34=null;
		ParserRuleReturnScope declarationsBlock35 =null;

		Object AT_FONT_FACE34_tree=null;
		RewriteRuleTokenStream stream_AT_FONT_FACE=new RewriteRuleTokenStream(adaptor,"token AT_FONT_FACE");
		RewriteRuleSubtreeStream stream_declarationsBlock=new RewriteRuleSubtreeStream(adaptor,"rule declarationsBlock");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:251:5: ( AT_FONT_FACE declarationsBlock -> ^( AT_FONT_FACE declarationsBlock ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:251:9: AT_FONT_FACE declarationsBlock
			{
			AT_FONT_FACE34=(Token)match(input,AT_FONT_FACE,FOLLOW_AT_FONT_FACE_in_fontFace558);  
			stream_AT_FONT_FACE.add(AT_FONT_FACE34);

			pushFollow(FOLLOW_declarationsBlock_in_fontFace560);
			declarationsBlock35=declarationsBlock();
			state._fsp--;

			stream_declarationsBlock.add(declarationsBlock35.getTree());
			// AST REWRITE
			// elements: declarationsBlock, AT_FONT_FACE
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 251:40: -> ^( AT_FONT_FACE declarationsBlock )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:251:43: ^( AT_FONT_FACE declarationsBlock )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot(stream_AT_FONT_FACE.nextNode(), root_1);
				adaptor.addChild(root_1, stream_declarationsBlock.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "fontFace"


	public static class ruleset_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "ruleset"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:257:1: ruleset : selectorGroup declarationsBlock -> ^( I_RULE selectorGroup declarationsBlock ) ;
	public final CSSParser.ruleset_return ruleset() throws RecognitionException {
		CSSParser.ruleset_return retval = new CSSParser.ruleset_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope selectorGroup36 =null;
		ParserRuleReturnScope declarationsBlock37 =null;

		RewriteRuleSubtreeStream stream_selectorGroup=new RewriteRuleSubtreeStream(adaptor,"rule selectorGroup");
		RewriteRuleSubtreeStream stream_declarationsBlock=new RewriteRuleSubtreeStream(adaptor,"rule declarationsBlock");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:258:5: ( selectorGroup declarationsBlock -> ^( I_RULE selectorGroup declarationsBlock ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:258:9: selectorGroup declarationsBlock
			{
			pushFollow(FOLLOW_selectorGroup_in_ruleset591);
			selectorGroup36=selectorGroup();
			state._fsp--;

			stream_selectorGroup.add(selectorGroup36.getTree());
			pushFollow(FOLLOW_declarationsBlock_in_ruleset593);
			declarationsBlock37=declarationsBlock();
			state._fsp--;

			stream_declarationsBlock.add(declarationsBlock37.getTree());
			// AST REWRITE
			// elements: declarationsBlock, selectorGroup
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 259:9: -> ^( I_RULE selectorGroup declarationsBlock )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:259:12: ^( I_RULE selectorGroup declarationsBlock )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(I_RULE, "I_RULE"), root_1);
				adaptor.addChild(root_1, stream_selectorGroup.nextTree());
				adaptor.addChild(root_1, stream_declarationsBlock.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleset"


	public static class selectorGroup_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "selectorGroup"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:265:1: selectorGroup : compoundSelector ( COMMA compoundSelector )* -> ^( I_SELECTOR_GROUP ( compoundSelector )+ ) ;
	public final CSSParser.selectorGroup_return selectorGroup() throws RecognitionException {
		CSSParser.selectorGroup_return retval = new CSSParser.selectorGroup_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token COMMA39=null;
		ParserRuleReturnScope compoundSelector38 =null;
		ParserRuleReturnScope compoundSelector40 =null;

		Object COMMA39_tree=null;
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_compoundSelector=new RewriteRuleSubtreeStream(adaptor,"rule compoundSelector");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:266:2: ( compoundSelector ( COMMA compoundSelector )* -> ^( I_SELECTOR_GROUP ( compoundSelector )+ ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:266:4: compoundSelector ( COMMA compoundSelector )*
			{
			pushFollow(FOLLOW_compoundSelector_in_selectorGroup627);
			compoundSelector38=compoundSelector();
			state._fsp--;

			stream_compoundSelector.add(compoundSelector38.getTree());
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:266:21: ( COMMA compoundSelector )*
			loop9:
			while (true) {
				int alt9=2;
				int LA9_0 = input.LA(1);
				if ( (LA9_0==COMMA) ) {
					alt9=1;
				}

				switch (alt9) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:266:23: COMMA compoundSelector
					{
					COMMA39=(Token)match(input,COMMA,FOLLOW_COMMA_in_selectorGroup631);  
					stream_COMMA.add(COMMA39);

					pushFollow(FOLLOW_compoundSelector_in_selectorGroup633);
					compoundSelector40=compoundSelector();
					state._fsp--;

					stream_compoundSelector.add(compoundSelector40.getTree());
					}
					break;

				default :
					break loop9;
				}
			}

			// AST REWRITE
			// elements: compoundSelector
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 267:9: -> ^( I_SELECTOR_GROUP ( compoundSelector )+ )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:267:12: ^( I_SELECTOR_GROUP ( compoundSelector )+ )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(I_SELECTOR_GROUP, "I_SELECTOR_GROUP"), root_1);
				if ( !(stream_compoundSelector.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_compoundSelector.hasNext() ) {
					adaptor.addChild(root_1, stream_compoundSelector.nextTree());
				}
				stream_compoundSelector.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "selectorGroup"


	public static class compoundSelector_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "compoundSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:278:1: compoundSelector : (l= simpleSelectorFraction )+ -> ^( I_SELECTOR ) ;
	public final CSSParser.compoundSelector_return compoundSelector() throws RecognitionException {
		CSSParser.compoundSelector_return retval = new CSSParser.compoundSelector_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope l =null;

		RewriteRuleSubtreeStream stream_simpleSelectorFraction=new RewriteRuleSubtreeStream(adaptor,"rule simpleSelectorFraction");


			final List<Object> simpleSelectorNodeList = new ArrayList<Object>();
			Object currentSimpleSelectorNode = adaptor.create(I_SIMPLE_SELECTOR, "I_SIMPLE_SELECTOR");
			Token simpleSelectorStartToken = null;
		    Token simpleSelectorStopToken = null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:291:5: ( (l= simpleSelectorFraction )+ -> ^( I_SELECTOR ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:291:9: (l= simpleSelectorFraction )+
			{
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:291:9: (l= simpleSelectorFraction )+
			int cnt10=0;
			loop10:
			while (true) {
				int alt10=2;
				int LA10_0 = input.LA(1);
				if ( (LA10_0==COLON||(LA10_0 >= DOT && LA10_0 <= DOUBLE_COLON)||LA10_0==HASH_WORD||LA10_0==ID||LA10_0==NUMBER_WITH_PERCENT||(LA10_0 >= SQUARE_OPEN && LA10_0 <= STAR)) ) {
					alt10=1;
				}

				switch (alt10) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:291:13: l= simpleSelectorFraction
					{
					pushFollow(FOLLOW_simpleSelectorFraction_in_compoundSelector698);
					l=simpleSelectorFraction();
					state._fsp--;

					stream_simpleSelectorFraction.add(l.getTree());
					 
								    // expand token range of the current simple selector
									if (simpleSelectorStartToken == null)
									    simpleSelectorStartToken = (l!=null?(l.start):null);
									simpleSelectorStopToken = (l!=null?(l.stop):null);
									
									adaptor.addChild(currentSimpleSelectorNode, (l!=null?((Object)l.getTree()):null));
								    
					                            int end = endOfSimpleSelector();
								    if (end != -1) 
								    {
								        adaptor.setTokenBoundaries(
					                        currentSimpleSelectorNode,
					                        simpleSelectorStartToken,
					                        simpleSelectorStopToken);
								    	simpleSelectorNodeList.add(currentSimpleSelectorNode);
					                        
					                    simpleSelectorStartToken = null;
					                    simpleSelectorStopToken = null;
					                    
					                                if (end == 1)
					                                  currentSimpleSelectorNode =  adaptor.create(I_CHILD_SELECTOR, "I_CHILD_SELECTOR");
					                                else if (end == 2)		   
								    	  currentSimpleSelectorNode = adaptor.create(I_PRECEDED_SELECTOR, "I_PRECEDED_SELECTOR");			   
					                                else if (end == 3)			   
								    	  currentSimpleSelectorNode = adaptor.create(I_SIBLING_SELECTOR, "I_SIBLING_SELECTOR");
					                                else
					                              	  currentSimpleSelectorNode = adaptor.create(I_SIMPLE_SELECTOR, "I_SIMPLE_SELECTOR");			   
								    }
								
					}
					break;

				default :
					if ( cnt10 >= 1 ) break loop10;
					EarlyExitException eee = new EarlyExitException(10, input);
					throw eee;
				}
				cnt10++;
			}

			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 323:9: -> ^( I_SELECTOR )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:323:12: ^( I_SELECTOR )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(I_SELECTOR, "I_SELECTOR"), root_1);
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


				for(final Object simpleSelectorNode : simpleSelectorNodeList)
					adaptor.addChild(retval.tree, simpleSelectorNode);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "compoundSelector"


	public static class simpleSelectorFraction_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "simpleSelectorFraction"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:350:1: simpleSelectorFraction : ( condition | element );
	public final CSSParser.simpleSelectorFraction_return simpleSelectorFraction() throws RecognitionException {
		CSSParser.simpleSelectorFraction_return retval = new CSSParser.simpleSelectorFraction_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope condition41 =null;
		ParserRuleReturnScope element42 =null;


		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:351:5: ( condition | element )
			int alt11=2;
			int LA11_0 = input.LA(1);
			if ( (LA11_0==COLON||(LA11_0 >= DOT && LA11_0 <= DOUBLE_COLON)||LA11_0==HASH_WORD||LA11_0==SQUARE_OPEN) ) {
				alt11=1;
			}
			else if ( (LA11_0==ID||LA11_0==NUMBER_WITH_PERCENT||LA11_0==STAR) ) {
				alt11=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 11, 0, input);
				throw nvae;
			}

			switch (alt11) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:351:9: condition
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_condition_in_simpleSelectorFraction768);
					condition41=condition();
					state._fsp--;

					adaptor.addChild(root_0, condition41.getTree());

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:352:9: element
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_element_in_simpleSelectorFraction779);
					element42=element();
					state._fsp--;

					adaptor.addChild(root_0, element42.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "simpleSelectorFraction"


	public static class condition_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "condition"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:359:1: condition : ( DOT ^ ID | HASH_WORD | COLON ^ NOT ARGUMENTS | COLON ^ ID | DOUBLE_COLON ^ ID | attributeSelector ) ;
	public final CSSParser.condition_return condition() throws RecognitionException {
		CSSParser.condition_return retval = new CSSParser.condition_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token DOT43=null;
		Token ID44=null;
		Token HASH_WORD45=null;
		Token COLON46=null;
		Token NOT47=null;
		Token ARGUMENTS48=null;
		Token COLON49=null;
		Token ID50=null;
		Token DOUBLE_COLON51=null;
		Token ID52=null;
		ParserRuleReturnScope attributeSelector53 =null;

		Object DOT43_tree=null;
		Object ID44_tree=null;
		Object HASH_WORD45_tree=null;
		Object COLON46_tree=null;
		Object NOT47_tree=null;
		Object ARGUMENTS48_tree=null;
		Object COLON49_tree=null;
		Object ID50_tree=null;
		Object DOUBLE_COLON51_tree=null;
		Object ID52_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:360:5: ( ( DOT ^ ID | HASH_WORD | COLON ^ NOT ARGUMENTS | COLON ^ ID | DOUBLE_COLON ^ ID | attributeSelector ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:360:9: ( DOT ^ ID | HASH_WORD | COLON ^ NOT ARGUMENTS | COLON ^ ID | DOUBLE_COLON ^ ID | attributeSelector )
			{
			root_0 = (Object)adaptor.nil();


			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:360:9: ( DOT ^ ID | HASH_WORD | COLON ^ NOT ARGUMENTS | COLON ^ ID | DOUBLE_COLON ^ ID | attributeSelector )
			int alt12=6;
			switch ( input.LA(1) ) {
			case DOT:
				{
				alt12=1;
				}
				break;
			case HASH_WORD:
				{
				alt12=2;
				}
				break;
			case COLON:
				{
				int LA12_3 = input.LA(2);
				if ( (LA12_3==NOT) ) {
					alt12=3;
				}
				else if ( (LA12_3==ID) ) {
					alt12=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 12, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case DOUBLE_COLON:
				{
				alt12=5;
				}
				break;
			case SQUARE_OPEN:
				{
				alt12=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 12, 0, input);
				throw nvae;
			}
			switch (alt12) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:360:11: DOT ^ ID
					{
					DOT43=(Token)match(input,DOT,FOLLOW_DOT_in_condition805); 
					DOT43_tree = (Object)adaptor.create(DOT43);
					root_0 = (Object)adaptor.becomeRoot(DOT43_tree, root_0);

					ID44=(Token)match(input,ID,FOLLOW_ID_in_condition808); 
					ID44_tree = (Object)adaptor.create(ID44);
					adaptor.addChild(root_0, ID44_tree);

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:361:11: HASH_WORD
					{
					HASH_WORD45=(Token)match(input,HASH_WORD,FOLLOW_HASH_WORD_in_condition820); 
					HASH_WORD45_tree = (Object)adaptor.create(HASH_WORD45);
					adaptor.addChild(root_0, HASH_WORD45_tree);

					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:362:11: COLON ^ NOT ARGUMENTS
					{
					COLON46=(Token)match(input,COLON,FOLLOW_COLON_in_condition833); 
					COLON46_tree = (Object)adaptor.create(COLON46);
					root_0 = (Object)adaptor.becomeRoot(COLON46_tree, root_0);

					NOT47=(Token)match(input,NOT,FOLLOW_NOT_in_condition836); 
					NOT47_tree = (Object)adaptor.create(NOT47);
					adaptor.addChild(root_0, NOT47_tree);

					ARGUMENTS48=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_condition838); 
					ARGUMENTS48_tree = (Object)adaptor.create(ARGUMENTS48);
					adaptor.addChild(root_0, ARGUMENTS48_tree);

					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:363:11: COLON ^ ID
					{
					COLON49=(Token)match(input,COLON,FOLLOW_COLON_in_condition851); 
					COLON49_tree = (Object)adaptor.create(COLON49);
					root_0 = (Object)adaptor.becomeRoot(COLON49_tree, root_0);

					ID50=(Token)match(input,ID,FOLLOW_ID_in_condition854); 
					ID50_tree = (Object)adaptor.create(ID50);
					adaptor.addChild(root_0, ID50_tree);

					}
					break;
				case 5 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:364:11: DOUBLE_COLON ^ ID
					{
					DOUBLE_COLON51=(Token)match(input,DOUBLE_COLON,FOLLOW_DOUBLE_COLON_in_condition867); 
					DOUBLE_COLON51_tree = (Object)adaptor.create(DOUBLE_COLON51);
					root_0 = (Object)adaptor.becomeRoot(DOUBLE_COLON51_tree, root_0);

					ID52=(Token)match(input,ID,FOLLOW_ID_in_condition870); 
					ID52_tree = (Object)adaptor.create(ID52);
					adaptor.addChild(root_0, ID52_tree);

					}
					break;
				case 6 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:365:11: attributeSelector
					{
					pushFollow(FOLLOW_attributeSelector_in_condition883);
					attributeSelector53=attributeSelector();
					state._fsp--;

					adaptor.addChild(root_0, attributeSelector53.getTree());

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "condition"


	public static class element_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "element"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:374:1: element : ( ID PIPE ^ ID | NUMBER_WITH_PERCENT | ID | STAR );
	public final CSSParser.element_return element() throws RecognitionException {
		CSSParser.element_return retval = new CSSParser.element_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token ID54=null;
		Token PIPE55=null;
		Token ID56=null;
		Token NUMBER_WITH_PERCENT57=null;
		Token ID58=null;
		Token STAR59=null;

		Object ID54_tree=null;
		Object PIPE55_tree=null;
		Object ID56_tree=null;
		Object NUMBER_WITH_PERCENT57_tree=null;
		Object ID58_tree=null;
		Object STAR59_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:375:5: ( ID PIPE ^ ID | NUMBER_WITH_PERCENT | ID | STAR )
			int alt13=4;
			switch ( input.LA(1) ) {
			case ID:
				{
				int LA13_1 = input.LA(2);
				if ( (LA13_1==PIPE) ) {
					alt13=1;
				}
				else if ( (LA13_1==BLOCK_OPEN||(LA13_1 >= COLON && LA13_1 <= COMMA)||(LA13_1 >= DOT && LA13_1 <= DOUBLE_COLON)||LA13_1==HASH_WORD||LA13_1==ID||LA13_1==NUMBER_WITH_PERCENT||(LA13_1 >= SQUARE_OPEN && LA13_1 <= STAR)) ) {
					alt13=3;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 13, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case NUMBER_WITH_PERCENT:
				{
				alt13=2;
				}
				break;
			case STAR:
				{
				alt13=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 13, 0, input);
				throw nvae;
			}
			switch (alt13) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:375:9: ID PIPE ^ ID
					{
					root_0 = (Object)adaptor.nil();


					ID54=(Token)match(input,ID,FOLLOW_ID_in_element917); 
					ID54_tree = (Object)adaptor.create(ID54);
					adaptor.addChild(root_0, ID54_tree);

					PIPE55=(Token)match(input,PIPE,FOLLOW_PIPE_in_element919); 
					PIPE55_tree = (Object)adaptor.create(PIPE55);
					root_0 = (Object)adaptor.becomeRoot(PIPE55_tree, root_0);

					ID56=(Token)match(input,ID,FOLLOW_ID_in_element922); 
					ID56_tree = (Object)adaptor.create(ID56);
					adaptor.addChild(root_0, ID56_tree);

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:376:9: NUMBER_WITH_PERCENT
					{
					root_0 = (Object)adaptor.nil();


					NUMBER_WITH_PERCENT57=(Token)match(input,NUMBER_WITH_PERCENT,FOLLOW_NUMBER_WITH_PERCENT_in_element932); 
					NUMBER_WITH_PERCENT57_tree = (Object)adaptor.create(NUMBER_WITH_PERCENT57);
					adaptor.addChild(root_0, NUMBER_WITH_PERCENT57_tree);

					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:377:9: ID
					{
					root_0 = (Object)adaptor.nil();


					ID58=(Token)match(input,ID,FOLLOW_ID_in_element954); 
					ID58_tree = (Object)adaptor.create(ID58);
					adaptor.addChild(root_0, ID58_tree);

					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:378:9: STAR
					{
					root_0 = (Object)adaptor.nil();


					STAR59=(Token)match(input,STAR,FOLLOW_STAR_in_element974); 
					STAR59_tree = (Object)adaptor.create(STAR59);
					adaptor.addChild(root_0, STAR59_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "element"


	public static class declarationsBlock_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "declarationsBlock"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:386:1: declarationsBlock : BLOCK_OPEN ( ( SEMI_COLONS )? declaration ( SEMI_COLONS declaration )* ( SEMI_COLONS )? )? BLOCK_END -> ^( I_DECL ( declaration )* ) ;
	public final CSSParser.declarationsBlock_return declarationsBlock() throws RecognitionException {
		CSSParser.declarationsBlock_return retval = new CSSParser.declarationsBlock_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token BLOCK_OPEN60=null;
		Token SEMI_COLONS61=null;
		Token SEMI_COLONS63=null;
		Token SEMI_COLONS65=null;
		Token BLOCK_END66=null;
		ParserRuleReturnScope declaration62 =null;
		ParserRuleReturnScope declaration64 =null;

		Object BLOCK_OPEN60_tree=null;
		Object SEMI_COLONS61_tree=null;
		Object SEMI_COLONS63_tree=null;
		Object SEMI_COLONS65_tree=null;
		Object BLOCK_END66_tree=null;
		RewriteRuleTokenStream stream_BLOCK_OPEN=new RewriteRuleTokenStream(adaptor,"token BLOCK_OPEN");
		RewriteRuleTokenStream stream_BLOCK_END=new RewriteRuleTokenStream(adaptor,"token BLOCK_END");
		RewriteRuleTokenStream stream_SEMI_COLONS=new RewriteRuleTokenStream(adaptor,"token SEMI_COLONS");
		RewriteRuleSubtreeStream stream_declaration=new RewriteRuleSubtreeStream(adaptor,"rule declaration");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:387:5: ( BLOCK_OPEN ( ( SEMI_COLONS )? declaration ( SEMI_COLONS declaration )* ( SEMI_COLONS )? )? BLOCK_END -> ^( I_DECL ( declaration )* ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:387:9: BLOCK_OPEN ( ( SEMI_COLONS )? declaration ( SEMI_COLONS declaration )* ( SEMI_COLONS )? )? BLOCK_END
			{
			BLOCK_OPEN60=(Token)match(input,BLOCK_OPEN,FOLLOW_BLOCK_OPEN_in_declarationsBlock1003);  
			stream_BLOCK_OPEN.add(BLOCK_OPEN60);

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:388:9: ( ( SEMI_COLONS )? declaration ( SEMI_COLONS declaration )* ( SEMI_COLONS )? )?
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==ID||LA17_0==SEMI_COLONS) ) {
				alt17=1;
			}
			switch (alt17) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:389:13: ( SEMI_COLONS )? declaration ( SEMI_COLONS declaration )* ( SEMI_COLONS )?
					{
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:389:13: ( SEMI_COLONS )?
					int alt14=2;
					int LA14_0 = input.LA(1);
					if ( (LA14_0==SEMI_COLONS) ) {
						alt14=1;
					}
					switch (alt14) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:389:13: SEMI_COLONS
							{
							SEMI_COLONS61=(Token)match(input,SEMI_COLONS,FOLLOW_SEMI_COLONS_in_declarationsBlock1031);  
							stream_SEMI_COLONS.add(SEMI_COLONS61);

							}
							break;

					}

					pushFollow(FOLLOW_declaration_in_declarationsBlock1049);
					declaration62=declaration();
					state._fsp--;

					stream_declaration.add(declaration62.getTree());
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:391:13: ( SEMI_COLONS declaration )*
					loop15:
					while (true) {
						int alt15=2;
						int LA15_0 = input.LA(1);
						if ( (LA15_0==SEMI_COLONS) ) {
							int LA15_1 = input.LA(2);
							if ( (LA15_1==ID) ) {
								alt15=1;
							}

						}

						switch (alt15) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:392:17: SEMI_COLONS declaration
							{
							SEMI_COLONS63=(Token)match(input,SEMI_COLONS,FOLLOW_SEMI_COLONS_in_declarationsBlock1083);  
							stream_SEMI_COLONS.add(SEMI_COLONS63);

							pushFollow(FOLLOW_declaration_in_declarationsBlock1102);
							declaration64=declaration();
							state._fsp--;

							stream_declaration.add(declaration64.getTree());
							}
							break;

						default :
							break loop15;
						}
					}

					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:395:13: ( SEMI_COLONS )?
					int alt16=2;
					int LA16_0 = input.LA(1);
					if ( (LA16_0==SEMI_COLONS) ) {
						alt16=1;
					}
					switch (alt16) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:395:13: SEMI_COLONS
							{
							SEMI_COLONS65=(Token)match(input,SEMI_COLONS,FOLLOW_SEMI_COLONS_in_declarationsBlock1132);  
							stream_SEMI_COLONS.add(SEMI_COLONS65);

							}
							break;

					}

					}
					break;

			}

			BLOCK_END66=(Token)match(input,BLOCK_END,FOLLOW_BLOCK_END_in_declarationsBlock1155);  
			stream_BLOCK_END.add(BLOCK_END66);

			// AST REWRITE
			// elements: declaration
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 398:9: -> ^( I_DECL ( declaration )* )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:398:12: ^( I_DECL ( declaration )* )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(I_DECL, "I_DECL"), root_1);
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:398:21: ( declaration )*
				while ( stream_declaration.hasNext() ) {
					adaptor.addChild(root_1, stream_declaration.nextTree());
				}
				stream_declaration.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "declarationsBlock"


	public static class declaration_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "declaration"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:406:1: declaration : ID COLON value -> ^( COLON ID value ) ;
	public final CSSParser.declaration_return declaration() throws RecognitionException {
		CSSParser.declaration_return retval = new CSSParser.declaration_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token ID67=null;
		Token COLON68=null;
		ParserRuleReturnScope value69 =null;

		Object ID67_tree=null;
		Object COLON68_tree=null;
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
		RewriteRuleTokenStream stream_ID=new RewriteRuleTokenStream(adaptor,"token ID");
		RewriteRuleSubtreeStream stream_value=new RewriteRuleSubtreeStream(adaptor,"rule value");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:407:5: ( ID COLON value -> ^( COLON ID value ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:407:9: ID COLON value
			{
			ID67=(Token)match(input,ID,FOLLOW_ID_in_declaration1195);  
			stream_ID.add(ID67);

			COLON68=(Token)match(input,COLON,FOLLOW_COLON_in_declaration1197);  
			stream_COLON.add(COLON68);

			pushFollow(FOLLOW_value_in_declaration1199);
			value69=value();
			state._fsp--;

			stream_value.add(value69.getTree());
			// AST REWRITE
			// elements: ID, value, COLON
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 407:24: -> ^( COLON ID value )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:407:27: ^( COLON ID value )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot(stream_COLON.nextNode(), root_1);
				adaptor.addChild(root_1, stream_ID.nextNode());
				adaptor.addChild(root_1, stream_value.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "declaration"


	public static class value_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "value"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:423:1: value : singleValue ( ( COMMA )? singleValue )* -> {count > 1}? ^( I_ARRAY ( singleValue )+ ) -> singleValue ;
	public final CSSParser.value_return value() throws RecognitionException {
		CSSParser.value_return retval = new CSSParser.value_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token COMMA71=null;
		ParserRuleReturnScope singleValue70 =null;
		ParserRuleReturnScope singleValue72 =null;

		Object COMMA71_tree=null;
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_singleValue=new RewriteRuleSubtreeStream(adaptor,"rule singleValue");

		 int count = 1; 
		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:425:5: ( singleValue ( ( COMMA )? singleValue )* -> {count > 1}? ^( I_ARRAY ( singleValue )+ ) -> singleValue )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:425:9: singleValue ( ( COMMA )? singleValue )*
			{
			pushFollow(FOLLOW_singleValue_in_value1245);
			singleValue70=singleValue();
			state._fsp--;

			stream_singleValue.add(singleValue70.getTree());
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:425:21: ( ( COMMA )? singleValue )*
			loop19:
			while (true) {
				int alt19=2;
				int LA19_0 = input.LA(1);
				if ( (LA19_0==ALPHA_VALUE||LA19_0==CALC||LA19_0==CLASS_REFERENCE||LA19_0==COMMA||LA19_0==EMBED||LA19_0==HASH_WORD||(LA19_0 >= ID && LA19_0 <= IMPORTANT)||LA19_0==LOCAL||(LA19_0 >= NUMBER_WITH_PERCENT && LA19_0 <= NUMBER_WITH_UNIT)||LA19_0==OPERATOR||(LA19_0 >= PROPERTY_REFERENCE && LA19_0 <= ROTATE_VALUE)||LA19_0==SCALE_VALUE||LA19_0==STRING||(LA19_0 >= TRANSLATE3D_VALUE && LA19_0 <= URL)) ) {
					alt19=1;
				}

				switch (alt19) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:425:23: ( COMMA )? singleValue
					{
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:425:23: ( COMMA )?
					int alt18=2;
					int LA18_0 = input.LA(1);
					if ( (LA18_0==COMMA) ) {
						alt18=1;
					}
					switch (alt18) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:425:23: COMMA
							{
							COMMA71=(Token)match(input,COMMA,FOLLOW_COMMA_in_value1249);  
							stream_COMMA.add(COMMA71);

							}
							break;

					}

					pushFollow(FOLLOW_singleValue_in_value1252);
					singleValue72=singleValue();
					state._fsp--;

					stream_singleValue.add(singleValue72.getTree());
					 count++; 
					}
					break;

				default :
					break loop19;
				}
			}

			// AST REWRITE
			// elements: singleValue, singleValue
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 426:9: -> {count > 1}? ^( I_ARRAY ( singleValue )+ )
			if (count > 1) {
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:426:25: ^( I_ARRAY ( singleValue )+ )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(I_ARRAY, "I_ARRAY"), root_1);
				if ( !(stream_singleValue.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_singleValue.hasNext() ) {
					adaptor.addChild(root_1, stream_singleValue.nextTree());
				}
				stream_singleValue.reset();

				adaptor.addChild(root_0, root_1);
				}

			}

			else // 427:9: -> singleValue
			{
				adaptor.addChild(root_0, stream_singleValue.nextTree());
			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "value"


	public static class singleValue_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "singleValue"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:445:1: singleValue : ( NUMBER_WITH_PERCENT | NUMBER_WITH_UNIT | HASH_WORD | CLASS_REFERENCE ARGUMENTS -> ^( CLASS_REFERENCE ARGUMENTS ) | PROPERTY_REFERENCE ARGUMENTS -> ^( PROPERTY_REFERENCE ARGUMENTS ) | EMBED ARGUMENTS -> ^( EMBED ARGUMENTS ) | URL ARGUMENTS ( formatOption )* -> ^( URL ARGUMENTS ( formatOption )* ) | LOCAL ARGUMENTS -> ^( LOCAL ARGUMENTS ) | CALC ARGUMENTS -> ^( CALC ARGUMENTS ) | ALPHA_VALUE | SCALE_VALUE | RECT_VALUE | ROTATE_VALUE | TRANSLATE3D_VALUE | RGB | RGBA | STRING | ID | OPERATOR | IMPORTANT );
	public final CSSParser.singleValue_return singleValue() throws RecognitionException {
		CSSParser.singleValue_return retval = new CSSParser.singleValue_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token NUMBER_WITH_PERCENT73=null;
		Token NUMBER_WITH_UNIT74=null;
		Token HASH_WORD75=null;
		Token CLASS_REFERENCE76=null;
		Token ARGUMENTS77=null;
		Token PROPERTY_REFERENCE78=null;
		Token ARGUMENTS79=null;
		Token EMBED80=null;
		Token ARGUMENTS81=null;
		Token URL82=null;
		Token ARGUMENTS83=null;
		Token LOCAL85=null;
		Token ARGUMENTS86=null;
		Token CALC87=null;
		Token ARGUMENTS88=null;
		Token ALPHA_VALUE89=null;
		Token SCALE_VALUE90=null;
		Token RECT_VALUE91=null;
		Token ROTATE_VALUE92=null;
		Token TRANSLATE3D_VALUE93=null;
		Token RGB94=null;
		Token RGBA95=null;
		Token STRING96=null;
		Token ID97=null;
		Token OPERATOR98=null;
		Token IMPORTANT99=null;
		ParserRuleReturnScope formatOption84 =null;

		Object NUMBER_WITH_PERCENT73_tree=null;
		Object NUMBER_WITH_UNIT74_tree=null;
		Object HASH_WORD75_tree=null;
		Object CLASS_REFERENCE76_tree=null;
		Object ARGUMENTS77_tree=null;
		Object PROPERTY_REFERENCE78_tree=null;
		Object ARGUMENTS79_tree=null;
		Object EMBED80_tree=null;
		Object ARGUMENTS81_tree=null;
		Object URL82_tree=null;
		Object ARGUMENTS83_tree=null;
		Object LOCAL85_tree=null;
		Object ARGUMENTS86_tree=null;
		Object CALC87_tree=null;
		Object ARGUMENTS88_tree=null;
		Object ALPHA_VALUE89_tree=null;
		Object SCALE_VALUE90_tree=null;
		Object RECT_VALUE91_tree=null;
		Object ROTATE_VALUE92_tree=null;
		Object TRANSLATE3D_VALUE93_tree=null;
		Object RGB94_tree=null;
		Object RGBA95_tree=null;
		Object STRING96_tree=null;
		Object ID97_tree=null;
		Object OPERATOR98_tree=null;
		Object IMPORTANT99_tree=null;
		RewriteRuleTokenStream stream_ARGUMENTS=new RewriteRuleTokenStream(adaptor,"token ARGUMENTS");
		RewriteRuleTokenStream stream_PROPERTY_REFERENCE=new RewriteRuleTokenStream(adaptor,"token PROPERTY_REFERENCE");
		RewriteRuleTokenStream stream_CLASS_REFERENCE=new RewriteRuleTokenStream(adaptor,"token CLASS_REFERENCE");
		RewriteRuleTokenStream stream_LOCAL=new RewriteRuleTokenStream(adaptor,"token LOCAL");
		RewriteRuleTokenStream stream_EMBED=new RewriteRuleTokenStream(adaptor,"token EMBED");
		RewriteRuleTokenStream stream_CALC=new RewriteRuleTokenStream(adaptor,"token CALC");
		RewriteRuleTokenStream stream_URL=new RewriteRuleTokenStream(adaptor,"token URL");
		RewriteRuleSubtreeStream stream_formatOption=new RewriteRuleSubtreeStream(adaptor,"rule formatOption");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:446:5: ( NUMBER_WITH_PERCENT | NUMBER_WITH_UNIT | HASH_WORD | CLASS_REFERENCE ARGUMENTS -> ^( CLASS_REFERENCE ARGUMENTS ) | PROPERTY_REFERENCE ARGUMENTS -> ^( PROPERTY_REFERENCE ARGUMENTS ) | EMBED ARGUMENTS -> ^( EMBED ARGUMENTS ) | URL ARGUMENTS ( formatOption )* -> ^( URL ARGUMENTS ( formatOption )* ) | LOCAL ARGUMENTS -> ^( LOCAL ARGUMENTS ) | CALC ARGUMENTS -> ^( CALC ARGUMENTS ) | ALPHA_VALUE | SCALE_VALUE | RECT_VALUE | ROTATE_VALUE | TRANSLATE3D_VALUE | RGB | RGBA | STRING | ID | OPERATOR | IMPORTANT )
			int alt21=20;
			switch ( input.LA(1) ) {
			case NUMBER_WITH_PERCENT:
				{
				alt21=1;
				}
				break;
			case NUMBER_WITH_UNIT:
				{
				alt21=2;
				}
				break;
			case HASH_WORD:
				{
				alt21=3;
				}
				break;
			case CLASS_REFERENCE:
				{
				alt21=4;
				}
				break;
			case PROPERTY_REFERENCE:
				{
				alt21=5;
				}
				break;
			case EMBED:
				{
				alt21=6;
				}
				break;
			case URL:
				{
				alt21=7;
				}
				break;
			case LOCAL:
				{
				alt21=8;
				}
				break;
			case CALC:
				{
				alt21=9;
				}
				break;
			case ALPHA_VALUE:
				{
				alt21=10;
				}
				break;
			case SCALE_VALUE:
				{
				alt21=11;
				}
				break;
			case RECT_VALUE:
				{
				alt21=12;
				}
				break;
			case ROTATE_VALUE:
				{
				alt21=13;
				}
				break;
			case TRANSLATE3D_VALUE:
				{
				alt21=14;
				}
				break;
			case RGB:
				{
				alt21=15;
				}
				break;
			case RGBA:
				{
				alt21=16;
				}
				break;
			case STRING:
				{
				alt21=17;
				}
				break;
			case ID:
				{
				alt21=18;
				}
				break;
			case OPERATOR:
				{
				alt21=19;
				}
				break;
			case IMPORTANT:
				{
				alt21=20;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 21, 0, input);
				throw nvae;
			}
			switch (alt21) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:446:9: NUMBER_WITH_PERCENT
					{
					root_0 = (Object)adaptor.nil();


					NUMBER_WITH_PERCENT73=(Token)match(input,NUMBER_WITH_PERCENT,FOLLOW_NUMBER_WITH_PERCENT_in_singleValue1326); 
					NUMBER_WITH_PERCENT73_tree = (Object)adaptor.create(NUMBER_WITH_PERCENT73);
					adaptor.addChild(root_0, NUMBER_WITH_PERCENT73_tree);

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:447:9: NUMBER_WITH_UNIT
					{
					root_0 = (Object)adaptor.nil();


					NUMBER_WITH_UNIT74=(Token)match(input,NUMBER_WITH_UNIT,FOLLOW_NUMBER_WITH_UNIT_in_singleValue1336); 
					NUMBER_WITH_UNIT74_tree = (Object)adaptor.create(NUMBER_WITH_UNIT74);
					adaptor.addChild(root_0, NUMBER_WITH_UNIT74_tree);

					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:448:9: HASH_WORD
					{
					root_0 = (Object)adaptor.nil();


					HASH_WORD75=(Token)match(input,HASH_WORD,FOLLOW_HASH_WORD_in_singleValue1346); 
					HASH_WORD75_tree = (Object)adaptor.create(HASH_WORD75);
					adaptor.addChild(root_0, HASH_WORD75_tree);

					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:449:9: CLASS_REFERENCE ARGUMENTS
					{
					CLASS_REFERENCE76=(Token)match(input,CLASS_REFERENCE,FOLLOW_CLASS_REFERENCE_in_singleValue1356);  
					stream_CLASS_REFERENCE.add(CLASS_REFERENCE76);

					ARGUMENTS77=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1358);  
					stream_ARGUMENTS.add(ARGUMENTS77);

					// AST REWRITE
					// elements: CLASS_REFERENCE, ARGUMENTS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 450:13: -> ^( CLASS_REFERENCE ARGUMENTS )
					{
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:450:16: ^( CLASS_REFERENCE ARGUMENTS )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_CLASS_REFERENCE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_ARGUMENTS.nextNode());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 5 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:451:9: PROPERTY_REFERENCE ARGUMENTS
					{
					PROPERTY_REFERENCE78=(Token)match(input,PROPERTY_REFERENCE,FOLLOW_PROPERTY_REFERENCE_in_singleValue1388);  
					stream_PROPERTY_REFERENCE.add(PROPERTY_REFERENCE78);

					ARGUMENTS79=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1390);  
					stream_ARGUMENTS.add(ARGUMENTS79);

					// AST REWRITE
					// elements: PROPERTY_REFERENCE, ARGUMENTS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 452:13: -> ^( PROPERTY_REFERENCE ARGUMENTS )
					{
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:452:16: ^( PROPERTY_REFERENCE ARGUMENTS )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_PROPERTY_REFERENCE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_ARGUMENTS.nextNode());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 6 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:453:9: EMBED ARGUMENTS
					{
					EMBED80=(Token)match(input,EMBED,FOLLOW_EMBED_in_singleValue1420);  
					stream_EMBED.add(EMBED80);

					ARGUMENTS81=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1422);  
					stream_ARGUMENTS.add(ARGUMENTS81);

					// AST REWRITE
					// elements: EMBED, ARGUMENTS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 454:13: -> ^( EMBED ARGUMENTS )
					{
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:454:16: ^( EMBED ARGUMENTS )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_EMBED.nextNode(), root_1);
						adaptor.addChild(root_1, stream_ARGUMENTS.nextNode());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 7 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:455:9: URL ARGUMENTS ( formatOption )*
					{
					URL82=(Token)match(input,URL,FOLLOW_URL_in_singleValue1452);  
					stream_URL.add(URL82);

					ARGUMENTS83=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1454);  
					stream_ARGUMENTS.add(ARGUMENTS83);

					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:455:23: ( formatOption )*
					loop20:
					while (true) {
						int alt20=2;
						int LA20_0 = input.LA(1);
						if ( (LA20_0==FORMAT) ) {
							alt20=1;
						}

						switch (alt20) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:455:23: formatOption
							{
							pushFollow(FOLLOW_formatOption_in_singleValue1456);
							formatOption84=formatOption();
							state._fsp--;

							stream_formatOption.add(formatOption84.getTree());
							}
							break;

						default :
							break loop20;
						}
					}

					// AST REWRITE
					// elements: formatOption, URL, ARGUMENTS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 455:39: -> ^( URL ARGUMENTS ( formatOption )* )
					{
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:455:42: ^( URL ARGUMENTS ( formatOption )* )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_URL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_ARGUMENTS.nextNode());
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:455:58: ( formatOption )*
						while ( stream_formatOption.hasNext() ) {
							adaptor.addChild(root_1, stream_formatOption.nextTree());
						}
						stream_formatOption.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 8 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:456:9: LOCAL ARGUMENTS
					{
					LOCAL85=(Token)match(input,LOCAL,FOLLOW_LOCAL_in_singleValue1480);  
					stream_LOCAL.add(LOCAL85);

					ARGUMENTS86=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1482);  
					stream_ARGUMENTS.add(ARGUMENTS86);

					// AST REWRITE
					// elements: ARGUMENTS, LOCAL
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 456:34: -> ^( LOCAL ARGUMENTS )
					{
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:456:37: ^( LOCAL ARGUMENTS )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_LOCAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_ARGUMENTS.nextNode());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 9 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:457:9: CALC ARGUMENTS
					{
					CALC87=(Token)match(input,CALC,FOLLOW_CALC_in_singleValue1509);  
					stream_CALC.add(CALC87);

					ARGUMENTS88=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1511);  
					stream_ARGUMENTS.add(ARGUMENTS88);

					// AST REWRITE
					// elements: ARGUMENTS, CALC
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 457:33: -> ^( CALC ARGUMENTS )
					{
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:457:36: ^( CALC ARGUMENTS )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_CALC.nextNode(), root_1);
						adaptor.addChild(root_1, stream_ARGUMENTS.nextNode());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 10 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:458:9: ALPHA_VALUE
					{
					root_0 = (Object)adaptor.nil();


					ALPHA_VALUE89=(Token)match(input,ALPHA_VALUE,FOLLOW_ALPHA_VALUE_in_singleValue1538); 
					ALPHA_VALUE89_tree = (Object)adaptor.create(ALPHA_VALUE89);
					adaptor.addChild(root_0, ALPHA_VALUE89_tree);

					}
					break;
				case 11 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:459:9: SCALE_VALUE
					{
					root_0 = (Object)adaptor.nil();


					SCALE_VALUE90=(Token)match(input,SCALE_VALUE,FOLLOW_SCALE_VALUE_in_singleValue1548); 
					SCALE_VALUE90_tree = (Object)adaptor.create(SCALE_VALUE90);
					adaptor.addChild(root_0, SCALE_VALUE90_tree);

					}
					break;
				case 12 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:460:9: RECT_VALUE
					{
					root_0 = (Object)adaptor.nil();


					RECT_VALUE91=(Token)match(input,RECT_VALUE,FOLLOW_RECT_VALUE_in_singleValue1558); 
					RECT_VALUE91_tree = (Object)adaptor.create(RECT_VALUE91);
					adaptor.addChild(root_0, RECT_VALUE91_tree);

					}
					break;
				case 13 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:461:9: ROTATE_VALUE
					{
					root_0 = (Object)adaptor.nil();


					ROTATE_VALUE92=(Token)match(input,ROTATE_VALUE,FOLLOW_ROTATE_VALUE_in_singleValue1568); 
					ROTATE_VALUE92_tree = (Object)adaptor.create(ROTATE_VALUE92);
					adaptor.addChild(root_0, ROTATE_VALUE92_tree);

					}
					break;
				case 14 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:462:9: TRANSLATE3D_VALUE
					{
					root_0 = (Object)adaptor.nil();


					TRANSLATE3D_VALUE93=(Token)match(input,TRANSLATE3D_VALUE,FOLLOW_TRANSLATE3D_VALUE_in_singleValue1578); 
					TRANSLATE3D_VALUE93_tree = (Object)adaptor.create(TRANSLATE3D_VALUE93);
					adaptor.addChild(root_0, TRANSLATE3D_VALUE93_tree);

					}
					break;
				case 15 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:463:9: RGB
					{
					root_0 = (Object)adaptor.nil();


					RGB94=(Token)match(input,RGB,FOLLOW_RGB_in_singleValue1588); 
					RGB94_tree = (Object)adaptor.create(RGB94);
					adaptor.addChild(root_0, RGB94_tree);

					}
					break;
				case 16 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:464:9: RGBA
					{
					root_0 = (Object)adaptor.nil();


					RGBA95=(Token)match(input,RGBA,FOLLOW_RGBA_in_singleValue1598); 
					RGBA95_tree = (Object)adaptor.create(RGBA95);
					adaptor.addChild(root_0, RGBA95_tree);

					}
					break;
				case 17 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:465:9: STRING
					{
					root_0 = (Object)adaptor.nil();


					STRING96=(Token)match(input,STRING,FOLLOW_STRING_in_singleValue1608); 
					STRING96_tree = (Object)adaptor.create(STRING96);
					adaptor.addChild(root_0, STRING96_tree);

					}
					break;
				case 18 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:466:9: ID
					{
					root_0 = (Object)adaptor.nil();


					ID97=(Token)match(input,ID,FOLLOW_ID_in_singleValue1624); 
					ID97_tree = (Object)adaptor.create(ID97);
					adaptor.addChild(root_0, ID97_tree);

					}
					break;
				case 19 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:467:9: OPERATOR
					{
					root_0 = (Object)adaptor.nil();


					OPERATOR98=(Token)match(input,OPERATOR,FOLLOW_OPERATOR_in_singleValue1634); 
					OPERATOR98_tree = (Object)adaptor.create(OPERATOR98);
					adaptor.addChild(root_0, OPERATOR98_tree);

					}
					break;
				case 20 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:468:9: IMPORTANT
					{
					root_0 = (Object)adaptor.nil();


					IMPORTANT99=(Token)match(input,IMPORTANT,FOLLOW_IMPORTANT_in_singleValue1644); 
					IMPORTANT99_tree = (Object)adaptor.create(IMPORTANT99);
					adaptor.addChild(root_0, IMPORTANT99_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "singleValue"


	public static class formatOption_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "formatOption"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:471:1: formatOption : FORMAT ARGUMENTS -> ^( FORMAT ARGUMENTS ) ;
	public final CSSParser.formatOption_return formatOption() throws RecognitionException {
		CSSParser.formatOption_return retval = new CSSParser.formatOption_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token FORMAT100=null;
		Token ARGUMENTS101=null;

		Object FORMAT100_tree=null;
		Object ARGUMENTS101_tree=null;
		RewriteRuleTokenStream stream_ARGUMENTS=new RewriteRuleTokenStream(adaptor,"token ARGUMENTS");
		RewriteRuleTokenStream stream_FORMAT=new RewriteRuleTokenStream(adaptor,"token FORMAT");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:472:5: ( FORMAT ARGUMENTS -> ^( FORMAT ARGUMENTS ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:472:9: FORMAT ARGUMENTS
			{
			FORMAT100=(Token)match(input,FORMAT,FOLLOW_FORMAT_in_formatOption1664);  
			stream_FORMAT.add(FORMAT100);

			ARGUMENTS101=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_formatOption1666);  
			stream_ARGUMENTS.add(ARGUMENTS101);

			// AST REWRITE
			// elements: FORMAT, ARGUMENTS
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 472:26: -> ^( FORMAT ARGUMENTS )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:472:29: ^( FORMAT ARGUMENTS )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot(stream_FORMAT.nextNode(), root_1);
				adaptor.addChild(root_1, stream_ARGUMENTS.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "formatOption"


	public static class attributeSelector_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "attributeSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:475:1: attributeSelector : SQUARE_OPEN attributeName ( attributeOperator )* ( attributeValue )* SQUARE_END ;
	public final CSSParser.attributeSelector_return attributeSelector() throws RecognitionException {
		CSSParser.attributeSelector_return retval = new CSSParser.attributeSelector_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token SQUARE_OPEN102=null;
		Token SQUARE_END106=null;
		ParserRuleReturnScope attributeName103 =null;
		ParserRuleReturnScope attributeOperator104 =null;
		ParserRuleReturnScope attributeValue105 =null;

		Object SQUARE_OPEN102_tree=null;
		Object SQUARE_END106_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:476:5: ( SQUARE_OPEN attributeName ( attributeOperator )* ( attributeValue )* SQUARE_END )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:476:9: SQUARE_OPEN attributeName ( attributeOperator )* ( attributeValue )* SQUARE_END
			{
			root_0 = (Object)adaptor.nil();


			SQUARE_OPEN102=(Token)match(input,SQUARE_OPEN,FOLLOW_SQUARE_OPEN_in_attributeSelector1694); 
			SQUARE_OPEN102_tree = (Object)adaptor.create(SQUARE_OPEN102);
			adaptor.addChild(root_0, SQUARE_OPEN102_tree);

			pushFollow(FOLLOW_attributeName_in_attributeSelector1696);
			attributeName103=attributeName();
			state._fsp--;

			adaptor.addChild(root_0, attributeName103.getTree());

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:476:35: ( attributeOperator )*
			loop22:
			while (true) {
				int alt22=2;
				int LA22_0 = input.LA(1);
				if ( (LA22_0==BEGINS_WITH||LA22_0==CONTAINS||(LA22_0 >= ENDS_WITH && LA22_0 <= EQUALS)||LA22_0==HREFLANG_MATCH||LA22_0==LIST_MATCH) ) {
					alt22=1;
				}

				switch (alt22) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:476:35: attributeOperator
					{
					pushFollow(FOLLOW_attributeOperator_in_attributeSelector1698);
					attributeOperator104=attributeOperator();
					state._fsp--;

					adaptor.addChild(root_0, attributeOperator104.getTree());

					}
					break;

				default :
					break loop22;
				}
			}

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:476:54: ( attributeValue )*
			loop23:
			while (true) {
				int alt23=2;
				int LA23_0 = input.LA(1);
				if ( (LA23_0==STRING) ) {
					alt23=1;
				}

				switch (alt23) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:476:54: attributeValue
					{
					pushFollow(FOLLOW_attributeValue_in_attributeSelector1701);
					attributeValue105=attributeValue();
					state._fsp--;

					adaptor.addChild(root_0, attributeValue105.getTree());

					}
					break;

				default :
					break loop23;
				}
			}

			SQUARE_END106=(Token)match(input,SQUARE_END,FOLLOW_SQUARE_END_in_attributeSelector1704); 
			SQUARE_END106_tree = (Object)adaptor.create(SQUARE_END106);
			adaptor.addChild(root_0, SQUARE_END106_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "attributeSelector"


	public static class attributeName_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "attributeName"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:479:1: attributeName : ID ;
	public final CSSParser.attributeName_return attributeName() throws RecognitionException {
		CSSParser.attributeName_return retval = new CSSParser.attributeName_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token ID107=null;

		Object ID107_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:480:5: ( ID )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:480:10: ID
			{
			root_0 = (Object)adaptor.nil();


			ID107=(Token)match(input,ID,FOLLOW_ID_in_attributeName1728); 
			ID107_tree = (Object)adaptor.create(ID107);
			adaptor.addChild(root_0, ID107_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "attributeName"


	public static class attributeOperator_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "attributeOperator"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:483:1: attributeOperator : ( BEGINS_WITH | ENDS_WITH | CONTAINS | LIST_MATCH | HREFLANG_MATCH | EQUALS );
	public final CSSParser.attributeOperator_return attributeOperator() throws RecognitionException {
		CSSParser.attributeOperator_return retval = new CSSParser.attributeOperator_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token set108=null;

		Object set108_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:484:5: ( BEGINS_WITH | ENDS_WITH | CONTAINS | LIST_MATCH | HREFLANG_MATCH | EQUALS )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:
			{
			root_0 = (Object)adaptor.nil();


			set108=input.LT(1);
			if ( input.LA(1)==BEGINS_WITH||input.LA(1)==CONTAINS||(input.LA(1) >= ENDS_WITH && input.LA(1) <= EQUALS)||input.LA(1)==HREFLANG_MATCH||input.LA(1)==LIST_MATCH ) {
				input.consume();
				adaptor.addChild(root_0, (Object)adaptor.create(set108));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "attributeOperator"


	public static class attributeValue_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "attributeValue"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:492:1: attributeValue : STRING ;
	public final CSSParser.attributeValue_return attributeValue() throws RecognitionException {
		CSSParser.attributeValue_return retval = new CSSParser.attributeValue_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token STRING109=null;

		Object STRING109_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:493:5: ( STRING )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:493:10: STRING
			{
			root_0 = (Object)adaptor.nil();


			STRING109=(Token)match(input,STRING,FOLLOW_STRING_in_attributeValue1831); 
			STRING109_tree = (Object)adaptor.create(STRING109);
			adaptor.addChild(root_0, STRING109_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "attributeValue"

	// Delegated rules



	public static final BitSet FOLLOW_namespaceStatement_in_stylesheet146 = new BitSet(new long[]{0x0008000120C207C2L,0x0000000000000018L});
	public static final BitSet FOLLOW_fontFace_in_stylesheet150 = new BitSet(new long[]{0x0008000120C207C2L,0x0000000000000018L});
	public static final BitSet FOLLOW_keyframes_in_stylesheet154 = new BitSet(new long[]{0x0008000120C207C2L,0x0000000000000018L});
	public static final BitSet FOLLOW_mediaQuery_in_stylesheet158 = new BitSet(new long[]{0x0008000120C207C2L,0x0000000000000018L});
	public static final BitSet FOLLOW_ruleset_in_stylesheet162 = new BitSet(new long[]{0x0008000120C207C2L,0x0000000000000018L});
	public static final BitSet FOLLOW_AT_NAMESPACE_in_namespaceStatement186 = new BitSet(new long[]{0x0000000100000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_ID_in_namespaceStatement188 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_STRING_in_namespaceStatement191 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_SEMI_COLONS_in_namespaceStatement193 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_KEYFRAMES_in_keyframes236 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_ID_in_keyframes238 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_BLOCK_OPEN_in_keyframes240 = new BitSet(new long[]{0x0008000120C21000L,0x0000000000000018L});
	public static final BitSet FOLLOW_ruleset_in_keyframes242 = new BitSet(new long[]{0x0008000120C21000L,0x0000000000000018L});
	public static final BitSet FOLLOW_BLOCK_END_in_keyframes245 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_WEBKIT_KEYFRAMES_in_keyframes271 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_ID_in_keyframes273 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_BLOCK_OPEN_in_keyframes275 = new BitSet(new long[]{0x0008000120C21000L,0x0000000000000018L});
	public static final BitSet FOLLOW_ruleset_in_keyframes277 = new BitSet(new long[]{0x0008000120C21000L,0x0000000000000018L});
	public static final BitSet FOLLOW_BLOCK_END_in_keyframes280 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_MEDIA_in_mediaQuery319 = new BitSet(new long[]{0x0020000100040020L});
	public static final BitSet FOLLOW_medium_in_mediaQuery321 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_BLOCK_OPEN_in_mediaQuery323 = new BitSet(new long[]{0x0008000120C21000L,0x0000000000000018L});
	public static final BitSet FOLLOW_ruleset_in_mediaQuery325 = new BitSet(new long[]{0x0008000120C21000L,0x0000000000000018L});
	public static final BitSet FOLLOW_BLOCK_END_in_mediaQuery328 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_mediumCondition_in_medium368 = new BitSet(new long[]{0x0020000100040022L,0x0000000000000800L});
	public static final BitSet FOLLOW_75_in_medium411 = new BitSet(new long[]{0x0020000100040020L});
	public static final BitSet FOLLOW_mediumCondition_in_medium426 = new BitSet(new long[]{0x0020000100040022L,0x0000000000000800L});
	public static final BitSet FOLLOW_mediumCondition_in_medium442 = new BitSet(new long[]{0x0020000100040022L,0x0000000000000800L});
	public static final BitSet FOLLOW_ID_in_mediumCondition493 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ONLY_in_mediumCondition503 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_ID_in_mediumCondition505 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ARGUMENTS_in_mediumCondition519 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_mediumCondition529 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_FONT_FACE_in_fontFace558 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_declarationsBlock_in_fontFace560 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectorGroup_in_ruleset591 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_declarationsBlock_in_ruleset593 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_compoundSelector_in_selectorGroup627 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_selectorGroup631 = new BitSet(new long[]{0x0008000120C20000L,0x0000000000000018L});
	public static final BitSet FOLLOW_compoundSelector_in_selectorGroup633 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_simpleSelectorFraction_in_compoundSelector698 = new BitSet(new long[]{0x0008000120C20002L,0x0000000000000018L});
	public static final BitSet FOLLOW_condition_in_simpleSelectorFraction768 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_element_in_simpleSelectorFraction779 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOT_in_condition805 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_ID_in_condition808 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HASH_WORD_in_condition820 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_condition833 = new BitSet(new long[]{0x0001000000000000L});
	public static final BitSet FOLLOW_NOT_in_condition836 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_condition838 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_condition851 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_ID_in_condition854 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_COLON_in_condition867 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_ID_in_condition870 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_attributeSelector_in_condition883 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_element917 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_PIPE_in_element919 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_ID_in_element922 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_WITH_PERCENT_in_element932 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_element954 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STAR_in_element974 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BLOCK_OPEN_in_declarationsBlock1003 = new BitSet(new long[]{0x0000000100001000L,0x0000000000000002L});
	public static final BitSet FOLLOW_SEMI_COLONS_in_declarationsBlock1031 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_declaration_in_declarationsBlock1049 = new BitSet(new long[]{0x0000000000001000L,0x0000000000000002L});
	public static final BitSet FOLLOW_SEMI_COLONS_in_declarationsBlock1083 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_declaration_in_declarationsBlock1102 = new BitSet(new long[]{0x0000000000001000L,0x0000000000000002L});
	public static final BitSet FOLLOW_SEMI_COLONS_in_declarationsBlock1132 = new BitSet(new long[]{0x0000000000001000L});
	public static final BitSet FOLLOW_BLOCK_END_in_declarationsBlock1155 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_declaration1195 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_declaration1197 = new BitSet(new long[]{0x7C58800321014010L,0x0000000000000321L});
	public static final BitSet FOLLOW_value_in_declaration1199 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_singleValue_in_value1245 = new BitSet(new long[]{0x7C58800321054012L,0x0000000000000321L});
	public static final BitSet FOLLOW_COMMA_in_value1249 = new BitSet(new long[]{0x7C58800321014010L,0x0000000000000321L});
	public static final BitSet FOLLOW_singleValue_in_value1252 = new BitSet(new long[]{0x7C58800321054012L,0x0000000000000321L});
	public static final BitSet FOLLOW_NUMBER_WITH_PERCENT_in_singleValue1326 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_WITH_UNIT_in_singleValue1336 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HASH_WORD_in_singleValue1346 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLASS_REFERENCE_in_singleValue1356 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1358 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PROPERTY_REFERENCE_in_singleValue1388 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1390 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EMBED_in_singleValue1420 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1422 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_URL_in_singleValue1452 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1454 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_formatOption_in_singleValue1456 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_LOCAL_in_singleValue1480 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1482 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CALC_in_singleValue1509 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1511 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALPHA_VALUE_in_singleValue1538 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SCALE_VALUE_in_singleValue1548 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RECT_VALUE_in_singleValue1558 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ROTATE_VALUE_in_singleValue1568 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRANSLATE3D_VALUE_in_singleValue1578 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RGB_in_singleValue1588 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RGBA_in_singleValue1598 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_singleValue1608 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_singleValue1624 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPERATOR_in_singleValue1634 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORTANT_in_singleValue1644 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FORMAT_in_formatOption1664 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_formatOption1666 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SQUARE_OPEN_in_attributeSelector1694 = new BitSet(new long[]{0x0000000100000000L});
	public static final BitSet FOLLOW_attributeName_in_attributeSelector1696 = new BitSet(new long[]{0x0000400086100800L,0x0000000000000024L});
	public static final BitSet FOLLOW_attributeOperator_in_attributeSelector1698 = new BitSet(new long[]{0x0000400086100800L,0x0000000000000024L});
	public static final BitSet FOLLOW_attributeValue_in_attributeSelector1701 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000024L});
	public static final BitSet FOLLOW_SQUARE_END_in_attributeSelector1704 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_attributeName1728 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_attributeValue1831 = new BitSet(new long[]{0x0000000000000002L});
}
