/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.concurrent.FutureContribution;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.nio.NHttpMessageParserFactory;
import org.apache.hc.core5.http.nio.NHttpMessageWriterFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.testing.nio.AsyncRequester;
import org.apache.hc.core5.testing.nio.ClientSessionEndpoint;
import org.apache.hc.core5.testing.nio.InternalClientHttp1EventHandlerFactory;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.Timeout;

public class Http1TestClient
extends AsyncRequester {
    private final SSLContext sslContext;
    private final SSLSessionInitializer sslSessionInitializer;
    private final SSLSessionVerifier sslSessionVerifier;
    private Http1Config http1Config;
    private HttpProcessor httpProcessor;
    private NHttpMessageParserFactory<HttpResponse> responseParserFactory;
    private NHttpMessageWriterFactory<HttpRequest> requestWriterFactory;

    public Http1TestClient(IOReactorConfig ioReactorConfig, SSLContext sslContext, SSLSessionInitializer sslSessionInitializer, SSLSessionVerifier sslSessionVerifier) throws IOException {
        super(ioReactorConfig);
        this.sslContext = sslContext;
        this.sslSessionInitializer = sslSessionInitializer;
        this.sslSessionVerifier = sslSessionVerifier;
    }

    public Http1TestClient() throws IOException {
        this(IOReactorConfig.DEFAULT, null, null, null);
    }

    private void ensureNotRunning() {
        Asserts.check((this.getStatus() == IOReactorStatus.INACTIVE ? 1 : 0) != 0, (String)"Client is already running");
    }

    public void configure(Http1Config http1Config) {
        this.ensureNotRunning();
        this.http1Config = http1Config;
    }

    public void configure(HttpProcessor httpProcessor) {
        this.ensureNotRunning();
        this.httpProcessor = httpProcessor;
    }

    @Internal
    public void configure(NHttpMessageParserFactory<HttpResponse> responseParserFactory) {
        this.ensureNotRunning();
        this.responseParserFactory = responseParserFactory;
    }

    @Internal
    public void configure(NHttpMessageWriterFactory<HttpRequest> requestWriterFactory) {
        this.ensureNotRunning();
        this.requestWriterFactory = requestWriterFactory;
    }

    @Deprecated
    public void start(HttpProcessor httpProcessor, Http1Config http1Config) throws IOException {
        this.configure(http1Config);
        this.configure(httpProcessor);
        this.start();
    }

    @Deprecated
    public void start(Http1Config http1Config) throws IOException {
        this.start(null, http1Config);
    }

    public void start() throws IOException {
        this.execute(new InternalClientHttp1EventHandlerFactory(this.httpProcessor != null ? this.httpProcessor : HttpProcessors.client(), this.http1Config, CharCodingConfig.DEFAULT, (ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE, this.responseParserFactory, this.requestWriterFactory, this.sslContext, this.sslSessionInitializer, this.sslSessionVerifier));
    }

    public Future<ClientSessionEndpoint> connect(HttpHost host, Timeout timeout, FutureCallback<ClientSessionEndpoint> callback) {
        final BasicFuture future = new BasicFuture(callback);
        this.requestSession(host, timeout, (FutureCallback<IOSession>)new FutureContribution<IOSession>(future){

            public void completed(IOSession session) {
                future.completed((Object)new ClientSessionEndpoint(session));
            }
        });
        return future;
    }

    public Future<ClientSessionEndpoint> connect(HttpHost host, Timeout timeout) {
        return this.connect(host, timeout, null);
    }

    public Future<ClientSessionEndpoint> connect(String hostname, int port, Timeout timeout) {
        return this.connect(new HttpHost(hostname, port), timeout, null);
    }
}

