/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.tx.message.TransactionMetaMessage;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxStateResponse;
import org.apache.ignite.internal.tx.message.TxStateResponseBuilder;

class TxStateResponseDeserializer
implements MessageDeserializer<TxStateResponse> {
    private final TxStateResponseBuilder msg;

    TxStateResponseDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.txStateResponse();
    }

    public Class<TxStateResponse> klass() {
        return TxStateResponse.class;
    }

    public TxStateResponse getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = (TransactionMetaMessage)reader.readMessage("txStateMeta");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txStateMeta((TransactionMetaMessage)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxStateResponse.class);
    }
}

