/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime.rtti;

import java.util.AbstractMap;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.rtti.BasicSqlTypeRtti;
import org.apache.calcite.runtime.rtti.GenericSqlTypeRtti;
import org.apache.calcite.runtime.rtti.RowSqlTypeRtti;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class RuntimeTypeInformation {
    final RuntimeSqlTypeName typeName;

    protected RuntimeTypeInformation(RuntimeSqlTypeName typeName) {
        this.typeName = typeName;
    }

    public abstract String getTypeString();

    public RuntimeSqlTypeName getTypeName() {
        return this.typeName;
    }

    public boolean isScalar() {
        return this.typeName.isScalar();
    }

    public @Nullable Primitive asPrimitive() {
        switch (this.typeName) {
            case BOOLEAN: {
                return Primitive.BOOLEAN;
            }
            case TINYINT: {
                return Primitive.BYTE;
            }
            case SMALLINT: {
                return Primitive.SHORT;
            }
            case INTEGER: {
                return Primitive.INT;
            }
            case BIGINT: {
                return Primitive.LONG;
            }
            case REAL: {
                return Primitive.FLOAT;
            }
            case DOUBLE: {
                return Primitive.DOUBLE;
            }
        }
        return null;
    }

    public GenericSqlTypeRtti asGeneric() {
        assert (this instanceof GenericSqlTypeRtti);
        return (GenericSqlTypeRtti)this;
    }

    public static Expression createExpression(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case BOOLEAN: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.BOOLEAN))});
            }
            case TINYINT: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.TINYINT))});
            }
            case SMALLINT: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.SMALLINT))});
            }
            case INTEGER: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.INTEGER))});
            }
            case BIGINT: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.BIGINT))});
            }
            case DECIMAL: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.DECIMAL))});
            }
            case REAL: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.REAL))});
            }
            case FLOAT: 
            case DOUBLE: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.DOUBLE))});
            }
            case DATE: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.DATE))});
            }
            case TIME: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.TIME))});
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.TIME_WITH_LOCAL_TIME_ZONE))});
            }
            case TIME_TZ: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.TIME_TZ))});
            }
            case TIMESTAMP: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.TIMESTAMP))});
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE))});
            }
            case TIMESTAMP_TZ: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.TIMESTAMP_TZ))});
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.INTERVAL_LONG))});
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.INTERVAL_SHORT))});
            }
            case CHAR: 
            case VARCHAR: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.VARCHAR))});
            }
            case BINARY: 
            case VARBINARY: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.VARBINARY))});
            }
            case NULL: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.NULL))});
            }
            case MULTISET: {
                Expression comp = RuntimeTypeInformation.createExpression(Objects.requireNonNull(type.getComponentType()));
                return Expressions.new_(GenericSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.MULTISET)), comp});
            }
            case ARRAY: {
                Expression comp = RuntimeTypeInformation.createExpression(Objects.requireNonNull(type.getComponentType()));
                return Expressions.new_(GenericSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.ARRAY)), comp});
            }
            case MAP: {
                Expression key = RuntimeTypeInformation.createExpression(Objects.requireNonNull(type.getKeyType()));
                Expression value = RuntimeTypeInformation.createExpression(Objects.requireNonNull(type.getValueType()));
                return Expressions.new_(GenericSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.MAP)), key, value});
            }
            case ROW: {
                Expression[] fields = new Expression[type.getFieldCount()];
                int index = 0;
                for (RelDataTypeField field : type.getFieldList()) {
                    String name = field.getName();
                    RelDataType fieldType = field.getType();
                    Expression fieldTypeExpression = RuntimeTypeInformation.createExpression(fieldType);
                    ConstantExpression nameExpression = Expressions.constant((Object)name);
                    NewExpression entry = Expressions.new_(AbstractMap.SimpleEntry.class, (Expression[])new Expression[]{nameExpression, fieldTypeExpression});
                    fields[index++] = entry;
                }
                return Expressions.new_(RowSqlTypeRtti.class, (Expression[])fields);
            }
            case GEOMETRY: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.GEOMETRY))});
            }
            case VARIANT: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.VARIANT))});
            }
            case UUID: {
                return Expressions.new_(BasicSqlTypeRtti.class, (Expression[])new Expression[]{Expressions.constant((Object)((Object)RuntimeSqlTypeName.UUID))});
            }
        }
        throw new RuntimeException("Unexpected type " + type);
    }

    public static enum RuntimeSqlTypeName {
        BOOLEAN(false),
        TINYINT(false),
        SMALLINT(false),
        INTEGER(false),
        BIGINT(false),
        DECIMAL(false),
        REAL(false),
        DOUBLE(false),
        DATE(false),
        TIME(false),
        TIME_WITH_LOCAL_TIME_ZONE(false),
        TIME_TZ(false),
        TIMESTAMP(false),
        TIMESTAMP_WITH_LOCAL_TIME_ZONE(false),
        TIMESTAMP_TZ(false),
        INTERVAL_LONG(false),
        INTERVAL_SHORT(false),
        NAME(false),
        VARCHAR(false),
        VARBINARY(false),
        NULL(false),
        MULTISET(true),
        ARRAY(true),
        MAP(true),
        ROW(true),
        GEOMETRY(false),
        UUID(false),
        VARIANT(false);

        private final boolean composite;

        private RuntimeSqlTypeName(boolean composite) {
            this.composite = composite;
        }

        public boolean isScalar() {
            return !this.composite;
        }
    }
}

