/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.ClientMessage;
import org.apache.ignite.internal.jdbc.proto.event.ClientMessageUtils;
import org.apache.ignite.internal.jdbc.proto.event.JdbcObservableTimeAwareRequest;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.CollectionUtils;

public class JdbcBatchPreparedStmntRequest
extends JdbcObservableTimeAwareRequest
implements ClientMessage {
    private String schemaName;
    private String query;
    private List<Object[]> args;
    private boolean autoCommit;
    private long queryTimeoutMillis;
    private long correlationToken;

    public JdbcBatchPreparedStmntRequest() {
    }

    public JdbcBatchPreparedStmntRequest(String schemaName, String query, List<Object[]> args, boolean autoCommit, long queryTimeoutMillis, long correlationToken) {
        assert (!StringUtil.isNullOrEmpty((String)query));
        assert (!CollectionUtils.nullOrEmpty(args));
        this.query = query;
        this.args = args;
        this.schemaName = schemaName;
        this.autoCommit = autoCommit;
        this.queryTimeoutMillis = queryTimeoutMillis;
        this.correlationToken = correlationToken;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String getQuery() {
        return this.query;
    }

    public List<Object[]> getArgs() {
        return this.args;
    }

    public boolean autoCommit() {
        return this.autoCommit;
    }

    public long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public long correlationToken() {
        return this.correlationToken;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        packer.packBoolean(this.autoCommit);
        ClientMessageUtils.writeStringNullable(packer, this.schemaName);
        packer.packString(this.query);
        packer.packInt(this.args.size());
        for (Object[] arg : this.args) {
            packer.packObjectArrayAsBinaryTuple(arg);
        }
        packer.packLong(this.queryTimeoutMillis);
        packer.packLong(this.correlationToken);
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        this.autoCommit = unpacker.unpackBoolean();
        this.schemaName = ClientMessageUtils.readStringNullable(unpacker);
        this.query = unpacker.unpackString();
        int n = unpacker.unpackInt();
        this.args = new ArrayList<Object[]>(n);
        for (int i = 0; i < n; ++i) {
            this.args.add(unpacker.unpackObjectArrayFromBinaryTuple());
        }
        this.queryTimeoutMillis = unpacker.unpackLong();
        this.correlationToken = unpacker.unpackLong();
    }

    public String toString() {
        return S.toString(JdbcBatchPreparedStmntRequest.class, (Object)this);
    }
}

