/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.schema;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryTuple;

public class BinaryRowImpl
implements BinaryRow {
    private final int schemaVersion;
    private final ByteBuffer binaryTuple;

    public BinaryRowImpl(int schemaVersion, ByteBuffer binaryTuple) {
        this.schemaVersion = schemaVersion;
        this.binaryTuple = binaryTuple;
    }

    @Override
    public int schemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public ByteBuffer tupleSlice() {
        return this.binaryTuple.duplicate().order(BinaryTuple.ORDER);
    }

    @Override
    public int tupleSliceLength() {
        return this.binaryTuple.remaining();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryRowImpl binaryRow = (BinaryRowImpl)o;
        if (this.schemaVersion != binaryRow.schemaVersion) {
            return false;
        }
        return this.binaryTuple.equals(binaryRow.binaryTuple);
    }

    public int hashCode() {
        int result = this.schemaVersion;
        result = 31 * result + this.binaryTuple.hashCode();
        return result;
    }
}

