/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/
package org.apache.james.imap.decode.parser;

import jakarta.inject.Inject;

import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.message.request.MoveRequest;

/**
 * Parse MOVE commands
 */
public class MoveCommandParser extends AbstractMessageRangeCommandParser {

    @Inject
    public MoveCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.MOVE_COMMAND, statusResponseFactory);
    }

    @Override
    protected MoveRequest createRequest(Tag tag, boolean useUids, IdRange[] idSet, String mailboxName) {
        return new MoveRequest(idSet, mailboxName, useUids, tag);
    }
}
