/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.api;

import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Optional;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mime4j.dom.Disposable;
import org.apache.james.queue.api.MailQueue;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface ManageableMailQueue
extends MailQueue {
    public long getSize() throws MailQueue.MailQueueException;

    default public Publisher<Long> getSizeReactive() {
        return Mono.fromCallable(this::getSize);
    }

    public long flush() throws MailQueue.MailQueueException;

    public long clear() throws MailQueue.MailQueueException;

    public long remove(Type var1, String var2) throws MailQueue.MailQueueException;

    public MailQueueIterator browse() throws MailQueue.MailQueueException;

    public static class DefaultMailQueueItemView
    implements MailQueueItemView,
    Disposable {
        private final Mail mail;
        private final Optional<ZonedDateTime> nextDelivery;

        public DefaultMailQueueItemView(Mail mail) {
            this(mail, Optional.empty());
        }

        public DefaultMailQueueItemView(Mail mail, ZonedDateTime nextDelivery) {
            this(mail, Optional.of(nextDelivery));
        }

        public DefaultMailQueueItemView(Mail mail, Optional<ZonedDateTime> nextDelivery) {
            this.mail = mail;
            this.nextDelivery = nextDelivery;
        }

        @Override
        public Mail getMail() {
            return this.mail;
        }

        @Override
        public Optional<ZonedDateTime> getNextDelivery() {
            return this.nextDelivery;
        }

        public void dispose() {
            LifecycleUtil.dispose((Object)this.mail);
        }
    }

    public static interface MailQueueItemView {
        public Mail getMail();

        public Optional<ZonedDateTime> getNextDelivery();
    }

    public static interface MailQueueIterator
    extends Iterator<MailQueueItemView> {
        public void close();
    }

    public static enum Type {
        Sender,
        Recipient,
        Name;

    }
}

