/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.PooledReferralConnectorLDAPURLSecurityType;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class PooledReferralConnectorProperties {
    @Nullable
    private BindRequest bindRequest;
    private boolean retryFailedOperationsDueToInvalidConnections;
    private int initialConnectionsPerPool;
    private int maximumConnectionsPerPool;
    @Nullable
    private LDAPConnectionOptions connectionOptions;
    @Nullable
    private LDAPConnectionPoolHealthCheck healthCheck;
    private long backgroundThreadCheckIntervalMillis;
    private long healthCheckIntervalMillis;
    private long maximumConnectionAgeMillis;
    private long maximumPoolAgeMillis;
    private long maximumPoolIdleDurationMillis;
    @NotNull
    private PooledReferralConnectorLDAPURLSecurityType ldapURLSecurityType;
    @Nullable
    private SSLSocketFactory sslSocketFactory;

    public PooledReferralConnectorProperties() {
        this.bindRequest = null;
        this.retryFailedOperationsDueToInvalidConnections = true;
        this.initialConnectionsPerPool = 1;
        this.maximumConnectionsPerPool = 10;
        this.connectionOptions = null;
        this.healthCheck = null;
        this.backgroundThreadCheckIntervalMillis = TimeUnit.SECONDS.toMillis(10L);
        this.healthCheckIntervalMillis = TimeUnit.MINUTES.toMillis(1L);
        this.maximumConnectionAgeMillis = TimeUnit.MINUTES.toMillis(30L);
        this.maximumPoolAgeMillis = 0L;
        this.maximumPoolIdleDurationMillis = TimeUnit.HOURS.toMillis(1L);
        this.ldapURLSecurityType = PooledReferralConnectorLDAPURLSecurityType.CONDITIONALLY_USE_LDAP_AND_CONDITIONALLY_USE_START_TLS;
        this.sslSocketFactory = null;
    }

    public PooledReferralConnectorProperties(@NotNull PooledReferralConnectorProperties properties) {
        this.bindRequest = properties.bindRequest;
        this.retryFailedOperationsDueToInvalidConnections = properties.retryFailedOperationsDueToInvalidConnections;
        this.initialConnectionsPerPool = properties.initialConnectionsPerPool;
        this.maximumConnectionsPerPool = properties.maximumConnectionsPerPool;
        this.connectionOptions = properties.connectionOptions;
        this.healthCheck = properties.healthCheck;
        this.backgroundThreadCheckIntervalMillis = properties.backgroundThreadCheckIntervalMillis;
        this.healthCheckIntervalMillis = properties.healthCheckIntervalMillis;
        this.maximumConnectionAgeMillis = properties.maximumConnectionAgeMillis;
        this.maximumPoolAgeMillis = properties.maximumPoolAgeMillis;
        this.maximumPoolIdleDurationMillis = properties.maximumPoolIdleDurationMillis;
        this.ldapURLSecurityType = properties.ldapURLSecurityType;
        this.sslSocketFactory = properties.sslSocketFactory;
    }

    public int getInitialConnectionsPerPool() {
        return this.initialConnectionsPerPool;
    }

    public void setInitialConnectionsPerPool(int initialConnectionsPerPool) {
        Validator.ensureTrue(initialConnectionsPerPool >= 1, "PooledReferralConnectorProperties.initialConnectionsPerPool must be greater than or equal to one.");
        this.initialConnectionsPerPool = initialConnectionsPerPool;
    }

    public int getMaximumConnectionsPerPool() {
        return this.maximumConnectionsPerPool;
    }

    public void setMaximumConnectionsPerPool(int maximumConnectionsPerPool) {
        Validator.ensureTrue(this.initialConnectionsPerPool >= 1, "PooledReferralConnectorProperties.maximumConnectionsPerPool must be greater than or equal to one.");
        this.maximumConnectionsPerPool = maximumConnectionsPerPool;
    }

    public boolean retryFailedOperationsDueToInvalidConnections() {
        return this.retryFailedOperationsDueToInvalidConnections;
    }

    public void setRetryFailedOperationsDueToInvalidConnections(boolean retryFailedOperationsDueToInvalidConnections) {
        this.retryFailedOperationsDueToInvalidConnections = retryFailedOperationsDueToInvalidConnections;
    }

    public long getMaximumConnectionAgeMillis() {
        return this.maximumConnectionAgeMillis;
    }

    public void setMaximumConnectionAgeMillis(long maximumConnectionAgeMillis) {
        this.maximumConnectionAgeMillis = maximumConnectionAgeMillis > 0L ? maximumConnectionAgeMillis : 0L;
    }

    public long getMaximumPoolAgeMillis() {
        return this.maximumPoolAgeMillis;
    }

    public void setMaximumPoolAgeMillis(long maximumPoolAgeMillis) {
        this.maximumPoolAgeMillis = maximumPoolAgeMillis > 0L ? maximumPoolAgeMillis : 0L;
    }

    public long getMaximumPoolIdleDurationMillis() {
        return this.maximumPoolIdleDurationMillis;
    }

    public void setMaximumPoolIdleDurationMillis(long maximumPoolIdleDurationMillis) {
        this.maximumPoolIdleDurationMillis = maximumPoolIdleDurationMillis > 0L ? maximumPoolIdleDurationMillis : 0L;
    }

    @Nullable
    public LDAPConnectionPoolHealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(@Nullable LDAPConnectionPoolHealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    public long getHealthCheckIntervalMillis() {
        return this.healthCheckIntervalMillis;
    }

    public void setHealthCheckIntervalMillis(long healthCheckIntervalMillis) {
        Validator.ensureTrue(healthCheckIntervalMillis > 0L, "PooledReferralConnectorProperties.healthCheckIntervalMillis must be greater than zero.");
        this.healthCheckIntervalMillis = healthCheckIntervalMillis;
    }

    @Nullable
    public BindRequest getBindRequest() {
        return this.bindRequest;
    }

    public void setBindRequest(@Nullable BindRequest bindRequest) {
        this.bindRequest = bindRequest;
    }

    @Nullable
    public LDAPConnectionOptions getConnectionOptions() {
        if (this.connectionOptions == null) {
            return null;
        }
        return this.connectionOptions.duplicate();
    }

    public void setConnectionOptions(@Nullable LDAPConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    @NotNull
    public PooledReferralConnectorLDAPURLSecurityType getLDAPURLSecurityType() {
        return this.ldapURLSecurityType;
    }

    public void setLDAPURLSecurityType(@NotNull PooledReferralConnectorLDAPURLSecurityType ldapURLSecurityType) {
        Validator.ensureNotNullWithMessage((Object)ldapURLSecurityType, "PooledReferralConnectorProperties.ldapURLSecurityType must not be null.");
        this.ldapURLSecurityType = ldapURLSecurityType;
    }

    @Nullable
    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSSLSocketFactory(@Nullable SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    long getBackgroundThreadCheckIntervalMillis() {
        return this.backgroundThreadCheckIntervalMillis;
    }

    void setBackgroundThreadCheckIntervalMillis(long backgroundThreadCheckIntervalMillis) {
        this.backgroundThreadCheckIntervalMillis = backgroundThreadCheckIntervalMillis;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PooledReferralConnectionProperties(initialConnectionsPerPool=");
        buffer.append(this.initialConnectionsPerPool);
        buffer.append(", maximumConnectionsPerPool=");
        buffer.append(this.maximumConnectionsPerPool);
        buffer.append(", retryFailedOperationsDueToInvalidConnections=");
        buffer.append(this.retryFailedOperationsDueToInvalidConnections);
        buffer.append(", maximumConnectionAgeMillis=");
        buffer.append(this.maximumConnectionAgeMillis);
        buffer.append(", maximumPoolAgeMillis=");
        buffer.append(this.maximumPoolAgeMillis);
        buffer.append(", maximumPoolIdleDurationMillis=");
        buffer.append(this.maximumPoolIdleDurationMillis);
        buffer.append(", maximumPoolIdleDurationMillis=");
        buffer.append(this.maximumPoolIdleDurationMillis);
        buffer.append(", healthCheck=");
        buffer.append(this.healthCheck);
        buffer.append(", healthCheckIntervalMillis=");
        buffer.append(this.healthCheckIntervalMillis);
        buffer.append(", bindRequest=");
        buffer.append(this.bindRequest);
        buffer.append(", connectionOptions=");
        buffer.append(this.connectionOptions);
        buffer.append(", ldapURLSecurityType=");
        buffer.append((Object)this.ldapURLSecurityType);
        buffer.append(", sslSocketFactory=");
        buffer.append(this.sslSocketFactory);
        buffer.append(')');
    }
}

