/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.ooxml.extractor.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.openxml4j.opc.internal.FileHelper;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.WriteLimitReachedException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.parser.microsoft.ooxml.MetadataExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLExtractor;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.ExceptionUtils;
import org.apache.tika.utils.XMLReaderUtils;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractOOXMLExtractor
implements OOXMLExtractor {
    static final String RELATION_AUDIO = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/audio";
    static final String RELATION_MEDIA = "http://schemas.microsoft.com/office/2007/relationships/media";
    static final String RELATION_VIDEO = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/video";
    static final String RELATION_DIAGRAM_DATA = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramData";
    private static final String TYPE_OLE_OBJECT = "application/vnd.openxmlformats-officedocument.oleObject";
    protected static final String[] EMBEDDED_RELATIONSHIPS = new String[]{"http://schemas.openxmlformats.org/officeDocument/2006/relationships/audio", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/package", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramData"};
    private final EmbeddedDocumentExtractor embeddedExtractor;
    private final ParseContext context;
    protected OfficeParserConfig config;
    protected POIXMLTextExtractor extractor;

    public AbstractOOXMLExtractor(ParseContext context, POIXMLTextExtractor extractor) {
        this.context = context;
        this.extractor = extractor;
        this.embeddedExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context);
        this.config = (OfficeParserConfig)context.get(OfficeParserConfig.class);
    }

    @Override
    public POIXMLDocument getDocument() {
        return this.extractor.getDocument();
    }

    @Override
    public MetadataExtractor getMetadataExtractor() {
        return new MetadataExtractor(this.extractor);
    }

    @Override
    public void getXHTML(ContentHandler handler, Metadata metadata, ParseContext context) throws SAXException, XmlException, IOException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        this.buildXHTML(xhtml);
        this.handleEmbeddedParts(handler, metadata);
        this.handleThumbnail(handler);
        xhtml.endDocument();
    }

    protected String getJustFileName(String desc) {
        int idx = desc.lastIndexOf(47);
        if (idx != -1) {
            desc = desc.substring(idx + 1);
        }
        if ((idx = desc.lastIndexOf(46)) != -1) {
            desc = desc.substring(0, idx);
        }
        return desc;
    }

    private void handleThumbnail(ContentHandler handler) throws SAXException {
        try {
            OPCPackage opcPackage = this.extractor.getPackage();
            for (PackageRelationship rel : opcPackage.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail")) {
                PackagePart tPart = opcPackage.getPart(rel);
                InputStream tStream = tPart.getInputStream();
                Metadata thumbnailMetadata = new Metadata();
                String thumbName = tPart.getPartName().getName();
                thumbnailMetadata.set("resourceName", thumbName);
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("http://www.w3.org/1999/xhtml", "class", "class", "CDATA", "embedded");
                attributes.addAttribute("http://www.w3.org/1999/xhtml", "id", "id", "CDATA", thumbName);
                handler.startElement("http://www.w3.org/1999/xhtml", "div", "div", attributes);
                handler.endElement("http://www.w3.org/1999/xhtml", "div", "div");
                thumbnailMetadata.set("embeddedRelationshipId", thumbName);
                thumbnailMetadata.set("Content-Type", tPart.getContentType());
                thumbnailMetadata.set(TikaCoreProperties.TITLE, tPart.getPartName().getName());
                thumbnailMetadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.THUMBNAIL.toString());
                if (this.embeddedExtractor.shouldParseEmbedded(thumbnailMetadata)) {
                    this.embeddedExtractor.parseEmbedded((InputStream)TikaInputStream.get((InputStream)tStream), (ContentHandler)new EmbeddedContentHandler(handler), thumbnailMetadata, false);
                }
                tStream.close();
            }
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception ex) {
            WriteLimitReachedException.throwIfWriteLimitReached((Exception)ex);
        }
    }

    private void handleEmbeddedParts(ContentHandler handler, Metadata metadata) throws TikaException, IOException, SAXException {
        HashSet<String> handledTarget = new HashSet<String>();
        try {
            for (PackagePart source : this.getMainDocumentParts()) {
                if (source == null) continue;
                for (PackageRelationship rel : source.getRelationships()) {
                    try {
                        this.handleEmbeddedPart(source, rel, handler, metadata, handledTarget);
                    }
                    catch (SecurityException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        WriteLimitReachedException.throwIfWriteLimitReached((Exception)e);
                        EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)metadata);
                    }
                }
            }
        }
        catch (InvalidFormatException e) {
            throw new TikaException("Broken OOXML file", (Throwable)e);
        }
    }

    private void handleEmbeddedPart(PackagePart source, PackageRelationship rel, ContentHandler handler, Metadata parentMetadata, Set<String> handledTarget) throws IOException, SAXException, TikaException, InvalidFormatException {
        PackagePart target;
        String sourceDesc;
        URI targetURI = rel.getTargetURI();
        if (targetURI != null && handledTarget.contains(targetURI.toString())) {
            return;
        }
        URI sourceURI = rel.getSourceURI();
        sourceDesc = sourceURI != null ? ((sourceDesc = this.getJustFileName(sourceURI.getPath())).startsWith("slide") ? sourceDesc + "_" : "") : "";
        if (rel.getTargetMode() != TargetMode.INTERNAL) {
            return;
        }
        try {
            target = source.getRelatedPart(rel);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        String type = rel.getRelationshipType();
        if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject".equals(type) && TYPE_OLE_OBJECT.equals(target.getContentType())) {
            this.handleEmbeddedOLE(target, handler, sourceDesc + rel.getId(), parentMetadata);
            handledTarget.add(targetURI.toString());
        } else if (RELATION_MEDIA.equals(type) || RELATION_VIDEO.equals(type) || RELATION_AUDIO.equals(type) || "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image".equals(type) || "http://schemas.openxmlformats.org/officeDocument/2006/relationships/package".equals(type) || "http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject".equals(type)) {
            this.handleEmbeddedFile(target, handler, sourceDesc + rel.getId());
            handledTarget.add(targetURI.toString());
        } else if (XSSFRelation.VBA_MACROS.getRelation().equals(type)) {
            this.handleMacros(target, handler);
            handledTarget.add(targetURI.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEmbeddedOLE(PackagePart part, ContentHandler handler, String rel, Metadata parentMetadata) throws IOException, SAXException {
        if (part.getSize() >= 0L && part.getSize() < 1536L) {
            return;
        }
        InputStream is = part.getInputStream();
        POIFSFileSystem fs = null;
        try {
            fs = new POIFSFileSystem(part.getInputStream());
        }
        catch (Exception e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)parentMetadata);
            return;
        }
        TikaInputStream stream = null;
        try {
            Metadata metadata = new Metadata();
            metadata.set("embeddedRelationshipId", rel);
            DirectoryNode root = fs.getRoot();
            OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType((DirectoryEntry)root);
            if (root.hasEntry("\u0001Ole") && root.hasEntry("\u0001CompObj") && (root.hasEntry("CONTENTS") || root.hasEntry("Package"))) {
                if (root.hasEntry("CONTENTS")) {
                    stream = TikaInputStream.get((InputStream)fs.createDocumentInputStream("CONTENTS"));
                } else if (root.hasEntry("Package")) {
                    stream = TikaInputStream.get((InputStream)fs.createDocumentInputStream("Package"));
                } else {
                    throw new IllegalStateException("Shouldn't ever arrive here; please open a ticket on our jira");
                }
                if (this.embeddedExtractor.shouldParseEmbedded(metadata)) {
                    this.embeddedExtractor.parseEmbedded((InputStream)stream, (ContentHandler)new EmbeddedContentHandler(handler), metadata, false);
                }
            } else if (OfficeParser.POIFSDocumentType.OLE10_NATIVE == type) {
                byte[] data;
                Ole10Native ole = Ole10Native.createFromEmbeddedOleObject((POIFSFileSystem)fs);
                if (ole.getLabel() != null) {
                    metadata.set("resourceName", ole.getLabel());
                }
                if (ole.getCommand() != null) {
                    metadata.add(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, ole.getCommand());
                }
                if (ole.getFileName() != null) {
                    metadata.add(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, ole.getFileName());
                }
                if ((data = ole.getDataBuffer()) != null) {
                    stream = TikaInputStream.get((byte[])data);
                }
                if (stream != null && this.embeddedExtractor.shouldParseEmbedded(metadata)) {
                    this.embeddedExtractor.parseEmbedded((InputStream)stream, (ContentHandler)new EmbeddedContentHandler(handler), metadata, false);
                }
            } else {
                this.handleEmbeddedFile(part, handler, rel);
            }
        }
        catch (FileNotFoundException metadata) {
        }
        catch (Ole10NativeException metadata) {
        }
        catch (IOException e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)parentMetadata);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    protected void handleEmbeddedFile(PackagePart part, ContentHandler handler, String rel) throws SAXException, IOException {
        Metadata metadata = new Metadata();
        metadata.set("embeddedRelationshipId", rel);
        String name = part.getPartName().getName();
        metadata.set("resourceName", name.substring(name.lastIndexOf(47) + 1));
        metadata.set("Content-Type", part.getContentType());
        if (this.embeddedExtractor.shouldParseEmbedded(metadata)) {
            try (TikaInputStream tis = TikaInputStream.get((InputStream)part.getInputStream());){
                this.embeddedExtractor.parseEmbedded((InputStream)tis, (ContentHandler)new EmbeddedContentHandler(handler), metadata, false);
            }
        }
    }

    protected abstract void buildXHTML(XHTMLContentHandler var1) throws SAXException, XmlException, IOException;

    protected abstract List<PackagePart> getMainDocumentParts() throws TikaException;

    void handleMacros(PackagePart macroPart, ContentHandler handler) throws TikaException, SAXException {
        OfficeParserConfig officeParserConfig = (OfficeParserConfig)this.context.get(OfficeParserConfig.class);
        if (officeParserConfig.getExtractMacros()) {
            try (InputStream is = macroPart.getInputStream();
                 POIFSFileSystem poifs = new POIFSFileSystem(is);){
                OfficeParser.extractMacros(poifs, handler, this.embeddedExtractor);
            }
            catch (IOException e) {
                throw new TikaException("Broken OOXML file", (Throwable)e);
            }
        }
    }

    protected Map<String, String> loadLinkedRelationships(PackagePart bodyPart, boolean includeInternal, Metadata metadata) {
        HashMap<String, String> linkedRelationships = new HashMap<String, String>();
        try {
            PackageRelationshipCollection prc = bodyPart.getRelationshipsByType(XWPFRelation.HYPERLINK.getRelation());
            for (int i = 0; i < prc.size(); ++i) {
                String url;
                PackageRelationship pr = prc.getRelationship(i);
                if (pr == null || !includeInternal && TargetMode.INTERNAL.equals((Object)pr.getTargetMode())) continue;
                String id = pr.getId();
                String string = url = pr.getTargetURI() == null ? null : pr.getTargetURI().toString();
                if (id == null || url == null) continue;
                linkedRelationships.put(id, url);
            }
            for (String rel : EMBEDDED_RELATIONSHIPS) {
                prc = bodyPart.getRelationshipsByType(rel);
                for (int i = 0; i < prc.size(); ++i) {
                    String uriString;
                    PackageRelationship pr = prc.getRelationship(i);
                    if (pr == null) continue;
                    String id = pr.getId();
                    String fileName = uriString = pr.getTargetURI() == null ? null : pr.getTargetURI().toString();
                    if (pr.getTargetURI() != null) {
                        try {
                            fileName = FileHelper.getFilename((File)new File(fileName));
                        }
                        catch (Exception e) {
                            fileName = uriString;
                        }
                    }
                    if (id == null) continue;
                    fileName = fileName == null ? "" : fileName;
                    linkedRelationships.put(id, fileName);
                }
            }
        }
        catch (InvalidFormatException e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)metadata);
        }
        return linkedRelationships;
    }

    void handleGeneralTextContainingPart(String contentType, String xhtmlClassLabel, PackagePart parentPart, Metadata parentMetadata, ContentHandler contentHandler) throws SAXException {
        PackageRelationshipCollection relatedPartPRC = null;
        try {
            relatedPartPRC = parentPart.getRelationshipsByType(contentType);
        }
        catch (InvalidFormatException e) {
            parentMetadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (relatedPartPRC != null && relatedPartPRC.size() > 0) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "class", "class", "CDATA", xhtmlClassLabel);
            contentHandler.startElement("", "div", "div", attributes);
            for (int i = 0; i < relatedPartPRC.size(); ++i) {
                PackageRelationship relatedPartPackageRelationship = relatedPartPRC.getRelationship(i);
                try {
                    PackagePart relatedPartPart = parentPart.getRelatedPart(relatedPartPackageRelationship);
                    try (InputStream stream = relatedPartPart.getInputStream();){
                        XMLReaderUtils.parseSAX((InputStream)stream, (DefaultHandler)new OfflineContentHandler((ContentHandler)new EmbeddedContentHandler(contentHandler)), (ParseContext)this.context);
                    }
                    catch (IOException | TikaException e) {
                        parentMetadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
                    }
                    continue;
                }
                catch (InvalidFormatException e) {
                    parentMetadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            contentHandler.endElement("", "div", "div");
        }
    }
}

