/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xliff;

import org.apache.tika.metadata.Metadata;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XLIFF12ContentHandler
extends DefaultHandler {
    private int numberOfFiles = 0;
    private int numberOfTUs = 0;
    private boolean inTransUnit = false;
    private final XHTMLContentHandler xhtml;
    private final Metadata metadata;

    XLIFF12ContentHandler(XHTMLContentHandler xhtml, Metadata metadata) {
        this.xhtml = xhtml;
        this.metadata = metadata;
    }

    @Override
    public void startDocument() throws SAXException {
        this.xhtml.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        AttributesImpl attrs;
        AttributesImpl attributeVals = new AttributesImpl();
        attributeVals.setAttributes(attributes);
        if ("file".equals(localName)) {
            ++this.numberOfFiles;
            this.metadata.add("original", attributes.getValue("source-language"));
            this.xhtml.startElement("div");
            this.xhtml.startElement("h1");
            this.xhtml.characters(attributes.getValue("original"));
            this.xhtml.endElement("h1");
            this.metadata.add("source-language", attributes.getValue("source-language"));
            if (null != attributes.getValue("target-language")) {
                this.metadata.add("target-language", attributes.getValue("target-language"));
            }
        }
        if ("trans-unit".equals(localName)) {
            ++this.numberOfTUs;
            this.inTransUnit = true;
            this.xhtml.startElement("div", attributeVals);
        }
        if ("source".equals(localName)) {
            attrs = this.extractAttributes(attributes);
            this.xhtml.startElement("p", attrs);
        }
        if ("target".equals(localName)) {
            attrs = this.extractAttributes(attributes);
            this.xhtml.startElement("p", attrs);
        }
    }

    private AttributesImpl extractAttributes(Attributes attributes) {
        AttributesImpl attrs = new AttributesImpl();
        if (null != attributes.getValue("xml:lang")) {
            attrs.addAttribute("", "lang", "lang", "", attributes.getValue("xml:lang"));
        }
        return attrs;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("file".equals(localName)) {
            this.xhtml.endElement("div");
        }
        if ("trans-unit".equals(localName)) {
            this.inTransUnit = false;
            this.xhtml.endElement("div");
        }
        if ("source".equals(localName)) {
            this.xhtml.endElement("p");
        }
        if ("target".equals(localName)) {
            this.xhtml.endElement("p");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inTransUnit && length != 0) {
            this.xhtml.characters(ch, start, length);
        }
    }

    @Override
    public void endDocument() {
        this.metadata.set("file-count", String.valueOf(this.numberOfFiles));
        this.metadata.set("tu-count", String.valueOf(this.numberOfTUs));
    }
}

