/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.text;

import com.github.weisj.darklaf.components.text.SearchEvent;
import com.github.weisj.darklaf.components.text.SearchListener;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class SearchTextField
extends JTextField {
    public SearchTextField() {
        this(null, null, 0);
    }

    public SearchTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.putClientProperty("JTextField.variant", "search");
        this.putClientProperty("JTextField.showClear", true);
        this.addActionListener(e -> {
            SearchListener[] list = (SearchListener[])this.listenerList.getListeners(SearchListener.class);
            SearchEvent evt = new SearchEvent(this, SearchEvent.Type.SEARCH, this.getText());
            for (SearchListener listener : list) {
                if (listener == null) continue;
                listener.searchPerformed(evt);
            }
        });
    }

    public SearchTextField(String text) {
        this(null, text, 0);
    }

    public SearchTextField(int columns) {
        this(null, null, columns);
    }

    public SearchTextField(String text, int columns) {
        this(null, text, columns);
    }

    public void addSearchListener(SearchListener listener) {
        this.listenerList.add(SearchListener.class, listener);
    }

    public void removeSearchListener(SearchListener listener) {
        this.listenerList.remove(SearchListener.class, listener);
    }
}

