/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.scrollpane;

import java.awt.Component;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class ViewPropertyChangeListener
implements PropertyChangeListener {
    private final JScrollPane scrollPane;
    private final PropertyChangeListener listener;
    private final ContainerListener containerListener = new ContainerAdapter(){

        @Override
        public void componentAdded(ContainerEvent e) {
            if (ViewPropertyChangeListener.this.currentView != null) {
                ViewPropertyChangeListener.this.currentView.removePropertyChangeListener(ViewPropertyChangeListener.this.listener);
            }
            ViewPropertyChangeListener.this.currentView = e.getChild();
            if (ViewPropertyChangeListener.this.currentView != null) {
                ViewPropertyChangeListener.this.currentView.addPropertyChangeListener(ViewPropertyChangeListener.this.listener);
            }
        }
    };
    private JViewport currentViewport;
    private Component currentView;

    public ViewPropertyChangeListener(JScrollPane scrollPane, PropertyChangeListener listener) {
        this.scrollPane = scrollPane;
        this.listener = listener;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String key = e.getPropertyName();
        Object source = e.getSource();
        if (source == this.scrollPane && "viewport".equals(key)) {
            Object newVal;
            if (this.currentViewport != null) {
                this.currentViewport.removeContainerListener(this.containerListener);
            }
            if ((newVal = e.getNewValue()) instanceof JViewport) {
                this.currentViewport = (JViewport)newVal;
                this.currentViewport.addContainerListener(this.containerListener);
            } else {
                this.currentViewport = null;
            }
        }
    }

    public void install() {
        this.scrollPane.addPropertyChangeListener(this);
        this.currentViewport = this.scrollPane.getViewport();
        if (this.currentViewport != null) {
            this.currentViewport.addContainerListener(this.containerListener);
            this.currentView = this.currentViewport.getView();
            if (this.currentView != null) {
                this.currentView.addPropertyChangeListener(this.listener);
            }
        }
    }

    public void uninstall() {
        this.scrollPane.removePropertyChangeListener(this);
        if (this.currentViewport != null) {
            this.currentViewport.removeContainerListener(this.containerListener);
        }
        if (this.currentView != null) {
            this.currentView.removePropertyChangeListener(this.listener);
        }
    }
}

