/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.splitpane;

import com.github.weisj.darklaf.ui.splitpane.DarkSplitPaneUI;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

final class ThinSplitPaneDivider
extends BasicSplitPaneDivider {
    private final DarkSplitPaneUI ui;

    ThinSplitPaneDivider(DarkSplitPaneUI ui) {
        super(ui);
        this.ui = ui;
    }

    @Override
    public int getDividerSize() {
        return this.ui.getStyle().isPaintBorder() ? 1 : 0;
    }

    @Override
    public void paint(Graphics g) {
        if (this.ui.getStyle().isPaintBorder()) {
            g.setColor(this.ui.getDividerLineColor());
            int offset = this.ui.getDividerDragOffset();
            if (this.orientation == 1) {
                g.drawLine(offset, 0, offset, this.getHeight());
            } else {
                g.drawLine(0, offset, this.getWidth(), offset);
            }
        }
    }

    @Override
    public boolean contains(Point p) {
        if (!this.isEnabled()) {
            return false;
        }
        return super.contains(p);
    }

    @Override
    protected void dragDividerTo(int location) {
        super.dragDividerTo(location + this.ui.getDividerDragOffset());
    }

    @Override
    protected void finishDraggingTo(int location) {
        super.finishDraggingTo(location + this.ui.getDividerDragOffset());
    }
}

