/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.togglebutton.radiobutton;

import com.github.weisj.darklaf.graphics.StringPainter;
import com.github.weisj.darklaf.swingdsl.VisualPaddingListener;
import com.github.weisj.darklaf.ui.togglebutton.ToggleButtonConstants;
import com.github.weisj.darklaf.ui.togglebutton.ToggleButtonFocusNavigationActions;
import com.github.weisj.darklaf.util.SwingUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalRadioButtonUI;

public class DarkRadioButtonUI
extends MetalRadioButtonUI
implements PropertyChangeListener,
ToggleButtonConstants {
    protected final Rectangle viewRect = new Rectangle();
    protected final Rectangle iconRect = new Rectangle();
    protected final Rectangle textRect = new Rectangle();
    protected Dimension size = new Dimension();
    protected RectangularShape hitArea;
    protected JToggleButton radioButton;
    protected String displayString;
    private Icon stateIcon;
    protected BasicButtonListener buttonListener;
    protected ToggleButtonFocusNavigationActions keyboardAction;
    protected VisualPaddingListener visualPaddingListener;

    public static ComponentUI createUI(JComponent c) {
        return new DarkRadioButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.radioButton = (JToggleButton)c;
        super.installUI(c);
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        LookAndFeel.installProperty(b, "opaque", false);
        this.hitArea = new Rectangle();
        this.installIcons();
        this.radioButton.setLayout(this.createLayout());
    }

    protected LayoutManager createLayout() {
        return new DarkRadioButtonLayout();
    }

    protected void installIcons() {
        this.stateIcon = UIManager.getIcon("RadioButton.icon");
    }

    @Override
    protected void installListeners(AbstractButton button) {
        this.buttonListener = this.createButtonListener(button);
        button.addMouseListener(this.buttonListener);
        button.addMouseMotionListener(this.buttonListener);
        button.addFocusListener(this.buttonListener);
        button.addPropertyChangeListener(this.buttonListener);
        button.addChangeListener(this.buttonListener);
        button.addPropertyChangeListener(this);
        this.keyboardAction = new ToggleButtonFocusNavigationActions(button);
        this.keyboardAction.installActions();
        this.visualPaddingListener = new VisualPaddingListener();
        button.addPropertyChangeListener(this.visualPaddingListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.radioButton = null;
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.radioButton.setLayout(null);
    }

    @Override
    protected void uninstallListeners(AbstractButton button) {
        button.removeMouseListener(this.buttonListener);
        button.removeMouseMotionListener(this.buttonListener);
        button.removeFocusListener(this.buttonListener);
        button.removeChangeListener(this.buttonListener);
        button.removePropertyChangeListener(this.buttonListener);
        button.removePropertyChangeListener(this);
        this.keyboardAction.uninstallActions();
        this.keyboardAction = null;
        button.removePropertyChangeListener(this.visualPaddingListener);
        this.visualPaddingListener = null;
    }

    @Override
    public void paint(Graphics g2d, JComponent c) {
        Graphics2D g = (Graphics2D)g2d;
        AbstractButton b = (AbstractButton)c;
        g.setFont(c.getFont());
        FontMetrics fm = SwingUtil.getFontMetrics(c, g);
        this.paintBackground(c, g);
        GraphicsContext config = GraphicsUtil.setupStrokePainting((Graphics)g);
        Icon icon = DarkRadioButtonUI.getIconBullet(b);
        if (icon != null) {
            icon.paintIcon(c, g, this.iconRect.x, this.iconRect.y);
        } else {
            Icon radioIcon = this.getStateIcon(b);
            if (radioIcon != null) {
                radioIcon.paintIcon(c, g, this.iconRect.x, this.iconRect.y);
            }
        }
        config.restore();
        if (this.displayString != null) {
            DarkRadioButtonUI.paintText(g, b, this.textRect, this.displayString, fm, this.getDisabledTextColor());
        }
    }

    protected void paintBackground(JComponent c, Graphics2D g) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }

    public static void paintText(Graphics2D g, AbstractButton b, Rectangle textRect, String text, FontMetrics fm, Color disabledTextColor) {
        g.setColor(b.isEnabled() ? b.getForeground() : disabledTextColor);
        int mnemIndex = b.isEnabled() ? b.getDisplayedMnemonicIndex() : -1;
        StringPainter.drawStringUnderlineCharAt(g, b, text, mnemIndex, textRect, b.getFont(), fm);
    }

    protected Icon getStateIcon(AbstractButton b) {
        return this.stateIcon;
    }

    public static Icon getIconBullet(AbstractButton b) {
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        if (!model.isEnabled()) {
            icon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
        } else if (model.isPressed() && model.isArmed()) {
            icon = b.getPressedIcon();
            if (icon == null) {
                icon = b.getSelectedIcon();
            }
        } else if (model.isSelected()) {
            if (b.isRolloverEnabled() && model.isRollover()) {
                icon = b.getRolloverSelectedIcon();
                if (icon == null) {
                    icon = b.getSelectedIcon();
                }
            } else {
                icon = b.getSelectedIcon();
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            icon = b.getRolloverIcon();
        }
        if (icon == null) {
            icon = b.getIcon();
        }
        return icon;
    }

    @Override
    public Icon getDefaultIcon() {
        return this.getStateIcon(this.radioButton);
    }

    protected RectangularShape calculateHitArea() {
        return new Ellipse2D.Float(Math.max(this.iconRect.x, 0), Math.max(this.iconRect.y, 0), this.iconRect.width, this.iconRect.height);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        if (this.hitArea == null || this.hitArea.isEmpty() && c instanceof JToggleButton) {
            c.doLayout();
        }
        return this.hitArea.contains(x, y);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if ("componentOrientation".equals(key)) {
            this.radioButton.repaint();
            this.hitArea.setFrame(0.0, 0.0, 0.0, 0.0);
        } else if ("JComponent.isTreeEditor".equals(key) || "JComponent.isTableEditor".equals(key)) {
            this.radioButton.repaint();
            this.hitArea.setFrame(0.0, 0.0, 0.0, 0.0);
        } else if ("JToggleButton.clearHitArea".equals(key)) {
            this.hitArea.setFrame(0.0, 0.0, 0.0, 0.0);
        } else if ("border".equals(key)) {
            this.hitArea.setFrame(0.0, 0.0, 0.0, 0.0);
        }
    }

    protected class DarkRadioButtonLayout
    implements LayoutManager {
        protected DarkRadioButtonLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public void layoutContainer(Container parent) {
            DarkRadioButtonUI.this.displayString = this.layout(DarkRadioButtonUI.this.radioButton, DarkRadioButtonUI.this.radioButton.getFontMetrics(DarkRadioButtonUI.this.radioButton.getFont()));
        }

        protected String layout(AbstractButton b, FontMetrics fm) {
            Insets i = b.getInsets();
            DarkRadioButtonUI.this.size = b.getSize(DarkRadioButtonUI.this.size);
            DarkRadioButtonUI.this.viewRect.x = i.left;
            DarkRadioButtonUI.this.viewRect.y = i.top;
            DarkRadioButtonUI.this.viewRect.width = DarkRadioButtonUI.this.size.width - (i.right + DarkRadioButtonUI.this.viewRect.x);
            DarkRadioButtonUI.this.viewRect.height = DarkRadioButtonUI.this.size.height - (i.bottom + DarkRadioButtonUI.this.viewRect.y);
            DarkRadioButtonUI.this.iconRect.height = 0;
            DarkRadioButtonUI.this.iconRect.width = 0;
            DarkRadioButtonUI.this.iconRect.y = 0;
            DarkRadioButtonUI.this.iconRect.x = 0;
            DarkRadioButtonUI.this.textRect.height = 0;
            DarkRadioButtonUI.this.textRect.width = 0;
            DarkRadioButtonUI.this.textRect.y = 0;
            DarkRadioButtonUI.this.textRect.x = 0;
            Icon icon = DarkRadioButtonUI.getIconBullet(b);
            if (icon == null) {
                icon = DarkRadioButtonUI.this.getDefaultIcon();
            }
            String text = SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), DarkRadioButtonUI.this.viewRect, DarkRadioButtonUI.this.iconRect, DarkRadioButtonUI.this.textRect, b.getIconTextGap());
            if (ToggleButtonConstants.isInCell(b)) {
                DarkRadioButtonUI.this.hitArea = DarkRadioButtonUI.this.calculateHitArea();
            } else {
                int x = Math.min(DarkRadioButtonUI.this.iconRect.x, DarkRadioButtonUI.this.textRect.x);
                int y = Math.min(DarkRadioButtonUI.this.iconRect.y, DarkRadioButtonUI.this.textRect.y);
                int xEnd = Math.max(DarkRadioButtonUI.this.iconRect.x + DarkRadioButtonUI.this.iconRect.width, DarkRadioButtonUI.this.textRect.x + DarkRadioButtonUI.this.textRect.width);
                int yEnd = Math.max(DarkRadioButtonUI.this.iconRect.y + DarkRadioButtonUI.this.iconRect.height, DarkRadioButtonUI.this.textRect.y + DarkRadioButtonUI.this.textRect.y);
                DarkRadioButtonUI.this.hitArea = new Rectangle(x, y, xEnd - x, yEnd - y);
            }
            return text;
        }
    }
}

