/*
 * Decompiled with CFR 0.152.
 */
package org.pbjar.jxlayer.plaf.ext;

import java.awt.AWTEvent;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.plaf.LayerUI;

public abstract class AbstractLayerUI<V extends JComponent>
extends LayerUI<V> {
    private static final Map<RenderingHints.Key, Object> emptyRenderingHintMap = Collections.unmodifiableMap(new HashMap(0));
    private boolean dirty;
    private LayoutManager layoutManager;
    private JComponent installedComponent;
    private final PropertyChangeListener dirtyListener = e -> {
        if (!(this.installedComponent == null || "dirty".equals(e.getPropertyName()) && e.getNewValue() != Boolean.TRUE)) {
            this.installedComponent.repaint();
        }
    };

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installedComponent = c;
        this.addPropertyChangeListener(this.dirtyListener);
        ((JLayer)c).setLayerEventMask(this.getLayerEventMask());
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        ((JLayer)c).setLayerEventMask(0L);
        this.removePropertyChangeListener(this.dirtyListener);
        this.installedComponent = null;
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean isDirty) {
        boolean oldDirty = this.dirty;
        this.dirty = isDirty;
        this.firePropertyChange("dirty", oldDirty, isDirty);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g.create();
            JLayer l = (JLayer)c;
            this.configureGraphics(g2, l);
            this.paintLayer(g2, l);
            g2.dispose();
            this.setDirty(false);
        }
    }

    protected void paintLayer(Graphics2D g2, JLayer<? extends V> l) {
        l.paint(g2);
    }

    protected void configureGraphics(Graphics2D g2, JLayer<? extends V> l) {
        Map<RenderingHints.Key, Object> hints;
        AffineTransform transform;
        Shape clip;
        Composite composite = this.getComposite(l);
        if (composite != null) {
            g2.setComposite(composite);
        }
        if ((clip = this.getClip(l)) != null) {
            g2.clip(clip);
        }
        if ((transform = this.getTransform(l)) != null) {
            g2.transform(transform);
        }
        if ((hints = this.getRenderingHints(l)) != null) {
            for (RenderingHints.Key key : hints.keySet()) {
                Object value = hints.get(key);
                if (value == null) continue;
                g2.setRenderingHint(key, hints.get(key));
            }
        }
    }

    protected Composite getComposite(JLayer<? extends V> l) {
        return null;
    }

    protected AffineTransform getTransform(JLayer<? extends V> l) {
        return null;
    }

    protected Shape getClip(JLayer<? extends V> l) {
        return null;
    }

    protected Map<RenderingHints.Key, Object> getRenderingHints(JLayer<? extends V> l) {
        return emptyRenderingHintMap;
    }

    public void setLayoutManager(LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    protected LayoutManager getLayout() {
        return this.layoutManager;
    }

    @Override
    public void doLayout(JLayer<? extends V> l) {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager != null) {
            layoutManager.layoutContainer(l);
        } else {
            super.doLayout(l);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager != null) {
            return layoutManager.preferredLayoutSize(c);
        }
        return super.getPreferredSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager != null) {
            return layoutManager.minimumLayoutSize(c);
        }
        return super.getMinimumSize(c);
    }

    public long getLayerEventMask() {
        return 131132L;
    }

    @Override
    public void eventDispatched(AWTEvent e, JLayer<? extends V> l) {
        if (e instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)e, l);
        } else if (e instanceof MouseEvent) {
            switch (e.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent((MouseEvent)e, l);
                    break;
                }
                case 503: 
                case 506: {
                    this.processMouseMotionEvent((MouseEvent)e, l);
                    break;
                }
                case 507: {
                    this.processMouseWheelEvent((MouseWheelEvent)e, l);
                }
            }
        } else if (e instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)e, l);
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e, JLayer<? extends V> l) {
    }

    @Override
    protected void processMouseEvent(MouseEvent e, JLayer<? extends V> l) {
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e, JLayer<? extends V> l) {
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e, JLayer<? extends V> l) {
    }

    @Override
    protected void processKeyEvent(KeyEvent e, JLayer<? extends V> l) {
    }
}

