/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSHSLA;
import com.helger.css.decl.ICSSColor;
import com.helger.css.utils.CSSColorHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSHSL
implements ICSSWriteable,
ICSSVersionAware,
ICSSColor,
ICloneable<CSSHSL> {
    private String m_sHue;
    private String m_sSaturation;
    private String m_sLightness;

    public CSSHSL(@Nonnull CSSHSL cSSHSL) {
        this(cSSHSL.getHue(), cSSHSL.getSaturation(), cSSHSL.getLightness());
    }

    public CSSHSL(int n, int n2, int n3) {
        this(Integer.toString(CSSColorHelper.getHSLHueValue(n)), Integer.toString(CSSColorHelper.getHSLPercentageValue(n2)) + "%", Integer.toString(CSSColorHelper.getHSLPercentageValue(n3)) + "%");
    }

    public CSSHSL(float f, float f2, float f3) {
        this(Float.toString(CSSColorHelper.getHSLHueValue(f)), Float.toString(CSSColorHelper.getHSLPercentageValue(f2)) + "%", Float.toString(CSSColorHelper.getHSLPercentageValue(f3)) + "%");
    }

    public CSSHSL(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) {
        this.setHue(string);
        this.setSaturation(string2);
        this.setLightness(string3);
    }

    @Nonnull
    @Nonempty
    public final String getHue() {
        return this.m_sHue;
    }

    @Nonnull
    public final CSSHSL setHue(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Hue");
        this.m_sHue = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public final String getSaturation() {
        return this.m_sSaturation;
    }

    @Nonnull
    public final CSSHSL setSaturation(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Saturation");
        this.m_sSaturation = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public final String getLightness() {
        return this.m_sLightness;
    }

    @Nonnull
    public final CSSHSL setLightness(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Lightness");
        this.m_sLightness = string;
        return this;
    }

    @Nonnull
    public CSSHSLA getAsHSLA(float f) {
        return new CSSHSLA(this, f);
    }

    @Nonnull
    public CSSHSLA getAsHSLA(@Nonnull @Nonempty String string) {
        return new CSSHSLA(this, string);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        return "hsl(" + this.m_sHue + ',' + this.m_sSaturation + ',' + this.m_sLightness + ")";
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        return this.getAsString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Nonnull
    public CSSHSL getClone() {
        return new CSSHSL(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSHSL cSSHSL = (CSSHSL)object;
        return this.m_sHue.equals(cSSHSL.m_sHue) && this.m_sSaturation.equals(cSSHSL.m_sSaturation) && this.m_sLightness.equals(cSSHSL.m_sLightness);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sHue).append((Object)this.m_sSaturation).append((Object)this.m_sLightness).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Hue", (Object)this.m_sHue).append("Saturation", (Object)this.m_sSaturation).append("Lightness", (Object)this.m_sLightness).getToString();
    }
}

