/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.jmeter.gui.Binding;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.schema.BooleanPropertyDescriptor;
import org.apache.jmeter.testelement.schema.DoublePropertyDescriptor;
import org.apache.jmeter.testelement.schema.FloatPropertyDescriptor;
import org.apache.jmeter.testelement.schema.IntegerPropertyDescriptor;
import org.apache.jmeter.testelement.schema.LongPropertyDescriptor;
import org.apache.jmeter.testelement.schema.PropertyDescriptor;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.EXPERIMENTAL, since="5.6.3")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/apache/jmeter/gui/JTextComponentBinding;", "Lorg/apache/jmeter/gui/Binding;", "textComponent", "Ljavax/swing/text/JTextComponent;", "propertyDescriptor", "Lorg/apache/jmeter/testelement/schema/PropertyDescriptor;", "(Ljavax/swing/text/JTextComponent;Lorg/apache/jmeter/testelement/schema/PropertyDescriptor;)V", "updateElement", "", "testElement", "Lorg/apache/jmeter/testelement/TestElement;", "updateUi", "ApacheJMeter_core"})
public final class JTextComponentBinding
implements Binding {
    @NotNull
    private final JTextComponent textComponent;
    @NotNull
    private final PropertyDescriptor<?, ?> propertyDescriptor;

    public JTextComponentBinding(@NotNull JTextComponent textComponent, @NotNull PropertyDescriptor<?, ?> propertyDescriptor) {
        Intrinsics.checkNotNullParameter((Object)textComponent, (String)"textComponent");
        Intrinsics.checkNotNullParameter(propertyDescriptor, (String)"propertyDescriptor");
        this.textComponent = textComponent;
        this.propertyDescriptor = propertyDescriptor;
    }

    @Override
    public void updateElement(@NotNull TestElement testElement) {
        String string;
        Object object;
        Intrinsics.checkNotNullParameter((Object)testElement, (String)"testElement");
        JTextComponent component = this.textComponent;
        if (component instanceof JPasswordField) {
            char[] cArray = ((JPasswordField)component).getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
            object = cArray;
            string = new String((char[])object);
        } else {
            string = component.getText();
        }
        String text = string;
        Intrinsics.checkNotNull((Object)text);
        if (((CharSequence)text).length() == 0) {
            testElement.removeProperty(this.propertyDescriptor);
            return;
        }
        PropertyDescriptor<?, ?> propertyDescriptor = this.propertyDescriptor;
        if (propertyDescriptor instanceof IntegerPropertyDescriptor) {
            object = StringsKt.toIntOrNull((String)text);
            if (object != null) {
                int it = ((Number)object).intValue();
                boolean bl = false;
                testElement.set((IntegerPropertyDescriptor)this.propertyDescriptor, it);
                return;
            }
        } else if (propertyDescriptor instanceof LongPropertyDescriptor) {
            object = StringsKt.toLongOrNull((String)text);
            if (object != null) {
                long it = ((Number)object).longValue();
                boolean bl = false;
                testElement.set((LongPropertyDescriptor)this.propertyDescriptor, it);
                return;
            }
        } else if (propertyDescriptor instanceof FloatPropertyDescriptor) {
            object = StringsKt.toFloatOrNull((String)text);
            if (object != null) {
                float it = ((Number)object).floatValue();
                boolean bl = false;
                testElement.set((FloatPropertyDescriptor)this.propertyDescriptor, it);
                return;
            }
        } else if (propertyDescriptor instanceof DoublePropertyDescriptor) {
            object = StringsKt.toDoubleOrNull((String)text);
            if (object != null) {
                double it = ((Number)object).doubleValue();
                boolean bl = false;
                testElement.set((DoublePropertyDescriptor)this.propertyDescriptor, it);
                return;
            }
        } else if (propertyDescriptor instanceof BooleanPropertyDescriptor && (object = (Object)StringsKt.toBooleanStrictOrNull((String)text)) != null) {
            boolean it = (Boolean)object;
            boolean bl = false;
            testElement.set((BooleanPropertyDescriptor)this.propertyDescriptor, it);
            return;
        }
        testElement.set(this.propertyDescriptor, text);
    }

    @Override
    public void updateUi(@NotNull TestElement testElement) {
        Intrinsics.checkNotNullParameter((Object)testElement, (String)"testElement");
        this.textComponent.setText(testElement.getPropertyOrNull(this.propertyDescriptor) == null ? "" : testElement.getString(this.propertyDescriptor));
    }
}

