/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.AbstractSampleConsumer;
import org.apache.jmeter.report.processor.MapResultData;
import org.apache.jmeter.report.processor.ValueResultData;

public class RequestsSummaryConsumer
extends AbstractSampleConsumer {
    private long count;
    private long errorCount;

    @Override
    public void startConsuming() {
        this.count = 0L;
        this.errorCount = 0L;
        int channelCount = this.getConsumedChannelCount();
        for (int i = 0; i < channelCount; ++i) {
            super.setProducedMetadata(this.getConsumedMetadata(i), i);
        }
        super.startProducing();
    }

    @Override
    public void consume(Sample sample, int channel) {
        if (!sample.isController()) {
            ++this.count;
            if (!sample.getSuccess()) {
                ++this.errorCount;
            }
        }
        super.produce(sample, channel);
    }

    @Override
    public void stopConsuming() {
        MapResultData result = new MapResultData();
        result.setResult("KoPercent", new ValueResultData((double)this.errorCount * 100.0 / (double)this.count));
        result.setResult("OkPercent", new ValueResultData((double)(this.count - this.errorCount) * 100.0 / (double)this.count));
        this.setDataToContext(this.getName(), result);
        super.stopProducing();
    }
}

