/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.jmeter.control.TransactionController;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jorphan.util.JMeterStopTestNowException;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSaver
extends AbstractTestElement
implements NoThreadClone,
Serializable,
SampleListener,
TestStateListener {
    private static final Logger log = LoggerFactory.getLogger(ResultSaver.class);
    private static final long serialVersionUID = 242L;
    private static final Object LOCK = new Object();
    private static final String TIMESTAMP_FORMAT = "yyyyMMdd-HHmm_";
    public static final String FILENAME = "FileSaver.filename";
    public static final String VARIABLE_NAME = "FileSaver.variablename";
    public static final String ERRORS_ONLY = "FileSaver.errorsonly";
    public static final String SUCCESS_ONLY = "FileSaver.successonly";
    public static final String SKIP_AUTO_NUMBER = "FileSaver.skipautonumber";
    public static final String SKIP_SUFFIX = "FileSaver.skipsuffix";
    public static final String ADD_TIMESTAMP = "FileSaver.addTimstamp";
    public static final String NUMBER_PAD_LENGTH = "FileSaver.numberPadLen";
    public static final String IGNORE_TC = "FileSaver.ignoreTC";
    private long sequenceNumber = 0L;
    private String timeStamp;
    private int numberPadLength;

    public ResultSaver() {
    }

    public ResultSaver(String name) {
        this();
        this.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long nextNumber() {
        Object object = LOCK;
        synchronized (object) {
            return ++this.sequenceNumber;
        }
    }

    @Override
    public void testStarted() {
        this.testStarted("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testStarted(String host) {
        Object object = LOCK;
        synchronized (object) {
            this.sequenceNumber = 0L;
            if (this.getAddTimeStamp()) {
                DateTimeFormatter format = DateTimeFormatter.ofPattern(TIMESTAMP_FORMAT).withZone(ZoneId.systemDefault());
                this.timeStamp = format.format(Instant.now());
            } else {
                this.timeStamp = "";
            }
            this.numberPadLength = this.getNumberPadLen();
        }
    }

    @Override
    public void testEnded() {
        this.testEnded("");
    }

    @Override
    public void testEnded(String host) {
    }

    @Override
    public void sampleOccurred(SampleEvent e) {
        this.processSample(e.getResult(), new Counter());
    }

    private void processSample(SampleResult s, Counter c) {
        SampleResult[] sampleResults;
        this.saveSample(s, c.num++);
        for (SampleResult sampleResult : sampleResults = s.getSubResults()) {
            this.processSample(sampleResult, c);
        }
    }

    private void saveSample(SampleResult s, int num) {
        if (this.ignoreSampler(s)) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring SampleResult from Sampler {}", (Object)s.getSampleLabel());
            }
            return;
        }
        String fileName = this.makeFileName(s.getContentType(), this.getSkipAutoNumber(), this.getSkipSuffix());
        if (log.isDebugEnabled()) {
            log.debug("Saving {} in {}", (Object)s.getSampleLabel(), (Object)fileName);
        }
        s.setResultFileName(fileName);
        String variable = this.getVariableName();
        if (variable.length() > 0) {
            if (num > 0) {
                variable = variable + num;
            }
            JMeterContextService.getContext().getVariables().put(variable, fileName);
        }
        File out = new File(fileName);
        ResultSaver.createFoldersIfNeeded(out.getParentFile());
        try (FileOutputStream fos = new FileOutputStream(out);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            JOrphanUtils.write((byte[])s.getResponseData(), (OutputStream)bos);
        }
        catch (FileNotFoundException e) {
            log.error("Error creating sample file for {}", (Object)s.getSampleLabel(), (Object)e);
        }
        catch (IOException e) {
            log.error("Error saving sample {}", (Object)s.getSampleLabel(), (Object)e);
        }
    }

    private boolean ignoreSampler(SampleResult s) {
        if (this.getIgnoreTC() && TransactionController.isFromTransactionController(s)) {
            return true;
        }
        return s.isSuccessful() && this.getErrorsOnly() || !s.isSuccessful() && this.getSuccessOnly();
    }

    private static void createFoldersIfNeeded(File parentFile) {
        if (parentFile == null) {
            return;
        }
        if (!parentFile.exists()) {
            log.debug("Creating path hierarchy for folder {}", (Object)parentFile.getAbsolutePath());
            if (!parentFile.mkdirs()) {
                throw new JMeterStopTestNowException("Cannot create path hierarchy for folder " + parentFile.getAbsolutePath());
            }
        } else {
            log.debug("Folder {} already exists", (Object)parentFile.getAbsolutePath());
        }
    }

    String makeFileName(String contentType, boolean skipAutoNumber, boolean skipSuffix) {
        StringBuilder sb = new StringBuilder(FileServer.resolveBaseRelativeName(this.getFilename()));
        sb.append(this.timeStamp);
        if (!skipAutoNumber) {
            String number = Long.toString(this.nextNumber());
            for (int i = number.length(); i < this.numberPadLength; ++i) {
                sb.append('0');
            }
            sb.append(number);
        }
        if (!skipSuffix) {
            sb.append('.');
            if (contentType != null) {
                int i = contentType.indexOf(47);
                if (i != -1) {
                    int j = contentType.indexOf(59);
                    if (j != -1) {
                        sb.append(contentType.substring(i + 1, j));
                    } else {
                        sb.append(contentType.substring(i + 1));
                    }
                } else {
                    sb.append("unknown");
                }
            } else {
                sb.append("unknown");
            }
        }
        return sb.toString();
    }

    @Override
    public void sampleStarted(SampleEvent e) {
    }

    @Override
    public void sampleStopped(SampleEvent e) {
    }

    public String getFilename() {
        return this.getPropertyAsString(FILENAME);
    }

    public String getVariableName() {
        return this.getPropertyAsString(VARIABLE_NAME, "");
    }

    public boolean getErrorsOnly() {
        return this.getPropertyAsBoolean(ERRORS_ONLY);
    }

    public boolean getSkipAutoNumber() {
        return this.getPropertyAsBoolean(SKIP_AUTO_NUMBER);
    }

    public boolean getSkipSuffix() {
        return this.getPropertyAsBoolean(SKIP_SUFFIX);
    }

    public boolean getSuccessOnly() {
        return this.getPropertyAsBoolean(SUCCESS_ONLY);
    }

    public boolean getAddTimeStamp() {
        return this.getPropertyAsBoolean(ADD_TIMESTAMP);
    }

    public int getNumberPadLen() {
        return this.getPropertyAsInt(NUMBER_PAD_LENGTH, 0);
    }

    public boolean getIgnoreTC() {
        return this.getPropertyAsBoolean(IGNORE_TC, true);
    }

    public void setIgnoreTC(boolean value) {
        this.setProperty(IGNORE_TC, value, true);
    }

    public void setFilename(String value) {
        this.setProperty(FILENAME, value);
    }

    public void setAddTimestamp(boolean selected) {
        this.setProperty(ADD_TIMESTAMP, selected, false);
    }

    public void setVariableName(String value) {
        this.setProperty(VARIABLE_NAME, value, "");
    }

    public void setNumberPadLength(String text) {
        this.setProperty(NUMBER_PAD_LENGTH, text, "");
    }

    public void setErrorsOnly(boolean selected) {
        this.setProperty(ERRORS_ONLY, selected);
    }

    public void setSuccessOnly(boolean selected) {
        this.setProperty(SUCCESS_ONLY, selected);
    }

    public void setSkipSuffix(boolean selected) {
        this.setProperty(SKIP_SUFFIX, selected);
    }

    public void setSkipAutoNumber(boolean selected) {
        this.setProperty(SKIP_AUTO_NUMBER, selected);
    }

    private static class Counter {
        int num;

        private Counter() {
        }
    }
}

