/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.openmodel;

import java.io.Serializable;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.math.MathKt;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.schema.BaseTestElementSchema;
import org.apache.jmeter.testelement.schema.LongPropertyDescriptor;
import org.apache.jmeter.testelement.schema.PropertiesAccessor;
import org.apache.jmeter.testelement.schema.PropertyDescriptor;
import org.apache.jmeter.testelement.schema.StringPropertyDescriptor;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.TestCompilerHelper;
import org.apache.jmeter.threads.openmodel.OpenModelThreadGroup;
import org.apache.jmeter.threads.openmodel.OpenModelThreadGroupController;
import org.apache.jmeter.threads.openmodel.OpenModelThreadGroupSchema;
import org.apache.jmeter.threads.openmodel.ThreadSchedule;
import org.apache.jmeter.threads.openmodel.ThreadScheduleProcessGenerator;
import org.apache.jmeter.threads.openmodel.ThreadScheduleUtils;
import org.apache.jorphan.collections.ListedHashTree;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GUIMenuSortOrder(value=1)
@API(status=API.Status.EXPERIMENTAL, since="5.5")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u0007\u0018\u0000 C2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0002CDB\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\b\u00100\u001a\u00020-H\u0016J\b\u00101\u001a\u000202H\u0016J(\u00103\u001a\u0002022\u0006\u00104\u001a\u00020-2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010.\u001a\u00020/H\u0016J\b\u00109\u001a\u000202H\u0016J\u001a\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010\u001a2\u0006\u0010=\u001a\u00020;H\u0016J\b\u0010>\u001a\u000202H\u0016J\u0012\u0010?\u001a\u0002022\b\u0010@\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010A\u001a\u00020;H\u0016J\b\u0010B\u001a\u000202H\u0016R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u0018\u0012\t\u0012\u00070\u0000\u00a2\u0006\u0002\b\u000f\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R+\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR+\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010!\u001a\u0004\b#\u0010\u001d\"\u0004\b$\u0010\u001fR\u0014\u0010&\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\n0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/apache/jmeter/threads/openmodel/OpenModelThreadGroup;", "Lorg/apache/jmeter/threads/AbstractThreadGroup;", "Ljava/io/Serializable;", "Lorg/apache/jmeter/control/Controller;", "Lorg/apache/jmeter/threads/JMeterThreadMonitor;", "Lorg/apache/jmeter/threads/TestCompilerHelper;", "()V", "activeThreads", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/apache/jmeter/threads/JMeterThread;", "Ljava/util/concurrent/Future;", "executorService", "Ljava/util/concurrent/ExecutorService;", "props", "Lorg/apache/jmeter/testelement/schema/PropertiesAccessor;", "Lkotlin/jvm/JvmWildcard;", "Lorg/apache/jmeter/threads/openmodel/OpenModelThreadGroupSchema;", "getProps", "()Lorg/apache/jmeter/testelement/schema/PropertiesAccessor;", "randomSeed", "", "getRandomSeed", "()J", "randomSeed$delegate", "Lorg/apache/jmeter/testelement/schema/LongPropertyDescriptor;", "<set-?>", "", "randomSeedString", "getRandomSeedString", "()Ljava/lang/String;", "setRandomSeedString", "(Ljava/lang/String;)V", "randomSeedString$delegate", "Lorg/apache/jmeter/testelement/schema/StringPropertyDescriptor;", "scheduleString", "getScheduleString", "setScheduleString", "scheduleString$delegate", "schema", "getSchema", "()Lorg/apache/jmeter/threads/openmodel/OpenModelThreadGroupSchema;", "threadStarterFuture", "Ljava/util/concurrent/atomic/AtomicReference;", "addNewThread", "delay", "", "engine", "Lorg/apache/jmeter/engine/StandardJMeterEngine;", "numberOfActiveThreads", "recoverRunningVersion", "", "start", "threadGroupIndex", "notifier", "Lorg/apache/jmeter/threads/ListenerNotifier;", "threadGroupTree", "Lorg/apache/jorphan/collections/ListedHashTree;", "stop", "stopThread", "", "threadName", "now", "tellThreadsToStop", "threadFinished", "thread", "verifyThreadsStopped", "waitThreadsStopped", "Companion", "ThreadsStarter", "ApacheJMeter_core"})
@SourceDebugExtension(value={"SMAP\nOpenModelThreadGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenModelThreadGroup.kt\norg/apache/jmeter/threads/openmodel/OpenModelThreadGroup\n+ 2 StringPropertyDescriptor.kt\norg/apache/jmeter/testelement/schema/StringPropertyDescriptor\n+ 3 LongPropertyDescriptor.kt\norg/apache/jmeter/testelement/schema/LongPropertyDescriptor\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n46#2,8:281\n46#2,8:290\n50#3:289\n215#4,2:298\n1855#5,2:300\n*S KotlinDebug\n*F\n+ 1 OpenModelThreadGroup.kt\norg/apache/jmeter/threads/openmodel/OpenModelThreadGroup\n*L\n108#1:281,8\n115#1:290,8\n110#1:289\n265#1:298,2\n273#1:300,2\n*E\n"})
public final class OpenModelThreadGroup
extends AbstractThreadGroup
implements Serializable,
Controller,
JMeterThreadMonitor,
TestCompilerHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ExecutorService executorService;
    @NotNull
    private final AtomicReference<Future<?>> threadStarterFuture = new AtomicReference();
    @NotNull
    private final ConcurrentHashMap<JMeterThread, Future<?>> activeThreads = new ConcurrentHashMap();
    @NotNull
    private final StringPropertyDescriptor scheduleString$delegate = OpenModelThreadGroupSchema.INSTANCE.getSchedule();
    @NotNull
    private final LongPropertyDescriptor randomSeed$delegate = OpenModelThreadGroupSchema.INSTANCE.getRandomSeed();
    @NotNull
    private final StringPropertyDescriptor randomSeedString$delegate = OpenModelThreadGroupSchema.INSTANCE.getRandomSeed().getAsString();
    private static final Logger log = LoggerFactory.getLogger(OpenModelThreadGroup.class);
    @NotNull
    private static final String SCHEDULE = OpenModelThreadGroupSchema.INSTANCE.getSchedule().getName();
    @NotNull
    private static final String RANDOM_SEED = OpenModelThreadGroupSchema.INSTANCE.getRandomSeed().getName();
    private static final ExecutorService houseKeepingThreadPool = Executors.newCachedThreadPool();
    private static final long serialVersionUID = 1L;

    public OpenModelThreadGroup() {
        this.set(OpenModelThreadGroupSchema.INSTANCE.getMainController(), (TestElement)new OpenModelThreadGroupController());
    }

    @Override
    @NotNull
    public OpenModelThreadGroupSchema getSchema() {
        return OpenModelThreadGroupSchema.INSTANCE;
    }

    @NotNull
    public PropertiesAccessor<? extends OpenModelThreadGroup, ? extends OpenModelThreadGroupSchema> getProps() {
        return new PropertiesAccessor<TestElement, BaseTestElementSchema>(this, this.getSchema());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getScheduleString() {
        void this_$iv;
        StringPropertyDescriptor stringPropertyDescriptor = this.scheduleString$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((TestElement)this).get((StringPropertyDescriptor<?>)this_$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void setScheduleString(@NotNull String string) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        StringPropertyDescriptor stringPropertyDescriptor = this.scheduleString$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        ((TestElement)this).set((PropertyDescriptor)this_$iv, string);
    }

    /*
     * WARNING - void declaration
     */
    public final long getRandomSeed() {
        void this_$iv;
        LongPropertyDescriptor longPropertyDescriptor = this.randomSeed$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((TestElement)this).get((LongPropertyDescriptor<?>)this_$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getRandomSeedString() {
        void this_$iv;
        StringPropertyDescriptor stringPropertyDescriptor = this.randomSeedString$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((TestElement)this).get((StringPropertyDescriptor<?>)this_$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void setRandomSeedString(@NotNull String string) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        StringPropertyDescriptor stringPropertyDescriptor = this.randomSeedString$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        ((TestElement)this).set((PropertyDescriptor)this_$iv, string);
    }

    @Override
    public void recoverRunningVersion() {
    }

    @Override
    public void start(int threadGroupIndex, @NotNull ListenerNotifier notifier, @NotNull ListedHashTree threadGroupTree, @NotNull StandardJMeterEngine engine) {
        Intrinsics.checkNotNullParameter((Object)notifier, (String)"notifier");
        Intrinsics.checkNotNullParameter((Object)threadGroupTree, (String)"threadGroupTree");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        try {
            ExecutorService executorService;
            JMeterContext jMeterContext = JMeterContextService.getContext();
            JMeterVariables variables = jMeterContext.getVariables();
            String schedule = this.getScheduleString();
            log.info("Starting OpenModelThreadGroup#{} with schedule {}", (Object)threadGroupIndex, (Object)schedule);
            ThreadSchedule parsedSchedule = ThreadScheduleUtils.ThreadSchedule(schedule);
            long seed = this.getRandomSeed();
            Random rnd = seed == 0L ? new Random() : new Random(seed);
            ThreadScheduleProcessGenerator gen = new ThreadScheduleProcessGenerator(rnd, parsedSchedule);
            long testStartTime = JMeterContextService.getTestStartTime();
            this.executorService = executorService = Executors.newCachedThreadPool();
            Intrinsics.checkNotNull((Object)executorService);
            ThreadsStarter starter2 = new ThreadsStarter(testStartTime, executorService, (Map)this.activeThreads, gen, (Function1<? super Integer, ? extends JMeterThread>)((Function1)new Function1<Integer, JMeterThread>(threadGroupTree, this, engine, notifier, threadGroupIndex, variables){
                final /* synthetic */ ListedHashTree $threadGroupTree;
                final /* synthetic */ OpenModelThreadGroup this$0;
                final /* synthetic */ StandardJMeterEngine $engine;
                final /* synthetic */ ListenerNotifier $notifier;
                final /* synthetic */ int $threadGroupIndex;
                final /* synthetic */ JMeterVariables $variables;
                {
                    this.$threadGroupTree = $threadGroupTree;
                    this.this$0 = $receiver;
                    this.$engine = $engine;
                    this.$notifier = $notifier;
                    this.$threadGroupIndex = $threadGroupIndex;
                    this.$variables = $variables;
                    super(1);
                }

                @NotNull
                public final JMeterThread invoke(int threadNumber) {
                    ListedHashTree clonedTree = AbstractThreadGroup.cloneTree(this.$threadGroupTree);
                    JMeterThread jMeterThread = OpenModelThreadGroup.access$makeThread(this.this$0, this.$engine, this.this$0, this.$notifier, this.$threadGroupIndex, threadNumber, clonedTree, this.$variables);
                    Intrinsics.checkNotNullExpressionValue((Object)jMeterThread, (String)"access$makeThread(...)");
                    return jMeterThread;
                }
            }));
            this.threadStarterFuture.set(houseKeepingThreadPool.submit(() -> OpenModelThreadGroup.start$lambda$0(this, threadGroupIndex, starter2)));
        }
        catch (Throwable t) {
            Throwable throwable;
            Throwable $this$start_u24lambda_u241 = throwable = t;
            boolean bl = false;
            ExceptionsKt.addSuppressed((Throwable)$this$start_u24lambda_u241, (Throwable)new IllegalArgumentException("Failed to start OpenModelThreadGroup " + this.getName() + '-' + threadGroupIndex));
            throw throwable;
        }
    }

    @Override
    public void threadFinished(@Nullable JMeterThread thread) {
        TypeIntrinsics.asMutableMap((Object)this.activeThreads).remove(thread);
    }

    @Override
    @NotNull
    public JMeterThread addNewThread(int delay, @Nullable StandardJMeterEngine engine) {
        String string = "Will not be implemented as the semantics of the API is unclear";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public boolean stopThread(@Nullable String threadName, boolean now) {
        String string = "Will not be implemented as the semantics of the API is unclear";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public int numberOfActiveThreads() {
        return this.activeThreads.size();
    }

    @Override
    public boolean verifyThreadsStopped() {
        ExecutorService executorService = this.executorService;
        return !(executorService != null ? !executorService.awaitTermination(0L, TimeUnit.SECONDS) : false);
    }

    @Override
    public void waitThreadsStopped() {
        block0: {
            ExecutorService executorService = this.executorService;
            if (executorService == null) break block0;
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
    }

    @Override
    public void stop() {
        log.info("Gracefully stopping the threads");
        Future future = this.threadStarterFuture.getAndSet(null);
        if (future != null) {
            future.cancel(true);
        }
        this.activeThreads.forEach((arg_0, arg_1) -> OpenModelThreadGroup.stop$lambda$2(stop.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    public void tellThreadsToStop() {
        block2: {
            this.stop();
            log.info("Interrupting the threads");
            Map $this$forEach$iv = this.activeThreads;
            boolean $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                Map.Entry entry = element$iv;
                boolean bl = false;
                JMeterThread thread = (JMeterThread)entry.getKey();
                Future future = (Future)entry.getValue();
                log.info("Interrupting thread {}", (Object)thread);
                thread.interrupt();
                future.cancel(true);
            }
            Object object = this.executorService;
            if (object == null || (object = object.shutdownNow()) == null) break block2;
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Runnable it = (Runnable)element$iv;
                boolean bl = false;
                TypeIntrinsics.asMutableMap((Object)this.activeThreads).remove(it);
            }
        }
    }

    private static final void start$lambda$0(OpenModelThreadGroup this$0, int $threadGroupIndex, ThreadsStarter $starter) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$starter, (String)"$starter");
        Thread.currentThread().setName("open-model-thread-starter-" + this$0.getName() + '-' + $threadGroupIndex);
        $starter.run();
    }

    private static final void stop$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ JMeterThread access$makeThread(OpenModelThreadGroup $this, StandardJMeterEngine engine, JMeterThreadMonitor monitor, ListenerNotifier notifier, int groupNumber, int threadNumber, ListedHashTree threadGroupTree, JMeterVariables variables) {
        return $this.makeThread(engine, monitor, notifier, groupNumber, threadNumber, threadGroupTree, variables);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/apache/jmeter/threads/openmodel/OpenModelThreadGroup$Companion;", "", "()V", "RANDOM_SEED", "", "getRANDOM_SEED$annotations", "getRANDOM_SEED", "()Ljava/lang/String;", "SCHEDULE", "getSCHEDULE$annotations", "getSCHEDULE", "houseKeepingThreadPool", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "serialVersionUID", "", "ApacheJMeter_core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSCHEDULE() {
            return SCHEDULE;
        }

        @Deprecated(message="Use OpenModelThreadGroupSchema instead", replaceWith=@ReplaceWith(expression="OpenModelThreadGroupSchema.getSchedule", imports={"org.apache.jmeter.threads.openmodel.OpenModelThreadGroupSchema"}), level=DeprecationLevel.WARNING)
        public static /* synthetic */ void getSCHEDULE$annotations() {
        }

        @NotNull
        public final String getRANDOM_SEED() {
            return RANDOM_SEED;
        }

        @Deprecated(message="Use OpenModelThreadGroupSchema instead", replaceWith=@ReplaceWith(expression="OpenModelThreadGroupSchema.randomSeed", imports={"org.apache.jmeter.threads.openmodel.OpenModelThreadGroupSchema"}), level=DeprecationLevel.WARNING)
        public static /* synthetic */ void getRANDOM_SEED$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BX\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\b0\r\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/apache/jmeter/threads/openmodel/OpenModelThreadGroup$ThreadsStarter;", "Ljava/lang/Runnable;", "testStartTime", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "activeThreads", "", "Lorg/apache/jmeter/threads/JMeterThread;", "Ljava/util/concurrent/Future;", "gen", "Lorg/apache/jmeter/threads/openmodel/ThreadScheduleProcessGenerator;", "jmeterThreadFactory", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "threadNumber", "(JLjava/util/concurrent/ExecutorService;Ljava/util/Map;Lorg/apache/jmeter/threads/openmodel/ThreadScheduleProcessGenerator;Lkotlin/jvm/functions/Function1;)V", "run", "", "ApacheJMeter_core"})
    private static final class ThreadsStarter
    implements Runnable {
        private final long testStartTime;
        @NotNull
        private final ExecutorService executorService;
        @NotNull
        private final Map<JMeterThread, Future<?>> activeThreads;
        @NotNull
        private final ThreadScheduleProcessGenerator gen;
        @NotNull
        private final Function1<Integer, JMeterThread> jmeterThreadFactory;

        public ThreadsStarter(long testStartTime, @NotNull ExecutorService executorService, @NotNull Map<JMeterThread, Future<?>> activeThreads, @NotNull ThreadScheduleProcessGenerator gen, @NotNull Function1<? super Integer, ? extends JMeterThread> jmeterThreadFactory) {
            Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
            Intrinsics.checkNotNullParameter(activeThreads, (String)"activeThreads");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter(jmeterThreadFactory, (String)"jmeterThreadFactory");
            this.testStartTime = testStartTime;
            this.executorService = executorService;
            this.activeThreads = activeThreads;
            this.gen = gen;
            this.jmeterThreadFactory = jmeterThreadFactory;
        }

        @Override
        public void run() {
            log.info("Thread starting init");
            long endTime = MathKt.roundToLong((double)((double)this.testStartTime + this.gen.getTotalDuration() * (double)1000));
            int threadNumber = 0;
            long prevTime = 0L;
            while (this.gen.hasNext()) {
                Future<?> future;
                long nextDelay;
                long scheduledTime = this.testStartTime + MathKt.roundToLong((double)(this.gen.nextDouble() * (double)1000));
                if (scheduledTime >= prevTime && (nextDelay = scheduledTime - (prevTime = System.currentTimeMillis())) > 0L) {
                    Thread.sleep(nextDelay);
                }
                JMeterThread jmeterThread = (JMeterThread)this.jmeterThreadFactory.invoke((Object)threadNumber++);
                jmeterThread.setEndTime(endTime);
                Map<JMeterThread, Future<?>> map = this.activeThreads;
                Intrinsics.checkNotNullExpressionValue(this.executorService.submit(() -> ThreadsStarter.run$lambda$0(jmeterThread)), (String)"submit(...)");
                map.put(jmeterThread, future);
            }
            long timeLeft = endTime - System.currentTimeMillis();
            if (timeLeft > 0L) {
                log.info("There will be no more events, so will wait for {} sec till the end of the schedule", (Object)TimeUnit.MILLISECONDS.toSeconds(timeLeft));
                Thread.sleep(timeLeft);
            } else {
                log.info("Thread schedule finished {} ms ago", (Object)(-timeLeft));
            }
            int threadsStillRunning = this.activeThreads.size();
            if (threadsStillRunning == 0) {
                log.info("There will be no more events, will shutdown the thread pool");
            } else {
                log.info("Test schedule finished, however, there are {} thread(s) still running. Will interrupt the threads. If you want to keep some time for the threads to complete, consider adding pause(10 min) at the end of the schedule.", (Object)threadsStillRunning);
                this.activeThreads.forEach((arg_0, arg_1) -> ThreadsStarter.run$lambda$1(run.2.INSTANCE, arg_0, arg_1));
            }
            this.executorService.shutdownNow();
            log.info("Thread starting done");
        }

        private static final void run$lambda$0(JMeterThread $jmeterThread) {
            Intrinsics.checkNotNullParameter((Object)$jmeterThread, (String)"$jmeterThread");
            Thread.currentThread().setName($jmeterThread.getThreadName());
            $jmeterThread.run();
        }

        private static final void run$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }
    }
}

