/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.function.TransformByFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SortByFunction
extends TransformByFunction {
    @Override
    protected <T> TransformByFunction.Aggregator<T> createAggregator(Adapter<T> runtime, int elementCount, T element, T elementValue) {
        return new SortingAggregator<T>(runtime, elementCount, element, elementValue);
    }

    @Override
    protected <T> T createNullValue(Adapter<T> runtime) {
        return runtime.createArray(new ArrayList());
    }

    private static class Pair<U> {
        public final U element;
        public final U elementValue;

        public Pair(U element, U elementValue) {
            this.element = element;
            this.elementValue = elementValue;
        }
    }

    private class SortingAggregator<V>
    extends TransformByFunction.Aggregator<V> {
        private List<Pair<V>> pairs;

        public SortingAggregator(Adapter<V> runtime, int elementCount, V initialElement, V initialValue) {
            super(runtime);
            this.pairs = new ArrayList<Pair<V>>(elementCount);
            this.pairs.add(new Pair<V>(initialElement, initialValue));
        }

        @Override
        protected void aggregate(V candidate, V candidateValue) {
            this.pairs.add(new Pair<V>(candidate, candidateValue));
        }

        @Override
        protected V result() {
            return (V)this.runtime.createArray(this.sortAndFlatten(this.runtime, this.pairs));
        }

        private <T> List<T> sortAndFlatten(final Adapter<T> runtime, List<Pair<T>> pairs) {
            Collections.sort(pairs, new Comparator<Pair<T>>(){

                @Override
                public int compare(Pair<T> a, Pair<T> b) {
                    return runtime.compare(a.elementValue, b.elementValue);
                }
            });
            ArrayList sorted = new ArrayList(pairs.size());
            for (Pair<T> pair : pairs) {
                sorted.add(pair.element);
            }
            return sorted;
        }
    }
}

