/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.node.Node;
import java.util.LinkedList;
import java.util.List;

public class FlattenArrayNode<T>
extends Node<T> {
    public FlattenArrayNode(Adapter<T> runtime) {
        super(runtime);
    }

    @Override
    public T search(T input) {
        if (this.runtime.typeOf(input) == JmesPathType.ARRAY) {
            List<T> elements = this.runtime.toList(input);
            LinkedList<T> flattened = new LinkedList<T>();
            for (T element : elements) {
                if (this.runtime.typeOf(element) == JmesPathType.ARRAY) {
                    flattened.addAll(this.runtime.toList(element));
                    continue;
                }
                flattened.add(element);
            }
            return (T)this.runtime.createArray(flattened);
        }
        return this.runtime.createNull();
    }

    @Override
    protected boolean internalEquals(Object o) {
        return true;
    }

    @Override
    protected int internalHashCode() {
        return 19;
    }
}

