/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.CrossBarGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.BoxHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.FlippableGeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0002J0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J0\u0010(\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0006H\u0002J.\u0010,\u001a\u0010\u0012\u0004\u0012\u00020.\u0012\u0006\u0012\u0004\u0018\u00010\u00170-2\u0006\u0010&\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0003H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00061"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "isVertical", "", "(Z)V", "fattenMidline", "", "getFattenMidline", "()D", "setFattenMidline", "(D)V", "flipHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/FlippableGeomHelper;", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "wontRender", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "getWontRender", "()Ljava/util/List;", "afterRotation", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "rectangle", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "vector", "aes", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "buildMidlines", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "fatten", "clientRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "isHintRect", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nCrossBarGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrossBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1549#2:144\n1620#2,3:145\n1549#2:148\n1620#2,3:149\n*S KotlinDebug\n*F\n+ 1 CrossBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom\n*L\n24#1:144\n24#1:145,3\n54#1:148\n54#1:149,3\n*E\n"})
public final class CrossBarGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isVertical;
    @NotNull
    private final FlippableGeomHelper flipHelper;
    private double fattenMidline;
    public static final boolean HANDLES_GROUPS = false;
    @NotNull
    private static final LegendKeyElementFactory LEGEND_FACTORY = BoxHelper.INSTANCE.legendFactory(false);

    public CrossBarGeom(boolean isVertical) {
        this.isVertical = isVertical;
        this.flipHelper = new FlippableGeomHelper(this.isVertical);
        this.fattenMidline = 2.5;
    }

    public final double getFattenMidline() {
        return this.fattenMidline;
    }

    public final void setFattenMidline(double d) {
        this.fattenMidline = d;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return LEGEND_FACTORY;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Aes<?>> getWontRender() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Aes[]{Aes.Companion.getXMIN(), Aes.Companion.getXMAX()};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Aes aes2 = (Aes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.afterRotation((Aes<Double>)p0));
        }
        return (List)destination$iv$iv;
    }

    private final Aes<Double> afterRotation(Aes<Double> aes2) {
        return this.flipHelper.getEffectiveAes(aes2);
    }

    private final DoubleRectangle afterRotation(DoubleRectangle rectangle) {
        return this.flipHelper.flip(rectangle);
    }

    private final DoubleVector afterRotation(DoubleVector vector) {
        return this.flipHelper.flip(vector);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx);
        BoxHelper.INSTANCE.buildBoxes(root, aesthetics2, pos, coord, ctx, this.clientRectByDataPoint(ctx, geomHelper, false));
        this.buildMidlines(root, aesthetics2, ctx, geomHelper, this.fattenMidline);
        Object object = new Aes[]{Aes.Companion.getYMIN(), Aes.Companion.getYMAX()};
        object = CollectionsKt.listOf((Object[])object);
        FlippableGeomHelper flippableGeomHelper = this.flipHelper;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Aes aes2 = (Aes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.afterRotation((Aes<Double>)p0));
        }
        FlippableGeomHelper.buildHints$default(flippableGeomHelper, (List)destination$iv$iv, aesthetics2, pos, coord, ctx, this.clientRectByDataPoint(ctx, geomHelper, true), buildIntern.2.INSTANCE, null, null, 384, null);
    }

    private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomContext ctx, GeomHelper geomHelper, boolean isHintRect) {
        return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(this, isHintRect, ctx, geomHelper){
            final /* synthetic */ CrossBarGeom this$0;
            final /* synthetic */ boolean $isHintRect;
            final /* synthetic */ GeomContext $ctx;
            final /* synthetic */ GeomHelper $geomHelper;
            {
                this.this$0 = $receiver;
                this.$isHintRect = $isHintRect;
                this.$ctx = $ctx;
                this.$geomHelper = $geomHelper;
                super(1);
            }

            @Nullable
            public final DoubleRectangle invoke(@NotNull DataPointAesthetics p) {
                DoubleRectangle doubleRectangle;
                DoubleRectangle rect;
                DoubleRectangle doubleRectangle2;
                double x;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Aes xAes = CrossBarGeom.access$afterRotation(this.this$0, Aes.Companion.getX());
                Aes yAes = CrossBarGeom.access$afterRotation(this.this$0, Aes.Companion.getY());
                Aes minAes = CrossBarGeom.access$afterRotation(this.this$0, Aes.Companion.getYMIN());
                Aes maxAes = CrossBarGeom.access$afterRotation(this.this$0, Aes.Companion.getYMAX());
                Aes<Double> sizeAes = Aes.Companion.getWIDTH();
                if (!this.$isHintRect && p.defined(xAes) && p.defined(minAes) && p.defined(maxAes) && p.defined(sizeAes)) {
                    T t = p.get(xAes);
                    Intrinsics.checkNotNull(t);
                    x = ((Number)t).doubleValue();
                    T t2 = p.get(minAes);
                    Intrinsics.checkNotNull(t2);
                    double ymin = ((Number)t2).doubleValue();
                    T t3 = p.get(maxAes);
                    Intrinsics.checkNotNull(t3);
                    double ymax = ((Number)t3).doubleValue();
                    Double d = p.get(sizeAes);
                    Intrinsics.checkNotNull((Object)d);
                    double width2 = ((Number)d).doubleValue() * this.$ctx.getResolution(xAes);
                    DoubleVector origin = new DoubleVector(x - width2 / (double)2, ymin);
                    DoubleVector dimensions = new DoubleVector(width2, ymax - ymin);
                    doubleRectangle2 = new DoubleRectangle(origin, dimensions);
                } else if (this.$isHintRect && p.defined(xAes) && p.defined(yAes) && p.defined(sizeAes)) {
                    T t = p.get(xAes);
                    Intrinsics.checkNotNull(t);
                    x = ((Number)t).doubleValue();
                    T t4 = p.get(yAes);
                    Intrinsics.checkNotNull(t4);
                    double y = ((Number)t4).doubleValue();
                    Double d = p.get(sizeAes);
                    Intrinsics.checkNotNull((Object)d);
                    double width3 = ((Number)d).doubleValue() * this.$ctx.getResolution(xAes);
                    DoubleVector origin = new DoubleVector(x - width3 / (double)2, y);
                    DoubleVector dimensions = new DoubleVector(width3, 0.0);
                    doubleRectangle2 = new DoubleRectangle(origin, dimensions);
                } else {
                    doubleRectangle2 = null;
                }
                DoubleRectangle doubleRectangle3 = rect = doubleRectangle2;
                if (doubleRectangle3 != null) {
                    DoubleRectangle doubleRectangle4 = doubleRectangle3;
                    GeomHelper geomHelper = this.$geomHelper;
                    CrossBarGeom crossBarGeom = this.this$0;
                    DoubleRectangle it = doubleRectangle4;
                    boolean bl = false;
                    doubleRectangle = geomHelper.toClient(CrossBarGeom.access$afterRotation(crossBarGeom, it), p);
                } else {
                    doubleRectangle = null;
                }
                return doubleRectangle;
            }
        };
    }

    private final void buildMidlines(SvgRoot root, Aesthetics aesthetics2, GeomContext ctx, GeomHelper geomHelper, double fatten) {
        GeomHelper.SvgElementHelper elementHelper = geomHelper.createSvgElementHelper();
        Aes<Double> xAes = this.afterRotation(Aes.Companion.getX());
        Aes<Double> yAes = this.afterRotation(Aes.Companion.getY());
        Aes<Double> sizeAes = Aes.Companion.getWIDTH();
        for (DataPointAesthetics p : GeomUtil.INSTANCE.withDefined(aesthetics2.dataPoints(), xAes, yAes, sizeAes)) {
            SvgLineElement line;
            Double d = p.get(xAes);
            Intrinsics.checkNotNull((Object)d);
            double x = ((Number)d).doubleValue();
            Double d2 = p.get(yAes);
            Intrinsics.checkNotNull((Object)d2);
            double middle = ((Number)d2).doubleValue();
            Double d3 = p.get(sizeAes);
            Intrinsics.checkNotNull((Object)d3);
            double width2 = ((Number)d3).doubleValue() * ctx.getResolution(xAes);
            Intrinsics.checkNotNull((Object)GeomHelper.SvgElementHelper.createLine$default(elementHelper, this.afterRotation(new DoubleVector(x - width2 / (double)2, middle)), this.afterRotation(new DoubleVector(x + width2 / (double)2, middle)), p, null, 8, null));
            Object object = line.strokeWidth().get();
            Intrinsics.checkNotNull((Object)object);
            double thickness = ((Number)object).doubleValue();
            line.strokeWidth().set((Object)(thickness * fatten));
            root.add((SvgNode)line);
        }
    }

    public static final /* synthetic */ Aes access$afterRotation(CrossBarGeom $this, Aes aes2) {
        return $this.afterRotation(aes2);
    }

    public static final /* synthetic */ DoubleRectangle access$afterRotation(CrossBarGeom $this, DoubleRectangle rectangle) {
        return $this.afterRotation(rectangle);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "LEGEND_FACTORY", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

