/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.serialize.convert;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.serialize.convert.ISerializationConverter;
import com.helger.commons.serialize.convert.ISerializationConverterRegistrarSPI;
import com.helger.commons.serialize.convert.ISerializationConverterRegistry;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.imageio.ImageIO;

@IsSPIImplementation
@Immutable
public final class BasicSerializationConverterRegistrar
implements ISerializationConverterRegistrarSPI {
    @Override
    public void registerSerializationConverter(@Nonnull ISerializationConverterRegistry iSerializationConverterRegistry) {
        iSerializationConverterRegistry.registerSerializationConverter(BufferedImage.class, new SerializationConverterBufferedImage());
        iSerializationConverterRegistry.registerSerializationConverter(Charset.class, new SerializationConverterCharset());
    }

    private static final class SerializationConverterCharset
    implements ISerializationConverter<Charset> {
        private SerializationConverterCharset() {
        }

        @Override
        public void writeConvertedObject(@Nonnull Charset charset, @Nonnull ObjectOutputStream objectOutputStream) throws IOException {
            StreamHelper.writeSafeUTF(objectOutputStream, charset.name());
        }

        @Override
        public Charset readConvertedObject(@Nonnull ObjectInputStream objectInputStream) throws IOException {
            String string = StreamHelper.readSafeUTF(objectInputStream);
            return CharsetHelper.getCharsetFromName(string);
        }
    }

    private static final class SerializationConverterBufferedImage
    implements ISerializationConverter<BufferedImage> {
        private SerializationConverterBufferedImage() {
        }

        @Override
        public void writeConvertedObject(@Nonnull BufferedImage bufferedImage, @Nonnull ObjectOutputStream objectOutputStream) throws IOException {
            ImageIO.write((RenderedImage)bufferedImage, "png", objectOutputStream);
        }

        @Override
        public BufferedImage readConvertedObject(@Nonnull ObjectInputStream objectInputStream) throws IOException {
            return ImageIO.read(objectInputStream);
        }
    }
}

