/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert.rule;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.typeconvert.ITypeConverterRule;
import com.helger.commons.typeconvert.rule.AbstractTypeConverterRule;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TypeConverterRuleAssignableSourceFixedDestination<SRC, DST>
extends AbstractTypeConverterRule<SRC, DST> {
    private final Class<SRC> m_aSrcClass;
    private final Class<DST> m_aDstClass;
    private final Function<? super SRC, ? extends DST> m_aConverter;

    public TypeConverterRuleAssignableSourceFixedDestination(@Nonnull Class<SRC> clazz, @Nonnull Class<DST> clazz2, @Nonnull Function<? super SRC, ? extends DST> function) {
        super(ITypeConverterRule.ESubType.ASSIGNABLE_SRC_FIXED_DST);
        this.m_aSrcClass = ValueEnforcer.notNull(clazz, "SrcClass");
        this.m_aDstClass = ValueEnforcer.notNull(clazz2, "DestClass");
        this.m_aConverter = ValueEnforcer.notNull(function, "Converter");
    }

    @Override
    public final boolean canConvert(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        return this.m_aDstClass.equals(clazz2) && this.m_aSrcClass.isAssignableFrom(clazz);
    }

    @Nonnull
    public final Class<SRC> getSourceClass() {
        return this.m_aSrcClass;
    }

    @Nonnull
    public final Class<DST> getDestinationClass() {
        return this.m_aDstClass;
    }

    @Override
    @Nullable
    public DST apply(@Nonnull SRC SRC) {
        return this.m_aConverter.apply(SRC);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("SrcClass", this.m_aSrcClass).append("DstClass", this.m_aDstClass).append("Converter", this.m_aConverter).getToString();
    }
}

