/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.RectangularShape;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.interfaces.IAxisChartDataSet;
import org.jCharts.chartData.interfaces.IDataSeries;
import org.jCharts.imageMap.CircleMapArea;
import org.jCharts.properties.LineChartProperties;
import org.jCharts.properties.PropertyException;

abstract class LineChart {
    LineChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) throws PropertyException {
        Shape shape;
        int n;
        Object object;
        Graphics2D graphics2D = axisChart.getGraphics2D();
        LineChartProperties lineChartProperties = (LineChartProperties)iAxisChartDataSet.getChartTypeProperties();
        lineChartProperties.validate(iAxisChartDataSet);
        IDataSeries iDataSeries = (IDataSeries)axisChart.getIAxisDataSeries();
        float[][] fArray = new float[iAxisChartDataSet.getNumberOfDataSets()][iAxisChartDataSet.getNumberOfDataItems()];
        float f = axisChart.getXAxis().getTickStart();
        int n2 = 0;
        while (n2 < iAxisChartDataSet.getNumberOfDataItems()) {
            int n3 = 0;
            while (n3 < fArray.length) {
                if (iAxisChartDataSet.getValue(n3, n2) != Double.NaN) {
                    fArray[n3][n2] = axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iAxisChartDataSet.getValue(n3, n2), axisChart.getYAxis().getScaleCalculator().getMinValue());
                    if (axisChart.getGenerateImageMapFlag()) {
                        object = axisChart.getXAxis().getAxisLabelsGroup() != null ? (Object)axisChart.getXAxis().getAxisLabelsGroup().getTextTag(n2).getText() : null;
                        axisChart.getImageMap().addImageMapArea(new CircleMapArea(f, fArray[n3][n2], iAxisChartDataSet.getValue(n3, n2), (String)object, iAxisChartDataSet.getLegendLabel(n3)));
                    }
                } else {
                    fArray[n3][n2] = Float.NaN;
                }
                ++n3;
            }
            f += axisChart.getXAxis().getScalePixelWidth();
            ++n2;
        }
        AffineTransform affineTransform = null;
        object = null;
        double[] dArray = null;
        if (lineChartProperties.getShapes() != null) {
            object = new double[iAxisChartDataSet.getNumberOfDataSets()];
            dArray = new double[iAxisChartDataSet.getNumberOfDataSets()];
            affineTransform = graphics2D.getTransform();
            n = 0;
            while (n < iAxisChartDataSet.getNumberOfDataSets()) {
                if (lineChartProperties.getShapes()[n] != null) {
                    shape = lineChartProperties.getShapes()[n].getBounds2D();
                    object[n] = ((RectangularShape)shape).getWidth() / 2.0;
                    dArray[n] = ((RectangularShape)shape).getHeight() / 2.0;
                }
                ++n;
            }
        }
        shape = new Line2D.Float(axisChart.getXAxis().getTickStart(), fArray[0][0], axisChart.getXAxis().getTickStart(), fArray[0][0]);
        if (fArray[0].length > 1) {
            ((Line2D.Float)shape).y2 = fArray[0][1];
        }
        n = 0;
        while (n < fArray.length) {
            ((Line2D.Float)shape).x1 = axisChart.getXAxis().getTickStart();
            ((Line2D.Float)shape).y1 = fArray[n][0];
            ((Line2D.Float)shape).x2 = ((Line2D.Float)shape).x1;
            int n4 = 1;
            while (n4 < fArray[0].length) {
                if (!Float.isNaN(fArray[n][n4])) {
                    if (Float.isNaN(fArray[n][n4 - 1])) {
                        ((Line2D.Float)shape).x2 += axisChart.getXAxis().getScalePixelWidth();
                        ((Line2D.Float)shape).x1 = ((Line2D.Float)shape).x2;
                        ((Line2D.Float)shape).y1 = fArray[n][n4];
                        ((Line2D.Float)shape).y2 = fArray[n][n4];
                    } else {
                        ((Line2D.Float)shape).x2 += axisChart.getXAxis().getScalePixelWidth();
                        ((Line2D.Float)shape).y2 = fArray[n][n4];
                        graphics2D.setPaint(iAxisChartDataSet.getPaint(n));
                        graphics2D.setStroke(lineChartProperties.getLineStrokes()[n]);
                        graphics2D.draw(shape);
                        if (lineChartProperties.getShapes()[n] != null) {
                            graphics2D.translate((double)((Line2D.Float)shape).x1 - object[n], (double)((Line2D.Float)shape).y1 - dArray[n]);
                            graphics2D.setPaint(iAxisChartDataSet.getPaint(n));
                            graphics2D.fill(lineChartProperties.getShapes()[n]);
                            graphics2D.setTransform(affineTransform);
                        }
                        ((Line2D.Float)shape).x1 = ((Line2D.Float)shape).x2;
                        ((Line2D.Float)shape).y1 = ((Line2D.Float)shape).y2;
                    }
                } else {
                    if (!Float.isNaN(fArray[n][n4 - 1]) && lineChartProperties.getShapes()[n] != null) {
                        graphics2D.translate((double)((Line2D.Float)shape).x1 - object[n], (double)((Line2D.Float)shape).y1 - dArray[n]);
                        graphics2D.setPaint(iAxisChartDataSet.getPaint(n));
                        graphics2D.fill(lineChartProperties.getShapes()[n]);
                        graphics2D.setTransform(affineTransform);
                    }
                    ((Line2D.Float)shape).x2 += axisChart.getXAxis().getScalePixelWidth();
                    ((Line2D.Float)shape).x1 = ((Line2D.Float)shape).x2;
                }
                ++n4;
            }
            if (!Float.isNaN(fArray[n][fArray[n].length - 1]) && lineChartProperties.getShapes()[n] != null) {
                graphics2D.translate((double)((Line2D.Float)shape).x2 - object[n], (double)((Line2D.Float)shape).y2 - dArray[n]);
                graphics2D.setPaint(iAxisChartDataSet.getPaint(n));
                graphics2D.fill(lineChartProperties.getShapes()[n]);
                graphics2D.setTransform(affineTransform);
            }
            ++n;
        }
    }
}

