/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import com.helger.css.handler.ICSSParseExceptionCallback;
import com.helger.css.parser.ParseException;
import com.helger.css.reader.errorhandler.LoggingCSSParseErrorHandler;
import java.net.URL;
import java.util.Objects;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSSParseExceptionCallback
implements ICSSParseExceptionCallback {
    private static final long serialVersionUID = -4277276398858139449L;
    private static final Logger LOG = LoggerFactory.getLogger(CSSParseExceptionCallback.class);
    private static final boolean IGNORE_UNRECOVERABLE_PARSING_ERROR = JMeterUtils.getPropDefault((String)"httpsampler.ignore_failed_embedded_resource", (boolean)false);
    private final URL baseUrl;

    public CSSParseExceptionCallback(URL baseUrl) {
        this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl must not be null");
    }

    @Deprecated
    public CSSParseExceptionCallback() {
        this.baseUrl = null;
        LOG.warn("Constructor only intended for use in testing");
    }

    public void onException(ParseException ex) {
        String message = "Failed to parse CSS: " + this.baseUrl + ", " + LoggingCSSParseErrorHandler.createLoggingStringParseError((ParseException)ex);
        if (!IGNORE_UNRECOVERABLE_PARSING_ERROR) {
            throw new IllegalArgumentException("Unrecoverable error met during parsing, you can ignore such errors by setting property:'httpsampler.ignore_failed_embedded_resource' to true, message:" + message);
        }
        LOG.warn(message);
    }
}

