/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.util.ArrayList;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.Element;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.Text;
import jodd.util.StringUtil;

public class HtmlFosterRules {
    public static final String[] FOSTER_TABLE_ELEMENTS = new String[]{"table", "tbody", "tfoot", "thead", "tr"};
    public static final String[] TABLE_ELEMENTS = new String[]{"table", "tbody", "tfoot", "thead", "th", "tr", "td", "caption", "colgroup", "col"};
    protected ArrayList<Element> lastTables = new ArrayList();
    protected ArrayList<Element> fosterElements = new ArrayList();
    protected ArrayList<Text> fosterTexts = new ArrayList();

    protected boolean isOneOfTableElements(Element element) {
        String elementName = element.getNodeName().toLowerCase();
        return StringUtil.equalsOne((String)elementName, (String[])TABLE_ELEMENTS) != -1;
    }

    protected boolean isTableElement(Node node) {
        if (node.getNodeType() != Node.NodeType.ELEMENT) {
            return false;
        }
        String elementName = node.getNodeName().toLowerCase();
        return elementName.equals("table");
    }

    protected boolean isParentNodeOneOfFosterTableElements(Node parentNode) {
        if (parentNode == null) {
            return false;
        }
        if (parentNode.getNodeName() == null) {
            return false;
        }
        String nodeName = parentNode.getNodeName().toLowerCase();
        return StringUtil.equalsOne((String)nodeName, (String[])FOSTER_TABLE_ELEMENTS) != -1;
    }

    protected Element findLastTable(Node node) {
        String tableNodeName;
        Node tableNode;
        for (tableNode = node; !(tableNode == null || tableNode.getNodeType() == Node.NodeType.ELEMENT && (tableNodeName = tableNode.getNodeName().toLowerCase()).equals("table")); tableNode = tableNode.getParentNode()) {
        }
        return (Element)tableNode;
    }

    public void fixFosterElements(Document document) {
        this.findFosterNodes(document);
        this.fixElements();
        this.fixText();
    }

    protected boolean findFosterNodes(Node node) {
        int size;
        String value;
        boolean isTable = false;
        if (!this.lastTables.isEmpty() && node.getNodeType() == Node.NodeType.TEXT && !StringUtil.isBlank((CharSequence)(value = node.getNodeValue())) && this.isParentNodeOneOfFosterTableElements(node.getParentNode())) {
            this.fosterTexts.add((Text)node);
        }
        if (node.getNodeType() == Node.NodeType.ELEMENT) {
            Node parentNode;
            Element element = (Element)node;
            isTable = this.isTableElement(node);
            if (isTable) {
                this.lastTables.add(element);
            } else if (!this.lastTables.isEmpty() && this.isParentNodeOneOfFosterTableElements(parentNode = node.getParentNode()) && !this.isOneOfTableElements(element)) {
                String inputType;
                String elementNodeName = element.getNodeName().toLowerCase();
                if (elementNodeName.equals("form")) {
                    if (element.getChildNodesCount() > 0) {
                        Node[] formChildNodes = element.getChildNodes();
                        parentNode.insertAfter(formChildNodes, (Node)element);
                        return false;
                    }
                    return true;
                }
                if (elementNodeName.equals("input") && (inputType = element.getAttribute("type")).equals("hidden")) {
                    return true;
                }
                this.fosterElements.add(element);
            }
        }
        block0: while (true) {
            int childs = node.getChildNodesCount();
            for (int i = 0; i < childs; ++i) {
                Node childNode = node.getChild(i);
                boolean done = this.findFosterNodes(childNode);
                if (!done) continue block0;
            }
            break;
        }
        if (isTable && (size = this.lastTables.size()) > 0) {
            this.lastTables.remove(size - 1);
        }
        return true;
    }

    protected void fixElements() {
        for (Element fosterElement : this.fosterElements) {
            Node[] fosterChilds;
            Element lastTable = this.findLastTable(fosterElement);
            Node fosterElementParent = fosterElement.getParentNode();
            for (Node fosterChild : fosterChilds = fosterElement.getChildNodes()) {
                if (fosterChild.getNodeType() != Node.NodeType.ELEMENT || !this.isOneOfTableElements((Element)fosterChild)) continue;
                fosterChild.detachFromParent();
                fosterElementParent.insertBefore(fosterChild, (Node)fosterElement);
            }
            fosterElement.detachFromParent();
            lastTable.getParentNode().insertBefore(fosterElement, (Node)lastTable);
        }
    }

    protected void fixText() {
        for (Text fosterText : this.fosterTexts) {
            Element lastTable = this.findLastTable(fosterText);
            fosterText.detachFromParent();
            Node tablesPreviousNode = lastTable.getPreviousSibling();
            if (tablesPreviousNode.getNodeType() == Node.NodeType.TEXT) {
                Text textNode = (Text)tablesPreviousNode;
                String text = textNode.getNodeValue();
                textNode.setNodeValue(text + fosterText.getNodeValue());
                continue;
            }
            lastTable.getParentNode().insertBefore(fosterText, (Node)lastTable);
        }
    }
}

