/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.tcp.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.apache.jmeter.config.gui.LoginConfigGui;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.tcp.config.gui.TCPConfigGui;
import org.apache.jmeter.protocol.tcp.sampler.TCPSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="tcp_sample_title")
public class TCPSamplerGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 240L;
    private LoginConfigGui loginPanel;
    private TCPConfigGui tcpDefaultPanel;

    public TCPSamplerGui() {
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.loginPanel.configure(element);
        this.tcpDefaultPanel.configure(element);
    }

    public TestElement createTestElement() {
        TCPSampler sampler = new TCPSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement sampler) {
        sampler.clear();
        sampler.addTestElement(this.tcpDefaultPanel.createTestElement());
        sampler.addTestElement(this.loginPanel.createTestElement());
        super.configureTestElement(sampler);
    }

    public void clearGui() {
        super.clearGui();
        this.tcpDefaultPanel.clearGui();
        this.loginPanel.clearGui();
    }

    public String getLabelResource() {
        return "tcp_sample_title";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        VerticalPanel mainPanel = new VerticalPanel();
        this.tcpDefaultPanel = new TCPConfigGui(false);
        mainPanel.add((Component)((Object)this.tcpDefaultPanel));
        this.loginPanel = new LoginConfigGui(false);
        this.loginPanel.setBorder((Border)BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"login_config")));
        mainPanel.add((Component)this.loginPanel);
        this.add((Component)mainPanel, "Center");
    }
}

