/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.mongodb.sampler;

import com.mongodb.DB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoScriptRunner {
    private static final Logger log = LoggerFactory.getLogger(MongoScriptRunner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(DB db, String script) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("database: " + db.getName() + ", script: " + script);
        }
        db.requestStart();
        try {
            db.requestEnsureConnection();
            Object result = db.eval(script, new Object[0]);
            if (log.isDebugEnabled()) {
                log.debug("Result : " + result);
            }
            Object object = result;
            return object;
        }
        finally {
            db.requestDone();
        }
    }
}

