/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.builder.VarBinding;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.LinePattern;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.LinesContentSpecification;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.data.ConstantField;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.data.DataFrameField;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.data.MappingField;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.data.ValueSource;
import org.jetbrains.letsPlot.core.spec.Option;
import org.jetbrains.letsPlot.core.spec.OptionsSelectorKt;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0003\u000f\u0010\u0011BI\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0016\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eR\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/LineSpecConfigParser;", "Lorg/jetbrains/letsPlot/core/spec/config/OptionsAccessor;", "opts", "", "", "", "constantsMap", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "groupingVarName", "varBindings", "", "Lorg/jetbrains/letsPlot/core/plot/builder/VarBinding;", "(Ljava/util/Map;Ljava/util/Map;Ljava/lang/String;Ljava/util/List;)V", "create", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/LinesContentSpecification;", "Companion", "Field", "LineSpecConfigParserHelper", "plot-stem"})
public class LineSpecConfigParser
extends OptionsAccessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Aes<?>, Object> constantsMap;
    @Nullable
    private final String groupingVarName;
    @NotNull
    private final List<VarBinding> varBindings;
    @NotNull
    private static final String AES_NAME_PREFIX = "^";
    @NotNull
    private static final String VARIABLE_NAME_PREFIX = "@";
    @NotNull
    private static final String LABEL_SEPARATOR = "|";
    @NotNull
    private static final Regex SOURCE_RE_PATTERN = new Regex("(?:\\\\\\^|\\\\@)|(\\^\\w+)|@(([\\w^@]+)|(\\{([\\s\\S]*?)\\})|\\.{2}\\w+\\.{2})");

    public LineSpecConfigParser(@NotNull Map<String, ? extends Object> opts, @NotNull Map<Aes<?>, ? extends Object> constantsMap, @Nullable String groupingVarName, @NotNull List<VarBinding> varBindings) {
        Intrinsics.checkNotNullParameter(opts, (String)"opts");
        Intrinsics.checkNotNullParameter(constantsMap, (String)"constantsMap");
        Intrinsics.checkNotNullParameter(varBindings, (String)"varBindings");
        super(opts, null, 2, null);
        this.constantsMap = constantsMap;
        this.groupingVarName = groupingVarName;
        this.varBindings = varBindings;
    }

    @NotNull
    public final LinesContentSpecification create() {
        return new LineSpecConfigParserHelper(this.has("lines") ? this.getStringList("lines") : null, this.getList("formats"), this.getStringList("variables"), this.getString("title")).parse$plot_stem();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/LineSpecConfigParser$Companion;", "", "()V", "AES_NAME_PREFIX", "", "LABEL_SEPARATOR", "SOURCE_RE_PATTERN", "Lkotlin/text/Regex;", "VARIABLE_NAME_PREFIX", "plot-stem"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/LineSpecConfigParser$Field;", "", "name", "", "isAes", "", "(Ljava/lang/String;Z)V", "()Z", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "plot-stem"})
    private static final class Field {
        @NotNull
        private final String name;
        private final boolean isAes;

        public Field(@NotNull String name, boolean isAes) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.isAes = isAes;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean isAes() {
            return this.isAes;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final boolean component2() {
            return this.isAes;
        }

        @NotNull
        public final Field copy(@NotNull String name, boolean isAes) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Field(name, isAes);
        }

        public static /* synthetic */ Field copy$default(Field field, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = field.name;
            }
            if ((n & 2) != 0) {
                bl = field.isAes;
            }
            return field.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "Field(name=" + this.name + ", isAes=" + this.isAes + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            int n = this.isAes ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Field)) {
                return false;
            }
            Field field = (Field)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)field.name)) {
                return false;
            }
            return this.isAes == field.isAes;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0080\u0004\u0018\u00002\u00020\u0001B9\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J$\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J:\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u001b2\u0006\u0010\u0019\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\rH\u0002J\r\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0010\u0010#\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0003H\u0002J \u0010$\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\u001b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0002J\u0010\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0004H\u0002R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/LineSpecConfigParser$LineSpecConfigParserHelper;", "", "lines", "", "", "formats", "variables", "titleLine", "(Lorg/jetbrains/letsPlot/core/spec/config/LineSpecConfigParser;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "myLinesForVariableList", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/LinePattern;", "myValueSources", "", "Lorg/jetbrains/letsPlot/core/spec/config/LineSpecConfigParser$Field;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/data/ValueSource;", "aesField", "aesName", "createValueSource", "fieldName", "isAes", "", "format", "detachLabel", "line", "detachVariableName", "field", "getAesValueSourceForVariable", "", "valueSources", "getValueSource", "fieldString", "parse", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/LinesContentSpecification;", "parse$plot_stem", "parseLine", "parseLines", "prepareFormats", "varField", "varName", "plot-stem"})
    @SourceDebugExtension(value={"SMAP\nLineSpecConfigParseHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineSpecConfigParseHelper.kt\norg/jetbrains/letsPlot/core/spec/config/LineSpecConfigParser$LineSpecConfigParserHelper\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n453#2:243\n403#2:244\n526#2:287\n511#2,6:288\n1238#3,4:245\n1549#3:251\n1620#3,3:252\n1549#3:260\n1620#3,3:261\n1855#3:264\n766#3:265\n857#3,2:266\n766#3:268\n857#3,2:269\n1855#3,2:271\n1856#3:273\n766#3:274\n857#3,2:275\n1549#3:277\n1620#3,3:278\n1179#3,2:281\n1253#3,4:283\n2333#3,14:294\n215#4,2:249\n125#4:256\n152#4,3:257\n1#5:255\n*S KotlinDebug\n*F\n+ 1 LineSpecConfigParseHelper.kt\norg/jetbrains/letsPlot/core/spec/config/LineSpecConfigParser$LineSpecConfigParserHelper\n*L\n47#1:243\n47#1:244\n188#1:287\n188#1:288,6\n47#1:245,4\n59#1:251\n59#1:252,3\n71#1:260\n71#1:261,3\n123#1:264\n134#1:265\n134#1:266,2\n135#1:268\n135#1:269,2\n143#1:271,2\n123#1:273\n166#1:274\n166#1:275,2\n167#1:277\n167#1:278,3\n167#1:281,2\n167#1:283,4\n192#1:294,14\n52#1:249,2\n67#1:256\n67#1:257,3\n*E\n"})
    public final class LineSpecConfigParserHelper {
        @Nullable
        private final List<String> lines;
        @Nullable
        private final String titleLine;
        @NotNull
        private final Map<Field, ValueSource> myValueSources;
        @NotNull
        private final List<LinePattern> myLinesForVariableList;

        /*
         * WARNING - void declaration
         */
        public LineSpecConfigParserHelper(@NotNull List<String> lines, @NotNull List<?> formats, @Nullable List<String> variables, String titleLine) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapValuesTo$iv$iv;
            void specifiedFormats;
            Intrinsics.checkNotNullParameter(formats, (String)"formats");
            Intrinsics.checkNotNullParameter(variables, (String)"variables");
            this.lines = lines;
            this.titleLine = titleLine;
            Map<Field, String> map2 = this.prepareFormats(formats);
            LineSpecConfigParserHelper lineSpecConfigParserHelper = this;
            boolean $i$a$-let-LineSpecConfigParser$LineSpecConfigParserHelper$myValueSources$232 = false;
            void $this$mapValues$iv = specifiedFormats;
            boolean $i$f$mapValues = false;
            void var11_15 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean bl = false;
            Object $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            Iterator iterator = $this$associateByTo$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it$iv$iv;
                Object element$iv$iv$iv = iterator.next();
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl22 = false;
                Field field = (Field)entry2.getKey();
                String format = (String)entry2.getValue();
                ValueSource valueSource = this.createValueSource(field.getName(), field.isAes(), format);
                map4.put(k, valueSource);
            }
            Map valueSources = destination$iv$iv;
            Map aesValueSources = new LinkedHashMap();
            void $this$forEach$iv = specifiedFormats;
            boolean $i$f$forEach = false;
            for (Map.Entry entry : $this$forEach$iv.entrySet()) {
                $this$associateByTo$iv$iv$iv = entry;
                boolean bl3 = false;
                Field field = (Field)$this$associateByTo$iv$iv$iv.getKey();
                String format = (String)$this$associateByTo$iv$iv$iv.getValue();
                aesValueSources.putAll(this.getAesValueSourceForVariable(field, format, valueSources));
            }
            lineSpecConfigParserHelper.myValueSources = MapsKt.toMutableMap((Map)MapsKt.plus((Map)valueSources, (Map)aesValueSources));
            Iterable iterable = variables;
            lineSpecConfigParserHelper = this;
            boolean $i$f$map = false;
            void $i$a$-let-LineSpecConfigParser$LineSpecConfigParserHelper$myValueSources$232 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                ValueSource valueSource = this.getValueSource(this.varField(string));
                collection.add(LinePattern.Companion.defaultLineForValueSource(valueSource));
            }
            lineSpecConfigParserHelper.myLinesForVariableList = (List)destination$iv$iv2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final LinesContentSpecification parse$plot_stem() {
            void $this$mapTo$iv$iv;
            LinePattern linePattern;
            Object p0;
            List<LinePattern> allLines = this.parseLines();
            String string = this.titleLine;
            if (string != null) {
                p0 = string;
                boolean bl = false;
                linePattern = this.parseLine((String)p0);
            } else {
                linePattern = null;
            }
            LinePattern title = linePattern;
            Map<Field, ValueSource> $this$map$iv = this.myValueSources;
            boolean $i$f$map = false;
            p0 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((ValueSource)it.getValue());
            }
            LinePattern linePattern2 = title;
            List<LinePattern> list2 = allLines;
            List list3 = (List)destination$iv$iv;
            return new LinesContentSpecification(list3, list2, linePattern2);
        }

        /*
         * WARNING - void declaration
         */
        private final List<LinePattern> parseLines() {
            List list2;
            List<String> list3 = this.lines;
            if (list3 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list3;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.parseLine((String)p0));
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = null;
            }
            List lines = list2;
            return lines != null ? CollectionsKt.plus((Collection)this.myLinesForVariableList, (Iterable)lines) : (!((Collection)this.myLinesForVariableList).isEmpty() ? this.myLinesForVariableList : null);
        }

        private final LinePattern parseLine(String line) {
            String label = this.detachLabel(line);
            String valueString = StringsKt.substringAfter$default((String)line, (String)LineSpecConfigParser.LABEL_SEPARATOR, null, (int)2, null);
            List fieldsInPattern = new ArrayList();
            String pattern2 = SOURCE_RE_PATTERN.replace((CharSequence)valueString, (Function1)new Function1<MatchResult, CharSequence>((List<ValueSource>)fieldsInPattern, this){
                final /* synthetic */ List<ValueSource> $fieldsInPattern;
                final /* synthetic */ LineSpecConfigParserHelper this$0;
                {
                    this.$fieldsInPattern = $fieldsInPattern;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull MatchResult it) {
                    CharSequence charSequence;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (Intrinsics.areEqual((Object)it.getValue(), (Object)"\\^") || Intrinsics.areEqual((Object)it.getValue(), (Object)"\\@")) {
                        charSequence = StringsKt.removePrefix((String)it.getValue(), (CharSequence)"\\");
                    } else {
                        ((Collection)this.$fieldsInPattern).add(LineSpecConfigParserHelper.access$getValueSource(this.this$0, it.getValue()));
                        charSequence = StringFormat.Companion.valueInLinePattern();
                    }
                    return charSequence;
                }
            });
            return new LinePattern(label, pattern2, fieldsInPattern);
        }

        private final ValueSource createValueSource(String fieldName, boolean isAes, String format) {
            ValueSource valueSource;
            if (isAes && Intrinsics.areEqual((Object)fieldName, (Object)"group")) {
                if (LineSpecConfigParser.this.groupingVarName == null) {
                    boolean $i$a$-requireNotNull-LineSpecConfigParser$LineSpecConfigParserHelper$createValueSource$22 = false;
                    String $i$a$-requireNotNull-LineSpecConfigParser$LineSpecConfigParserHelper$createValueSource$22 = "Variable name for 'group' is not specified";
                    throw new IllegalArgumentException($i$a$-requireNotNull-LineSpecConfigParser$LineSpecConfigParserHelper$createValueSource$22.toString());
                }
                valueSource = (ValueSource)new DataFrameField(LineSpecConfigParser.this.groupingVarName, format);
            } else if (isAes) {
                Aes<?> aes = Option.Mapping.INSTANCE.toAes(fieldName);
                Object constant = LineSpecConfigParser.this.constantsMap.get(aes);
                valueSource = constant == null ? (ValueSource)new MappingField(aes, false, false, format, null, 22, null) : (ValueSource)new ConstantField(aes, constant, format, null, 8, null);
            } else {
                valueSource = (ValueSource)new DataFrameField(fieldName, format);
            }
            return valueSource;
        }

        static /* synthetic */ ValueSource createValueSource$default(LineSpecConfigParserHelper lineSpecConfigParserHelper, String string, boolean bl, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return lineSpecConfigParserHelper.createValueSource(string, bl, string2);
        }

        /*
         * Unable to fully structure code
         */
        private final Map<Field, String> prepareFormats(List<?> formats) {
            allFormats = new LinkedHashMap<K, V>();
            $this$forEach$iv = formats;
            $i$f$forEach = false;
            var5_5 = $this$forEach$iv.iterator();
            while (var5_5.hasNext()) {
                lineFormat = element$iv = var5_5.next();
                $i$a$-forEach-LineSpecConfigParser$LineSpecConfigParserHelper$prepareFormats$1 = false;
                if (!(lineFormat instanceof Map)) {
                    $i$a$-require-LineSpecConfigParser$LineSpecConfigParserHelper$prepareFormats$1$1 = false;
                    $i$a$-require-LineSpecConfigParser$LineSpecConfigParserHelper$prepareFormats$1$1 = "Wrong 'format' arguments";
                    throw new IllegalArgumentException($i$a$-require-LineSpecConfigParser$LineSpecConfigParserHelper$prepareFormats$1$1.toString());
                }
                var10_14 = new String[]{"field"};
                if (!OptionsSelectorKt.has((Map)lineFormat, var10_14)) ** GOTO lbl-1000
                var10_14 = new String[]{"format"};
                if (OptionsSelectorKt.has((Map)lineFormat, var10_14)) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (!v0) {
                    $i$a$-require-LineSpecConfigParser$LineSpecConfigParserHelper$prepareFormats$1$2 = false;
                    $i$a$-require-LineSpecConfigParser$LineSpecConfigParserHelper$prepareFormats$1$2 = "Invalid 'format' arguments: 'field' and 'format' are expected";
                    throw new IllegalArgumentException($i$a$-require-LineSpecConfigParser$LineSpecConfigParserHelper$prepareFormats$1$2.toString());
                }
                v1 = ((Map)lineFormat).get("field");
                Intrinsics.checkNotNull(v1, (String)"null cannot be cast to non-null type kotlin.String");
                field = (String)v1;
                v2 = ((Map)lineFormat).get("format");
                Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.String");
                format = (String)v2;
                if (StringsKt.startsWith$default((String)field, (String)"^", (boolean)false, (int)2, null)) {
                    var11_15 = StringsKt.removePrefix((String)field, (CharSequence)"^");
                    if (Intrinsics.areEqual((Object)var11_15, (Object)"X")) {
                        var12_17 = Aes.Companion.values();
                        var13_18 = Aes.Companion;
                        $i$f$filter = false;
                        var15_21 = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            p0 = (Aes)element$iv$iv;
                            $i$a$-filter-LineSpecConfigParser$LineSpecConfigParserHelper$prepareFormats$1$positionals$1 = false;
                            if (!var13_18.isPositionalX(p0)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        v3 = (List)destination$iv$iv;
                    } else if (Intrinsics.areEqual((Object)var11_15, (Object)"Y")) {
                        $this$filter$iv = Aes.Companion.values();
                        var13_18 = Aes.Companion;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            p0 = (Aes)element$iv$iv;
                            $i$a$-filter-LineSpecConfigParser$LineSpecConfigParserHelper$prepareFormats$1$positionals$2 = false;
                            if (!var13_18.isPositionalY(p0)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        v3 = (List)destination$iv$iv;
                    } else {
                        aesField = this.aesField(StringsKt.removePrefix((String)field, (CharSequence)"^"));
                        allFormats.put(aesField, format);
                        v3 = CollectionsKt.emptyList();
                    }
                    positionals = v3;
                    $this$forEach$iv = positionals;
                    $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        aes = (Aes)element$iv;
                        $i$a$-forEach-LineSpecConfigParser$LineSpecConfigParserHelper$prepareFormats$1$3 = false;
                        aesField = this.aesField(aes.getName());
                        if (allFormats.containsKey(aesField)) continue;
                        allFormats.put(aesField, format);
                    }
                    continue;
                }
                varField = this.varField(this.detachVariableName(field));
                allFormats.put(varField, format);
            }
            return allFormats;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<Field, ValueSource> getAesValueSourceForVariable(Field field, String format, Map<Field, ? extends ValueSource> valueSources) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            VarBinding it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            if (field.isAes()) {
                return MapsKt.emptyMap();
            }
            Iterable iterable = LineSpecConfigParser.this.varBindings;
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (VarBinding)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getVariable().getName(), (Object)field.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                it = (VarBinding)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getAes());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Pair pair;
                Map map2 = destination$iv$iv2;
                Aes aes = (Aes)element$iv$iv;
                boolean bl = false;
                Field aesField = this.aesField(aes.getName());
                if (valueSources.containsKey(aesField)) {
                    ValueSource valueSource = valueSources.get(aesField);
                    Intrinsics.checkNotNull((Object)valueSource);
                    pair = TuplesKt.to((Object)aesField, (Object)valueSource);
                } else {
                    pair = TuplesKt.to((Object)aesField, (Object)this.createValueSource(aes.getName(), true, format));
                }
                Pair pair2 = pair;
                map2.put(pair2.getFirst(), pair2.getSecond());
            }
            return destination$iv$iv2;
        }

        /*
         * WARNING - void declaration
         */
        private final ValueSource getValueSource(Field field) {
            if (!this.myValueSources.containsKey(field)) {
                Object v1;
                void $this$minByOrNull$iv;
                void $this$filterTo$iv$iv;
                Pair $this$filter$iv;
                Pair aesValueSources;
                Pair pair = aesValueSources = this.getAesValueSourceForVariable(field, null, this.myValueSources);
                boolean $i$f$filter = false;
                void var8_7 = $this$filter$iv;
                Pair destination$iv$iv = (Pair)new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = iterator.next();
                    boolean bl = false;
                    if (!this.myValueSources.containsKey(it.getKey())) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Pair it = $this$filter$iv = destination$iv$iv;
                boolean bl = false;
                Object object = !it.isEmpty() ? $this$filter$iv : null;
                if (object == null) {
                    object = aesValueSources;
                }
                Iterable iterable = MapsKt.toList((Map)object);
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v1 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v1 = minElem$iv;
                    } else {
                        destination$iv$iv = (Pair)minElem$iv;
                        boolean bl2 = false;
                        Field aesField = (Field)destination$iv$iv.component1();
                        Comparable minValue$iv = (Comparable)((Object)aesField.getName());
                        do {
                            Object e$iv = iterator$iv.next();
                            aesField = (Pair)e$iv;
                            $i$a$-minByOrNull-LineSpecConfigParser$LineSpecConfigParserHelper$getValueSource$specifiedBefore$3 = false;
                            Field aesField2 = (Field)aesField.component1();
                            Comparable v$iv = (Comparable)((Object)aesField2.getName());
                            if (minValue$iv.compareTo(v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v1 = minElem$iv;
                    }
                }
                Pair pair2 = v1;
                ValueSource specifiedBefore = pair2 != null ? (ValueSource)pair2.getSecond() : null;
                ValueSource valueSource = specifiedBefore;
                if (valueSource == null) {
                    valueSource = LineSpecConfigParserHelper.createValueSource$default(this, field.getName(), field.isAes(), null, 4, null);
                }
                this.myValueSources.put(field, valueSource);
            }
            ValueSource valueSource = this.myValueSources.get(field);
            Intrinsics.checkNotNull((Object)valueSource);
            return valueSource;
        }

        private final ValueSource getValueSource(String fieldString) {
            Field field;
            if (StringsKt.startsWith$default((String)fieldString, (String)LineSpecConfigParser.AES_NAME_PREFIX, (boolean)false, (int)2, null)) {
                field = this.aesField(StringsKt.removePrefix((String)fieldString, (CharSequence)LineSpecConfigParser.AES_NAME_PREFIX));
            } else if (StringsKt.startsWith$default((String)fieldString, (String)LineSpecConfigParser.VARIABLE_NAME_PREFIX, (boolean)false, (int)2, null)) {
                field = this.varField(this.detachVariableName(fieldString));
            } else {
                throw new IllegalStateException(("Unknown type of the field with name = \"" + fieldString + '\"').toString());
            }
            Field field2 = field;
            return this.getValueSource(field2);
        }

        private final String detachVariableName(String field) {
            return StringsKt.removeSurrounding((String)StringsKt.removePrefix((String)field, (CharSequence)LineSpecConfigParser.VARIABLE_NAME_PREFIX), (CharSequence)"{", (CharSequence)"}");
        }

        private final String detachLabel(String line) {
            return StringsKt.contains$default((CharSequence)line, (CharSequence)LineSpecConfigParser.LABEL_SEPARATOR, (boolean)false, (int)2, null) ? ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)line, (String)LineSpecConfigParser.LABEL_SEPARATOR, null, (int)2, null))).toString() : null;
        }

        private final Field aesField(String aesName) {
            return new Field(aesName, true);
        }

        private final Field varField(String varName) {
            return new Field(varName, false);
        }

        public static final /* synthetic */ ValueSource access$getValueSource(LineSpecConfigParserHelper $this, String fieldString) {
            return $this.getValueSource(fieldString);
        }
    }
}

