/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.geometry;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\u0000J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0000J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0000J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0000J\u0006\u0010\u001b\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\""}, d2={"Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "", "x", "", "y", "(II)V", "getX", "()I", "getY", "abs", "add", "v", "div", "i", "dotProduct", "equals", "", "other", "hashCode", "isParallel", "to", "length", "", "max", "min", "mul", "negate", "orthogonal", "sub", "toDoubleVector", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "toString", "", "Companion", "commons"})
public final class Vector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x;
    private final int y;
    @NotNull
    private static final Vector ZERO = new Vector(0, 0);

    public Vector(int x2, int y2) {
        this.x = x2;
        this.y = y2;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    @NotNull
    public final Vector add(@NotNull Vector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Vector(this.x + v.x, this.y + v.y);
    }

    @NotNull
    public final Vector sub(@NotNull Vector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.add(v.negate());
    }

    @NotNull
    public final Vector negate() {
        return new Vector(-this.x, -this.y);
    }

    @NotNull
    public final Vector max(@NotNull Vector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Vector(Math.max(this.x, v.x), Math.max(this.y, v.y));
    }

    @NotNull
    public final Vector min(@NotNull Vector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Vector(Math.min(this.x, v.x), Math.min(this.y, v.y));
    }

    @NotNull
    public final Vector mul(int i) {
        return new Vector(this.x * i, this.y * i);
    }

    @NotNull
    public final Vector div(int i) {
        return new Vector(this.x / i, this.y / i);
    }

    public final int dotProduct(@NotNull Vector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.x * v.x + this.y * v.y;
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @NotNull
    public final DoubleVector toDoubleVector() {
        return new DoubleVector(this.x, this.y);
    }

    @NotNull
    public final Vector abs() {
        return new Vector(Math.abs(this.x), Math.abs(this.y));
    }

    public final boolean isParallel(@NotNull Vector to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return this.x * to.y - to.x * this.y == 0;
    }

    @NotNull
    public final Vector orthogonal() {
        return new Vector(-this.y, this.x);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Vector)) {
            return false;
        }
        Vector otherVector = (Vector)other;
        return this.x == otherVector.x && this.y == otherVector.y;
    }

    public int hashCode() {
        return this.x * 31 + this.y;
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.x + ", " + this.y + ')';
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/commons/geometry/Vector$Companion;", "", "()V", "ZERO", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "getZERO", "()Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "commons"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector getZERO() {
            return ZERO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

