/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.ZoneId;
import java.util.Locale;
import java.util.Optional;
import org.exparity.hamcrest.date.core.TemporalConverter;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.exparity.hamcrest.date.core.TemporalProvider;
import org.exparity.hamcrest.date.core.types.DayOfMonth;
import org.hamcrest.Description;

public class IsDayOfMonth<T>
extends TemporalMatcher<T> {
    private final TemporalConverter<T, DayOfMonth> converter;
    private final TemporalProvider<DayOfMonth> expected;
    private final Locale locale;
    private final Optional<ZoneId> zone;

    public IsDayOfMonth(TemporalConverter<T, DayOfMonth> converter, TemporalProvider<DayOfMonth> expected, Optional<ZoneId> zone, Locale locale) {
        this.expected = expected;
        this.converter = converter;
        this.locale = locale;
        this.zone = zone;
    }

    public IsDayOfMonth(TemporalConverter<T, DayOfMonth> converter, TemporalProvider<DayOfMonth> expected) {
        this(converter, expected, Optional.empty(), Locale.getDefault(Locale.Category.FORMAT));
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        DayOfMonth actualValue;
        DayOfMonth expectedValue = this.expected.apply(this.zone);
        if (!expectedValue.equals(actualValue = this.converter.apply(actual, this.zone))) {
            mismatchDescription.appendText("the date has the day of month " + actualValue);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date has the day of month " + this.expected.apply(this.zone));
    }

    @Override
    public TemporalMatcher<T> atZone(ZoneId zone) {
        return new IsDayOfMonth<T>(this.converter, this.expected, Optional.of(zone), this.locale);
    }

    @Override
    public TemporalMatcher<T> atLocale(Locale locale) {
        return new IsDayOfMonth<T>(this.converter, this.expected, this.zone, locale);
    }
}

