/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.ValueRange;
import java.util.Locale;
import java.util.Optional;
import org.exparity.hamcrest.date.core.TemporalConverter;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.hamcrest.Description;

public class IsLastDayOfMonth<T>
extends TemporalMatcher<T> {
    private final TemporalConverter<T, ? extends TemporalAccessor> converter;
    private final Locale locale;
    private final Optional<ZoneId> zone;

    public IsLastDayOfMonth(TemporalConverter<T, ? extends TemporalAccessor> converter, Optional<ZoneId> zone, Locale locale) {
        this.converter = converter;
        this.locale = locale;
        this.zone = zone;
    }

    public IsLastDayOfMonth(TemporalConverter<T, ? extends TemporalAccessor> converter) {
        this(converter, Optional.empty(), Locale.getDefault(Locale.Category.FORMAT));
    }

    protected boolean matchesSafely(T actual, Description mismatchDesc) {
        TemporalAccessor actualTemporal = this.converter.apply(actual, this.zone);
        ValueRange actualRange = ChronoField.DAY_OF_MONTH.rangeRefinedBy(actualTemporal);
        long actualValue = ChronoField.DAY_OF_MONTH.getFrom(actualTemporal);
        long expectedValue = actualRange.getMaximum();
        if (expectedValue != actualValue) {
            mismatchDesc.appendText("date is the " + actualValue + " day of the month");
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date is the last day of the month");
    }

    @Override
    public TemporalMatcher<T> atZone(ZoneId zone) {
        return new IsLastDayOfMonth<T>(this.converter, Optional.of(zone), this.locale);
    }

    @Override
    public TemporalMatcher<T> atLocale(Locale locale) {
        return new IsLastDayOfMonth<T>(this.converter, this.zone, locale);
    }
}

