/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.Year;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Optional;
import org.exparity.hamcrest.date.core.TemporalConverter;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.hamcrest.Description;

public class IsLeapYear<T>
extends TemporalMatcher<T> {
    private final TemporalConverter<T, Year> converter;
    private final Locale locale;
    private final Optional<ZoneId> zone;

    public IsLeapYear(TemporalConverter<T, Year> converter, Optional<ZoneId> zone, Locale locale) {
        this.converter = converter;
        this.locale = locale;
        this.zone = zone;
    }

    public IsLeapYear(TemporalConverter<T, Year> converter) {
        this(converter, Optional.empty(), Locale.getDefault(Locale.Category.FORMAT));
    }

    protected boolean matchesSafely(T actual, Description mismatchDesc) {
        Year actualValue = this.converter.apply(actual, this.zone);
        if (!actualValue.isLeap()) {
            mismatchDesc.appendText("the year " + actualValue + " is not a leap year");
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("a leap year");
    }

    @Override
    public TemporalMatcher<T> atZone(ZoneId zone) {
        return new IsLeapYear<T>(this.converter, Optional.of(zone), this.locale);
    }

    @Override
    public TemporalMatcher<T> atLocale(Locale locale) {
        return new IsLeapYear<T>(this.converter, this.zone, locale);
    }
}

