/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.function;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;
import org.exparity.hamcrest.date.core.TemporalFunction;
import org.exparity.hamcrest.date.core.types.Interval;

public class DateFunction
implements TemporalFunction<Date> {
    public static final String JAVA_SQL_DATE_UNIT = "java.sql.Date does not support time-based units. Prefer SqlDateMatchers for java.sql.Date appropriate matchers";
    private static final String DATE_TIME_FORMAT = "EEE, dd MMM yyyy hh:mm:ss.SSS a";
    private static final String DATE_FORMAT = "EEE, dd MMM yyyy";

    @Override
    public boolean isAfter(Date expected, Date actual) {
        if (expected instanceof java.sql.Date || actual instanceof java.sql.Date) {
            return this.toLocalDate(expected).isAfter(this.toLocalDate(actual));
        }
        return expected.after(actual);
    }

    @Override
    public boolean isBefore(Date expected, Date actual) {
        if (expected instanceof java.sql.Date || actual instanceof java.sql.Date) {
            return this.toLocalDate(expected).isBefore(this.toLocalDate(actual));
        }
        return expected.before(actual);
    }

    @Override
    public boolean isSame(Date expected, Date actual) {
        if (expected instanceof java.sql.Date || actual instanceof java.sql.Date) {
            return this.toLocalDate(expected).equals(this.toLocalDate(actual));
        }
        return expected.equals(actual);
    }

    @Override
    public Interval interval(Date expected, Date actual, ChronoUnit unit) {
        if (expected instanceof java.sql.Date || actual instanceof java.sql.Date) {
            return Interval.of(this.toLocalDate(expected).until(this.toLocalDate(actual), unit), unit);
        }
        return Interval.of(expected.toInstant().until(actual.toInstant(), unit), unit);
    }

    @Override
    public String describe(Date temporal, Locale locale) {
        if (temporal instanceof java.sql.Date) {
            return new SimpleDateFormat(DATE_FORMAT, locale).format(temporal);
        }
        return new SimpleDateFormat(DATE_TIME_FORMAT, locale).format(temporal);
    }

    private LocalDate toLocalDate(Date expected) {
        if (expected instanceof java.sql.Date) {
            return ((java.sql.Date)expected).toLocalDate();
        }
        return expected.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }
}

