/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import org.apache.jmeter.control.InterleaveControl;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.CheckBoxPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

@TestElementMetadata(labelResource="interleave_control_title")
public class InterleaveControlGui
extends AbstractControllerGui {
    private static final long serialVersionUID = 240L;
    private JCheckBox style;
    private JCheckBox accrossThreads;

    public InterleaveControlGui() {
        this.init();
    }

    public void configure(TestElement el) {
        super.configure(el);
        InterleaveControl controller = (InterleaveControl)el;
        if (controller.getStyle() == 0) {
            this.style.setSelected(true);
        } else {
            this.style.setSelected(false);
        }
        this.accrossThreads.setSelected(controller.getInterleaveAccrossThreads());
    }

    public TestElement createTestElement() {
        InterleaveControl ic = new InterleaveControl();
        this.modifyTestElement((TestElement)ic);
        return ic;
    }

    public void modifyTestElement(TestElement ic) {
        this.configureTestElement(ic);
        InterleaveControl controller = (InterleaveControl)ic;
        if (this.style.isSelected()) {
            controller.setStyle(0);
        } else {
            controller.setStyle(1);
        }
        controller.setInterleaveAccrossThreads(this.accrossThreads.isSelected());
    }

    public void clearGui() {
        super.clearGui();
        this.style.setSelected(false);
        this.accrossThreads.setSelected(false);
    }

    public String getLabelResource() {
        return "interleave_control_title";
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 3, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        this.style = new JCheckBox(JMeterUtils.getResString((String)"ignore_subcontrollers"));
        this.add(CheckBoxPanel.wrap((JCheckBox)this.style));
        this.accrossThreads = new JCheckBox(JMeterUtils.getResString((String)"interleave_accross_threads"));
        this.add(CheckBoxPanel.wrap((JCheckBox)this.accrossThreads));
    }
}

