/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster.loadbalancing;

import java.util.List;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancingStrategy;
import org.neo4j.driver.internal.cluster.loadbalancing.RoundRobinArrayIndex;
import org.neo4j.driver.internal.spi.ConnectionPool;

public class LeastConnectedLoadBalancingStrategy
implements LoadBalancingStrategy {
    private final RoundRobinArrayIndex readersIndex = new RoundRobinArrayIndex();
    private final RoundRobinArrayIndex writersIndex = new RoundRobinArrayIndex();
    private final ConnectionPool connectionPool;
    private final Logger log;

    public LeastConnectedLoadBalancingStrategy(ConnectionPool connectionPool, Logging logging) {
        this.connectionPool = connectionPool;
        this.log = logging.getLog(this.getClass());
    }

    @Override
    public BoltServerAddress selectReader(List<BoltServerAddress> knownReaders) {
        return this.select(knownReaders, this.readersIndex, "reader");
    }

    @Override
    public BoltServerAddress selectWriter(List<BoltServerAddress> knownWriters) {
        return this.select(knownWriters, this.writersIndex, "writer");
    }

    private BoltServerAddress select(List<BoltServerAddress> addresses, RoundRobinArrayIndex addressesIndex, String addressType) {
        int startIndex;
        int size = addresses.size();
        if (size == 0) {
            this.log.trace("Unable to select %s, no known addresses given", addressType);
            return null;
        }
        int index = startIndex = addressesIndex.next(size);
        BoltServerAddress leastConnectedAddress = null;
        int leastActiveConnections = Integer.MAX_VALUE;
        do {
            BoltServerAddress address;
            int activeConnections;
            if ((activeConnections = this.connectionPool.inUseConnections(address = addresses.get(index))) < leastActiveConnections) {
                leastConnectedAddress = address;
                leastActiveConnections = activeConnections;
            }
            if (index == size - 1) {
                index = 0;
                continue;
            }
            ++index;
        } while (index != startIndex);
        this.log.trace("Selected %s with address: '%s' and active connections: %s", addressType, leastConnectedAddress, leastActiveConnections);
        return leastConnectedAddress;
    }
}

