/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.svm;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.JdkAlpnApplicationProtocolNegotiator;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import org.neo4j.driver.internal.svm.Target_io_netty_handler_ssl_JdkDefaultApplicationProtocolNegotiator;

@TargetClass(className="org.neo4j.driver.internal.shaded.io.netty.handler.ssl.JdkSslContext")
final class Target_io_netty_handler_ssl_JdkSslContext {
    Target_io_netty_handler_ssl_JdkSslContext() {
    }

    @Substitute
    static JdkApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig config, boolean isServer) {
        if (config == null) {
            return (JdkApplicationProtocolNegotiator)((Object)Target_io_netty_handler_ssl_JdkDefaultApplicationProtocolNegotiator.INSTANCE);
        }
        switch (config.protocol()) {
            case NONE: {
                return (JdkApplicationProtocolNegotiator)((Object)Target_io_netty_handler_ssl_JdkDefaultApplicationProtocolNegotiator.INSTANCE);
            }
            case ALPN: {
                if (isServer) {
                    ApplicationProtocolConfig.SelectorFailureBehavior behavior = config.selectorFailureBehavior();
                    if (behavior == ApplicationProtocolConfig.SelectorFailureBehavior.FATAL_ALERT) {
                        return new JdkAlpnApplicationProtocolNegotiator(true, config.supportedProtocols());
                    }
                    if (behavior == ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE) {
                        return new JdkAlpnApplicationProtocolNegotiator(false, config.supportedProtocols());
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)config.selectorFailureBehavior()) + " failure behavior");
                }
                switch (config.selectedListenerFailureBehavior()) {
                    case ACCEPT: {
                        return new JdkAlpnApplicationProtocolNegotiator(false, config.supportedProtocols());
                    }
                    case FATAL_ALERT: {
                        return new JdkAlpnApplicationProtocolNegotiator(true, config.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)config.selectedListenerFailureBehavior()) + " failure behavior");
            }
        }
        throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)config.protocol()) + " protocol");
    }
}

