/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.OutputPngStream;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.PngjOutputException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkHelper;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkPredicate;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunksList;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u0007J \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u0007J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u000bJ\u0010\u0010\u0018\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u000bJ\b\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\u0016\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunksListForWrite;", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunksList;", "imfinfo", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "alreadyWrittenKeys", "", "", "", "queuedChunks", "", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk;", "getQueuedById", "", "id", "innerid", "getQueuedById1", "failIfMultiple", "", "getQueuedChunks", "getQueuedEquivalent", "c2", "queue", "c", "removeChunk", "toString", "toStringFull", "writeChunks", "os", "Lorg/jetbrains/letsPlot/util/pngj/OutputPngStream;", "currentGroup", "Companion", "plot-api"})
public final class ChunksListForWrite
extends ChunksList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PngChunk> queuedChunks;
    @NotNull
    private final Map<String, Integer> alreadyWrittenKeys;

    public ChunksListForWrite(@NotNull ImageInfo imfinfo) {
        Intrinsics.checkNotNullParameter((Object)imfinfo, (String)"imfinfo");
        super(imfinfo);
        this.queuedChunks = new ArrayList();
        this.alreadyWrittenKeys = new LinkedHashMap();
    }

    @NotNull
    public final List<PngChunk> getQueuedById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getQueuedById(id, null);
    }

    private final List<PngChunk> getQueuedById(String id, String innerid) {
        return ChunksList.getXById(this.queuedChunks, id, innerid);
    }

    private final PngChunk getQueuedById1(String id, String innerid, boolean failIfMultiple) {
        List<PngChunk> list = this.getQueuedById(id, innerid);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1 && (failIfMultiple || !list.get(0).allowsMultiple())) {
            throw new PngjException("unexpected multiple chunks id=" + id);
        }
        return list.get(list.size() - 1);
    }

    private final PngChunk getQueuedById1(String id, boolean failIfMultiple) {
        return this.getQueuedById1(id, null, failIfMultiple);
    }

    @Nullable
    public final PngChunk getQueuedById1(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getQueuedById1(id, false);
    }

    @NotNull
    public final List<PngChunk> getQueuedEquivalent(@Nullable PngChunk c2) {
        return ChunkHelper.INSTANCE.filterList(this.queuedChunks, new ChunkPredicate(c2){
            final /* synthetic */ PngChunk $c2;
            {
                this.$c2 = $c2;
            }

            public boolean match(@NotNull PngChunk chunk) {
                Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
                return ChunkHelper.INSTANCE.equivalent(chunk, this.$c2);
            }
        });
    }

    public final boolean removeChunk(@Nullable PngChunk c) {
        return c == null ? false : this.queuedChunks.remove(c);
    }

    public final boolean queue(@NotNull PngChunk c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.queuedChunks.add(c);
        return true;
    }

    public final int writeChunks(@NotNull OutputPngStream os, int currentGroup) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        int cont = 0;
        Iterator<PngChunk> it = this.queuedChunks.iterator();
        while (it.hasNext()) {
            int n;
            PngChunk c = it.next();
            if (!ChunksListForWrite.Companion.shouldWrite(c, currentGroup)) continue;
            if (ChunkHelper.INSTANCE.isCritical(c.getId()) && !Intrinsics.areEqual((Object)c.getId(), (Object)"PLTE")) {
                throw new PngjOutputException("bad chunk queued: " + c);
            }
            if (this.alreadyWrittenKeys.containsKey(c.getId()) && !c.allowsMultiple()) {
                throw new PngjOutputException("duplicated chunk does not allow multiple: " + c);
            }
            c.write(os);
            this.getChunks().add(c);
            String string = c.getId();
            if (this.alreadyWrittenKeys.containsKey(c.getId())) {
                Integer n2 = this.alreadyWrittenKeys.get(c.getId());
                Intrinsics.checkNotNull((Object)n2);
                n = ((Number)n2).intValue() + 1;
            } else {
                n = 1;
            }
            this.alreadyWrittenKeys.put(string, n);
            c.setChunkGroup(currentGroup);
            it.remove();
            ++cont;
        }
        return cont;
    }

    @NotNull
    public final List<PngChunk> getQueuedChunks() {
        return this.queuedChunks;
    }

    @Override
    @NotNull
    public String toString() {
        return "ChunkList: written: " + this.getChunks().size() + " queue: " + this.queuedChunks.size();
    }

    @Override
    @NotNull
    public String toStringFull() {
        StringBuilder sb = new StringBuilder(this.toString());
        sb.append("\n Written:\n");
        for (PngChunk chunk : this.getChunks()) {
            sb.append(chunk).append(" G=" + chunk.getChunkGroup() + '\n');
        }
        if (!((Collection)this.queuedChunks).isEmpty()) {
            sb.append(" Queued:\n");
            for (PngChunk chunk : this.queuedChunks) {
                sb.append(chunk).append("\n");
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunksListForWrite$Companion;", "", "()V", "shouldWrite", "", "c", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk;", "currentGroup", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean shouldWrite(PngChunk c, int currentGroup) {
            if (currentGroup == 2) {
                return Intrinsics.areEqual((Object)c.getId(), (Object)"PLTE");
            }
            if (currentGroup % 2 == 0) {
                throw new PngjOutputException("bad chunk group?");
            }
            int minChunkGroup = 0;
            int maxChunkGroup = 0;
            if (c.getOrderingConstraint().mustGoBeforePLTE()) {
                minChunkGroup = maxChunkGroup = 1;
            } else if (c.getOrderingConstraint().mustGoBeforeIDAT()) {
                maxChunkGroup = 3;
                minChunkGroup = c.getOrderingConstraint().mustGoAfterPLTE() ? 3 : 1;
            } else {
                maxChunkGroup = 5;
                minChunkGroup = 1;
            }
            int preferred = maxChunkGroup;
            if (c.hasPriority()) {
                preferred = minChunkGroup;
            }
            if (ChunkHelper.INSTANCE.isUnknown(c) && c.getChunkGroup() > 0) {
                preferred = c.getChunkGroup();
            }
            if (currentGroup == preferred) {
                return true;
            }
            return preferred + 1 <= currentGroup ? currentGroup <= maxChunkGroup : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

