/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.internal.model.Bundle;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Overrides {
    private static final Logger LOGGER = LoggerFactory.getLogger(Overrides.class);
    private static final String OVERRIDE_RANGE = "range";
    private static final String VENDOR_WARNING = "Bundle Vendor has changed, please check if this is intentional. Bundle: ";

    public static List<BundleInfo> override(List<BundleInfo> infos, String overridesUrl) {
        List<Clause> overrides = Overrides.loadOverrides(overridesUrl);
        if (overrides.isEmpty()) {
            return infos;
        }
        try {
            HashMap<String, Manifest> manifests = new HashMap<String, Manifest>();
            for (Clause override : overrides) {
                Manifest manifest = Overrides.getManifest(override.getName());
                manifests.put(override.getName(), manifest);
            }
            ArrayList<BundleInfo> newInfos = new ArrayList<BundleInfo>();
            for (BundleInfo info : infos) {
                Manifest manifest = Overrides.getManifest(info.getLocation());
                if (manifest != null) {
                    String bsn = Overrides.getBundleSymbolicName(manifest);
                    Version ver = Overrides.getBundleVersion(manifest);
                    String ven = Overrides.getBundleVendor(manifest);
                    String url = info.getLocation();
                    for (Clause override : overrides) {
                        VersionRange range;
                        String oBsn;
                        Manifest overMan = (Manifest)manifests.get(override.getName());
                        if (overMan == null || !bsn.equals(oBsn = Overrides.getBundleSymbolicName(overMan))) continue;
                        Version oVer = Overrides.getBundleVersion(overMan);
                        String vr = Overrides.extractVersionRange(override);
                        if (vr == null) {
                            Version v2 = new Version(oVer.getMajor(), oVer.getMinor(), 0);
                            if (v2.equals((Object)oVer)) continue;
                            range = new VersionRange(false, v2, oVer, true);
                        } else {
                            range = VersionRange.parseVersionRange(vr);
                        }
                        String vendor = Overrides.getBundleVendor(overMan);
                        if (ven == null) {
                            if (vendor != null) {
                                LOGGER.warn(VENDOR_WARNING + bsn);
                            }
                        } else if (vendor == null) {
                            LOGGER.warn(VENDOR_WARNING + bsn);
                        } else if (!vendor.equals(ven)) {
                            LOGGER.warn(VENDOR_WARNING + bsn);
                        }
                        if (!range.contains(ver) || ver.compareTo(oVer) >= 0) continue;
                        LOGGER.warn("Overriding original bundle " + url + " to " + override.getName());
                        ver = oVer;
                        url = override.getName();
                    }
                    if (!info.getLocation().equals(url)) {
                        Bundle b = new Bundle();
                        b.setLocation(url);
                        b.setStartLevel(info.getStartLevel());
                        b.setStart(info.isStart());
                        b.setDependency(info.isDependency());
                        newInfos.add(b);
                        continue;
                    }
                    newInfos.add(info);
                    continue;
                }
                newInfos.add(info);
            }
            return newInfos;
        }
        catch (Exception e) {
            LOGGER.info("Unable to process bundle overrides", (Throwable)e);
            return infos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Clause> loadOverrides(String overridesUrl) {
        ArrayList<Clause> overrides;
        block7: {
            overrides = new ArrayList<Clause>();
            try {
                if (overridesUrl == null) break block7;
                InputStream is = new URL(overridesUrl).openStream();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    while ((line = reader.readLine()) != null) {
                        Clause[] cs;
                        if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                        for (Clause c : cs = Parser.parseHeader(line)) {
                            overrides.add(c);
                        }
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (Exception e) {
                LOGGER.debug("Unable to load overrides bundles list", (Throwable)e);
            }
        }
        return overrides;
    }

    private static Version getBundleVersion(Manifest manifest) {
        String ver = manifest.getMainAttributes().getValue("Bundle-Version");
        return VersionTable.getVersion(ver);
    }

    private static String getBundleSymbolicName(Manifest manifest) {
        String bsn = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        bsn = Overrides.stripSymbolicName(bsn);
        return bsn;
    }

    private static String getBundleVendor(Manifest manifest) {
        String ven = manifest.getMainAttributes().getValue("Bundle-Vendor");
        return ven;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(String url) throws IOException {
        InputStream is = new URL(url).openStream();
        try {
            ZipInputStream zis = new ZipInputStream(is);
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                if (!"META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                Manifest manifest = new Manifest(zis);
                return manifest;
            }
            Manifest manifest = null;
            return manifest;
        }
        finally {
            is.close();
        }
    }

    private static String extractVersionRange(Clause override) {
        return override.getAttribute(OVERRIDE_RANGE);
    }

    private static String stripSymbolicName(String symbolicName) {
        Clause[] cs = Parser.parseHeader(symbolicName);
        if (cs == null || cs.length != 1) {
            throw new IllegalArgumentException("Bad Bundle-SymbolicName header: " + symbolicName);
        }
        return cs[0].getName();
    }
}

