/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.mvn.internal.Version;

class VersionRange {
    private final String m_range;
    private final Version m_lowestVersion;
    private final Version m_highestVersion;
    private final boolean m_lowestExclusive;
    private final boolean m_highestExclusive;

    VersionRange(String range) throws IllegalArgumentException {
        NullArgumentException.validateNotEmpty(range, true, "Range");
        if (!range.contains(",")) {
            throw new IllegalArgumentException("Versions in range must be separated by comma.");
        }
        if (!range.startsWith("[") && !range.startsWith("(")) {
            throw new IllegalArgumentException("Range must start with [ or (.");
        }
        if (!range.endsWith("]") && !range.endsWith(")")) {
            throw new IllegalArgumentException("Range must end with [ or (.");
        }
        this.m_range = range;
        String[] versions = this.m_range.split(",");
        if (versions.length > 2) {
            throw new IllegalArgumentException("Range must contain only one comma.");
        }
        versions[0] = versions[0].trim();
        if (versions[0].length() == 1) {
            throw new IllegalArgumentException("Versions in range cannot be empty.");
        }
        versions[1] = versions[1].trim();
        if (versions[1].length() == 1) {
            throw new IllegalArgumentException("Versions in range cannot be empty.");
        }
        this.m_lowestVersion = new Version(versions[0].substring(1));
        this.m_highestVersion = new Version(versions[1].substring(0, versions[1].length() - 1));
        this.m_lowestExclusive = versions[0].startsWith("(");
        this.m_highestExclusive = versions[1].endsWith(")");
    }

    Version getLowestVersion() {
        return this.m_lowestVersion;
    }

    Version getHighestVersion() {
        return this.m_highestVersion;
    }

    boolean includes(Version version) {
        if (version == null) {
            return false;
        }
        int compare = version.compareTo(this.m_lowestVersion);
        if (compare == -1 || compare == 0 && this.m_lowestExclusive) {
            return false;
        }
        compare = version.compareTo(this.m_highestVersion);
        return compare != 1 && (compare != 0 || !this.m_highestExclusive);
    }

    public String toString() {
        return this.m_range;
    }
}

