/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp.extensions.helpers;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.client.subsystem.sftp.RawSftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.extensions.SftpClientExtension;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.subsystem.sftp.SftpException;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractSftpClientExtension
extends AbstractLoggingBean
implements SftpClientExtension,
RawSftpClient {
    private final String name;
    private final SftpClient client;
    private final RawSftpClient raw;
    private final boolean supported;

    protected AbstractSftpClientExtension(String name, SftpClient client, RawSftpClient raw, Collection<String> extras) {
        this(name, client, raw, GenericUtils.isNotEmpty(extras) && extras.contains(name));
    }

    protected AbstractSftpClientExtension(String name, SftpClient client, RawSftpClient raw, Map<String, byte[]> extensions) {
        this(name, client, raw, GenericUtils.isNotEmpty(extensions) && extensions.containsKey(name));
    }

    protected AbstractSftpClientExtension(String name, SftpClient client, RawSftpClient raw, boolean supported) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "No extension name");
        this.client = Objects.requireNonNull(client, "No client instance");
        this.raw = Objects.requireNonNull(raw, "No raw access");
        this.supported = supported;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final SftpClient getClient() {
        return this.client;
    }

    protected void sendAndCheckExtendedCommandStatus(Buffer buffer) throws IOException {
        int reqId = this.sendExtendedCommand(buffer);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendAndCheckExtendedCommandStatus(" + this.getName() + ") id=" + reqId);
        }
        this.checkStatus(this.receive(reqId));
    }

    protected int sendExtendedCommand(Buffer buffer) throws IOException {
        return this.send(200, buffer);
    }

    @Override
    public int send(int cmd, Buffer buffer) throws IOException {
        return this.raw.send(cmd, buffer);
    }

    @Override
    public Buffer receive(int id) throws IOException {
        return this.raw.receive(id);
    }

    @Override
    public final boolean isSupported() {
        return this.supported;
    }

    protected void checkStatus(Buffer buffer) throws IOException {
        if (this.checkExtendedReplyBuffer(buffer) != null) {
            throw new StreamCorruptedException("Unexpected extended reply received");
        }
    }

    public Buffer putTarget(Buffer buffer, Object target) {
        if (target instanceof CharSequence) {
            buffer.putString(target.toString());
        } else if (target instanceof byte[]) {
            buffer.putBytes((byte[])target);
        } else if (target instanceof SftpClient.Handle) {
            buffer.putBytes(((SftpClient.Handle)target).getIdentifier());
        } else {
            throw new UnsupportedOperationException("Unknown target type: " + target);
        }
        return buffer;
    }

    protected Buffer getCommandBuffer(Object target) {
        return this.getCommandBuffer(target, 0);
    }

    protected Buffer getCommandBuffer(Object target, int extraSize) {
        if (target instanceof CharSequence) {
            return this.getCommandBuffer(4 + ((CharSequence)target).length() + extraSize);
        }
        if (target instanceof byte[]) {
            return this.getCommandBuffer(4 + ((byte[])target).length + extraSize);
        }
        if (target instanceof SftpClient.Handle) {
            return this.getCommandBuffer(4 + ((SftpClient.Handle)target).length() + extraSize);
        }
        return this.getCommandBuffer(extraSize);
    }

    protected Buffer getCommandBuffer(int extraSize) {
        String opcode = this.getName();
        ByteArrayBuffer buffer = new ByteArrayBuffer(4 + GenericUtils.length(opcode) + extraSize + 8, false);
        buffer.putString(opcode);
        return buffer;
    }

    protected Buffer checkExtendedReplyBuffer(Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isDebugEnabled()) {
                this.log.debug("checkExtendedReplyBuffer({}}[id={}] - status: {} [{}] {}", new Object[]{this.getName(), id, substatus, lang, msg});
            }
            if (substatus != 0) {
                this.throwStatusException(id, substatus, msg, lang);
            }
            return null;
        }
        if (type == 201) {
            return buffer;
        }
        throw new SshException("Unexpected SFTP packet received: type=" + type + ", id=" + id + ", length=" + length);
    }

    protected void throwStatusException(int id, int substatus, String msg, String lang) throws IOException {
        throw new SftpException(substatus, msg);
    }
}

