/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.util.stream.Collectors;
import org.apache.maven.api.Session;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.services.Request;
import org.apache.maven.api.services.RequestTrace;
import org.apache.maven.impl.InternalSession;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectStepData;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.DependencyRequest;

public final class RequestTraceHelper {
    public static ResolverTrace enter(Session session, Object data) {
        Request req;
        InternalSession iSession = InternalSession.from(session);
        RequestTrace trace = data instanceof Request && (req = (Request)data).getTrace() != null ? req.getTrace() : new RequestTrace(iSession.getCurrentTrace(), data);
        iSession.setCurrentTrace(trace);
        return new ResolverTrace(session, trace.context(), RequestTraceHelper.toResolver(trace), trace);
    }

    public static void exit(ResolverTrace trace) {
        InternalSession iSession = InternalSession.from(trace.session());
        iSession.setCurrentTrace(trace.mvnTrace().parent());
    }

    public static RequestTrace toMaven(String context, org.eclipse.aether.RequestTrace trace) {
        if (trace != null) {
            return new RequestTrace(context, RequestTraceHelper.toMaven(context, trace.getParent()), trace.getData());
        }
        return null;
    }

    public static org.eclipse.aether.RequestTrace toResolver(RequestTrace trace) {
        if (trace != null) {
            return org.eclipse.aether.RequestTrace.newChild((org.eclipse.aether.RequestTrace)RequestTraceHelper.toResolver(trace.parent()), (Object)trace.data());
        }
        return null;
    }

    public static String interpretTrace(boolean detailed, org.eclipse.aether.RequestTrace requestTrace) {
        while (requestTrace != null) {
            Object data = requestTrace.getData();
            if (data instanceof DependencyRequest) {
                DependencyRequest request = (DependencyRequest)data;
                return "dependency resolution for " + String.valueOf(request);
            }
            if (data instanceof CollectRequest) {
                CollectRequest request = (CollectRequest)data;
                return "dependency collection for " + String.valueOf(request);
            }
            if (data instanceof CollectStepData) {
                CollectStepData stepData = (CollectStepData)data;
                String msg = "dependency collection step for " + stepData.getContext();
                if (detailed) {
                    msg = msg + ". Path to offending node from root:\n";
                    msg = msg + stepData.getPath().stream().map(n -> " -> " + n.toString()).collect(Collectors.joining("\n"));
                    msg = msg + "\n => " + String.valueOf(stepData.getNode());
                }
                return msg;
            }
            if (data instanceof ArtifactDescriptorRequest) {
                ArtifactDescriptorRequest request = (ArtifactDescriptorRequest)data;
                return "artifact descriptor request for " + String.valueOf(request.getArtifact());
            }
            if (data instanceof ArtifactRequest) {
                ArtifactRequest request = (ArtifactRequest)data;
                return "artifact request for " + String.valueOf(request.getArtifact());
            }
            if (data instanceof Plugin) {
                Plugin plugin = (Plugin)data;
                return "plugin " + plugin.getId();
            }
            requestTrace = requestTrace.getParent();
        }
        return "n/a";
    }

    public record ResolverTrace(Session session, String context, org.eclipse.aether.RequestTrace trace, RequestTrace mvnTrace) {
    }
}

