# Previous Versions

* [Change Notes for Version 2](./docs/changes/version2.md)

# Version 3

**This is work in progress.**  Version 3 contains many API breaks from version 2. API comparison reports
generated by [japicmp](https://siom79.github.io/japicmp) are published at
[https://apache.github.io/mina-sshd](https://apache.github.io/mina-sshd).

Version 3 includes all the features and bug fixes of [version 2.16.0](./docs/changes/2.16.0.md) and up to
[commit f9887391](https://github.com/apache/mina-sshd/blob/f9887391/CHANGES.md#planned-for-next-version).

## Milestone 1: Pre-Release 3.0.0-M1

Complete refactoring of the SSH transport protocol. New feature: support for client-side proxies.

* [Change notes for 3.0.0-M1](./docs/changes/3.0.0-M1.md)

# Milestone 2: Pre-Release 3.0.0-M2

Refactoring of cryptography. New feature: multi-release JARs for `sshd-common` and `sshd-osgi` and using on
newer Java versions the already built-in cryptographic algorithms for ChaCha20, ed25519, and ML-KEM.

* For building Apache MINA SSHD 3.0, Java >= 24 and Apache Maven >= 3.9.11 are required. Generated artifacts
  still use Java 8 as minimum runtime requirement.

## Bug Fixes

* [GH-502](https://github.com/apache/mina-sshd/issues/502) Don't load security provider classes reflectively
  for Bouncy Castle and `net.i2p.crypto:eddsa:0.3.0`.

## Major Code Re-factoring

* The classes dealing with serializing or de-serializing public and private keys have been de-generified,
  which simplifies them a lot. Previous code from version 2 tried to tie particular public key types and
  private key types together via generics, such that it could be statically checked that only matching key
  types were used. But that never worked well and in a few crucial places unchecked conversions or raw
  types were used anyway, which makes the point moot. Code now just uses `PublicKey` and `PrivateKey` instead
  of generic types, and checks at run-time that keys are of the expected kind.
* The way ed25519 keys are handled has been refactored. Duplicate code has been removed, and the handling
  has been simplified to make it easier to include support for other eddsa implementations. This brings
  additional API breaks, but in code areas that are unlikely to be used in customer code.

## New Features

* [GH-585](https://github.com/apache/mina-sshd/issues/585) Support the JDK built-in ed25519 on Java15+

  With this change `sshd-common` and `sshd-osgi` become MRJARs (multi-release JARs). When run on Java >= 15,
  Apache MINA SSHD will use the built-in ed25519 from the SunEC security provider. On Java < 15, ed25519 is
  supported if Bouncy Castle or `net.i2p.crypto:eddsa:0.3.0` is present.

  On Java >= 15, Apache MINA SSHD will use the JDK ed25519 even if Bouncy Castle or `net.i2p.crypto:eddsa:0.3.0`
  are present. (Including `net.i2p.crypto:eddsa:0.3.0` makes no sense on Java >= 15.) There is a new
  [registrar](./docs/security-providers.md) `SunECSecurityProviderRegistrar` with the name "SunECWrapper". It
  is by default registered ahead of the Bouncy Castle or net.i2p registrars, and has by default ed25519,
  X25519, and X448 enabled if SunEC is registered and has these algorithms. This new registrar can be 
  configured like any other registrar via system properties; in particular it can also be disabled via system
  property `org.apache.sshd.security.provider.SunECWrapper.enabled=false`.

  The sole purpose of this new registrar is to prefer the SunEC implementations of ed25519, X25519, or X448 over
  the Bouncy Castle or net.i2p implementations if Bouncy Castle or net.i2p are also available.

* Use the JDK's built-in ChaCha20 cipher on Java11+

  With `sshd-common` being a MRJAR, it is finally possible to use the JDK's built-in ChaCha20 cipher for the
  chacha20-poly1305@<!-- -->openssh.com cipher on Java >= 11. This brings a substantial speed-up for this
  encryption. On Java < 11, Apache MINA SSHD still uses its own implementation written in Java.
  
  (Note that one cannot use the JDK's "ChaCha20-Poly1305" cipher for SSH; Java implements
  [RFC 8439](https://datatracker.ietf.org/doc/html/rfc8439), which has a different AEAD tag construction than
  the version used in SSH. Since the Poly1305 MAC in Java is not accessible separately (see
  [JDK-8253394](https://bugs.openjdk.org/browse/JDK-8253394)), Apache MINA SSHD still has to use its own
  implementation for that part.)

* [GH-803](https://github.com/apache/mina-sshd/issues/803) Support the JDK built-in ML-KEMs on Java24+

  Use the ML-KEM implementations from SunJCE if run on Java >= 24. For Java < 24, the Bouncy Castle implementations
  are used. The SunJCE ML-KEMs are advertised in the `SunJCESecurityProviderRegistrar`.

* OSGi: the upper bound of the version range for package imports from `org.bouncycastle.*` has been raised from 2.0.0
  to 3.0.0. This enables using BC-FIPS in an OSGi environment. BC-FIPS provides OSGi manifests as of version 2.1.0.
